/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.internal.util.factory.MarkupNames;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.ProductDescriptionAware;
import org.eclipse.net4j.util.factory.PropertiesFactory;
import org.eclipse.net4j.util.factory.TreeFactory;

public final class SimpleFactory
extends Factory
implements MarkupNames {
    private final IConfigurationElement configurationElement;

    public SimpleFactory(IConfigurationElement configurationElement) {
        super(SimpleFactory.productGroup(configurationElement), SimpleFactory.type(configurationElement));
        this.configurationElement = configurationElement;
    }

    @Override
    public Object create(String description) throws ProductCreationException {
        try {
            Object product = this.configurationElement.createExecutableExtension("productClass");
            if (product != null) {
                String setterName = this.configurationElement.getAttribute("setterName");
                SimpleFactory.configure(product, description, setterName);
            }
            return product;
        }
        catch (Exception ex) {
            throw this.productCreationException(description, ex);
        }
    }

    public static void configure(Object product, String description, String setterName) throws NoSuchMethodException {
        if (!StringUtil.isEmpty(setterName)) {
            Method treeSetter = SimpleFactory.setter(product, setterName, Tree.class);
            if (treeSetter != null) {
                Tree tree = TreeFactory.parseTree(description);
                ReflectUtil.invokeMethod(treeSetter, product, tree);
                return;
            }
            Method propertiesSetter = SimpleFactory.setter(product, setterName, Map.class);
            if (propertiesSetter != null) {
                Map<String, String> properties = PropertiesFactory.parseProperties(description);
                ReflectUtil.invokeMethod(propertiesSetter, product, properties);
                return;
            }
            Method descriptionSetter = SimpleFactory.setter(product, setterName, String.class);
            if (descriptionSetter != null) {
                ReflectUtil.invokeMethod(descriptionSetter, product, description);
                return;
            }
            throw new NoSuchMethodException("Class " + product.getClass().getName() + " has no " + setterName + "(Map<String, String>) and no " + setterName + "(String) method");
        }
        if (product instanceof ProductDescriptionAware) {
            ((ProductDescriptionAware)product).setDescription(description);
            return;
        }
    }

    private static String productGroup(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute("productGroup");
    }

    private static String type(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute("type");
    }

    private static Method setter(Object product, String name, Class<?> paramType) {
        return ReflectUtil.getMethodOrNull(product.getClass(), name, paramType);
    }
}

