/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.io.File;
import java.text.Format;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.mat.inspections.FindLeaksQuery;
import org.eclipse.mat.inspections.LeakHunterQuery;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.BytesFormat;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.registry.Converters;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="leakhunter2")
@Icon(value="/META-INF/icons/leak.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/runningleaksuspectreport.html#task_runningleaksuspectreport__compare")
public class LeakHunterQuery2
extends LeakHunterQuery {
    @Argument(advice=Argument.Advice.SECONDARY_SNAPSHOT)
    public ISnapshot baseline;
    @Argument(isMandatory=false)
    public String options = "-prefix";
    @Argument(isMandatory=false)
    public Pattern mask = Pattern.compile("\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$|(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])");
    @Argument(isMandatory=false, flag="x")
    public String[] extraReferences = new String[]{"java.util.HashMap$Node:key", "java.util.Hashtable$Entry:key", "java.util.WeakHashMap$Entry:referent", "java.util.concurrent.ConcurrentHashMap$Node:key"};
    @Argument(isMandatory=false, flag="xfile")
    public File extraReferencesListFile;
    CompositeResult.Entry savedResult;
    String savedcmd;

    @Override
    public IResult execute(IProgressListener listener) throws Exception {
        IResult res;
        SimpleMonitor monitor = new SimpleMonitor(Messages.LeakHunterQuery2_ProgressName, listener, new int[]{1, 999});
        Histogram dummy = this.snapshot.getHistogram(new int[0], monitor.nextMonitor());
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Format f = (dummy = dummy.diffWithBaseline(dummy)).getColumns()[2].getFormatter();
        if (f instanceof BytesFormat) {
            this.bytesFormatter = (BytesFormat)f;
        }
        if ((res = super.execute(monitor.nextMonitor())) instanceof SectionSpec) {
            QuerySpec spec = new QuerySpec(this.savedResult.getName());
            spec.setResult(this.savedResult.getResult());
            spec.setCommand(this.savedcmd);
            StringBuilder opts = new StringBuilder("-mode DIFF_RATIO_TO_FIRST");
            if (this.options != null) {
                opts.append(' ').append(this.options);
            }
            if (this.mask != null) {
                opts.append(" -mask ").append(Converters.convertAndEscape(Pattern.class, (Object)this.mask));
            }
            if (this.extraReferences != null) {
                opts.append(" -x ");
                String[] stringArray = this.extraReferences;
                int n = this.extraReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    opts.append(" ").append(Converters.convertAndEscape(String.class, (Object)e));
                    ++n2;
                }
            }
            if (this.extraReferencesListFile != null) {
                opts.append(" -xfile ").append(Converters.convertAndEscape(File.class, (Object)this.extraReferencesListFile));
            }
            spec.setCommand("simplecomparison -query \"dominator_tree -groupby NONE\" -retained PRECISE -baseline " + Converters.convertAndEscape(String.class, (Object)this.baseline.getSnapshotInfo().getPath()) + " -defaultoptions \"\"" + " -options " + Converters.convertAndEscape(String.class, (Object)opts.toString()));
            spec.set("html.collapsed", Boolean.TRUE.toString());
            spec.set("sort_column", "#5");
            spec.set("hide_column", "#7,#8,#9");
            ((SectionSpec)res).add((Spec)spec);
        }
        listener.done();
        return res;
    }

    @Override
    FindLeaksQuery.SuspectsResultTable callFindLeaks(IProgressListener listener) throws Exception {
        String querycmd = "find_leaks2";
        StringBuilder cmd = new StringBuilder(querycmd);
        SnapshotQuery query = SnapshotQuery.parse(querycmd, this.snapshot).setArgument("threshold_percent", this.threshold_percent).setArgument("max_paths", this.max_paths).setArgument("excludes", this.excludes).setArgument("baseline", this.baseline);
        if (this.options != null) {
            query.setArgument("options", this.options);
        }
        cmd.append(" -threshold_percent ").append(this.threshold_percent);
        cmd.append(" -max_paths ").append(this.max_paths);
        this.addExcludes(cmd);
        cmd.append(" -baseline ").append(Converters.convertAndEscape(String.class, (Object)this.baseline.getSnapshotInfo().getPath()));
        if (this.mask != null) {
            query.setArgument("mask", this.mask);
            cmd.append(" ").append("-mask ").append(Converters.convertAndEscape(Pattern.class, (Object)this.mask));
        }
        if (this.extraReferences != null) {
            query.setArgument("extraReferences", Arrays.asList(this.extraReferences));
            cmd.append(" ").append("-x ");
            String[] stringArray = this.extraReferences;
            int n = this.extraReferences.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                cmd.append(" ").append(Converters.convertAndEscape(String.class, (Object)e));
                ++n2;
            }
        }
        if (this.extraReferencesListFile != null) {
            query.setArgument("extraReferencesListFile", this.extraReferencesListFile);
            cmd.append(" -xfile ").append(Converters.convertAndEscape(File.class, (Object)this.extraReferencesListFile));
        }
        this.savedcmd = cmd.toString();
        IResult ret = query.execute(listener);
        if (ret instanceof CompositeResult) {
            CompositeResult cr = (CompositeResult)ret;
            this.savedResult = (CompositeResult.Entry)cr.getResultEntries().get(0);
            return (FindLeaksQuery.SuspectsResultTable)((CompositeResult.Entry)cr.getResultEntries().get(1)).getResult();
        }
        return (FindLeaksQuery.SuspectsResultTable)ret;
    }

    static String escape(String s) {
        if ((s = s.replaceAll("\\\\(?=\\\\)|\\\\(?=\")|\"", "\\\\$0")).indexOf(32) >= 0) {
            return "\"" + s + "\"";
        }
        return s;
    }
}

