/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.AbstractJavaCorrectionPropsoal;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;

public class ChangeReturnTypeCorrectionProposal
extends AbstractJavaCorrectionPropsoal {
    private TypeDeclaration implTypeDeclaration;
    private MethodDeclaration implMethodDeclaration;
    private String endpointInterface;

    public ChangeReturnTypeCorrectionProposal(IInvocationContext invocationContext, TypeDeclaration implTypeDeclaration, MethodDeclaration implMethodDeclaration, String endpointInterface, String displayString, int relevance, Image image) {
        super(invocationContext, displayString, relevance, image);
        this.implTypeDeclaration = implTypeDeclaration;
        this.implMethodDeclaration = implMethodDeclaration;
        this.endpointInterface = endpointInterface;
    }

    @Override
    public void addEdits(TextFileChange textChange) throws CoreException {
        MethodDeclaration seiMethodDeclaration = this.getSEIMethodDeclaration();
        if (seiMethodDeclaration == null) {
            return;
        }
        ICompilationUnit compilationUnit = this.invocationContext.getCompilationUnit();
        CompilationUnit astRoot = this.invocationContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        ITypeBinding returnType = seiMethodDeclaration.resolveBinding().getReturnType();
        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)compilationUnit, (boolean)true);
        Type type = importRewrite.addImport(returnType, ast);
        rewriter.set((ASTNode)this.implMethodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
        rewriter.set((ASTNode)this.implMethodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
        textChange.addEdit(rewriter.rewriteAST());
        if (importRewrite.hasRecordedChanges()) {
            textChange.addEdit(importRewrite.rewriteImports(null));
        }
    }

    private MethodDeclaration getSEIMethodDeclaration() {
        CompilationUnit implCompilationUnit;
        if (this.implTypeDeclaration.getParent() instanceof CompilationUnit && (implCompilationUnit = (CompilationUnit)this.implTypeDeclaration.getParent()).getJavaElement() instanceof ICompilationUnit) {
            try {
                IJavaProject javaProject = implCompilationUnit.getJavaElement().getJavaProject();
                IType seiType = javaProject.findType(this.endpointInterface);
                if (seiType != null) {
                    ICompilationUnit seiCompilationUnit = seiType.getCompilationUnit();
                    CompilationUnit seiASTRoot = this.getAST(seiCompilationUnit);
                    List<MethodDeclaration> seiMethodDeclarations = this.getMethodDeclarations(seiASTRoot);
                    for (MethodDeclaration seiMethodDeclaration : seiMethodDeclarations) {
                        if (!AnnotationUtils.compareMethods((MethodDeclaration)this.implMethodDeclaration, (MethodDeclaration)seiMethodDeclaration)) continue;
                        return seiMethodDeclaration;
                    }
                }
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }
        return null;
    }

    private List<MethodDeclaration> getMethodDeclarations(CompilationUnit compilationUnit) {
        final ArrayList<MethodDeclaration> methodDeclarations = new ArrayList<MethodDeclaration>();
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration methodDeclaration) {
                methodDeclarations.add(methodDeclaration);
                return false;
            }
        });
        return methodDeclarations;
    }
}

