/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.features;

import org.eclipse.graphiti.examples.mm.filesystem.File;
import org.eclipse.graphiti.examples.mm.filesystem.FilesystemFactory;
import org.eclipse.graphiti.examples.mm.filesystem.Folder;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateInnerFileFeature
extends AbstractCustomFeature {
    public CreateInnerFileFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Create File";
    }

    public String getDescription() {
        return "Creates a new file inside this folder";
    }

    public boolean isAvailable(IContext context) {
        return this.getFolderDomainObject(context) != null;
    }

    public boolean canExecute(ICustomContext context) {
        return this.getFolderDomainObject((IContext)context) != null;
    }

    public void execute(ICustomContext context) {
        Folder folder = this.getFolderDomainObject((IContext)context);
        String newName = this.createNewName(folder);
        File file = FilesystemFactory.eINSTANCE.createFile();
        file.setName(newName);
        folder.eResource().getContents().add((Object)file);
        folder.getFiles().add((Object)file);
    }

    private Folder getFolderDomainObject(IContext context) {
        PictogramElement pictogramElement;
        Object domainObject;
        PictogramElement[] pictogramElements;
        if (context instanceof ICustomContext && (pictogramElements = ((ICustomContext)context).getPictogramElements()).length == 1 && (domainObject = this.getBusinessObjectForPictogramElement(pictogramElement = pictogramElements[0])) instanceof Folder) {
            return (Folder)domainObject;
        }
        return null;
    }

    private String createNewName(Folder folder) {
        String initialName = "NewFile";
        Object name = initialName;
        int number = 0;
        while (this.findFile(folder, (String)name) != null) {
            name = initialName + ++number;
        }
        return name;
    }

    private File findFile(Folder folder, String name) {
        for (File file : folder.getFiles()) {
            if (!name.equals(file.getName())) continue;
            return file;
        }
        return null;
    }
}

