/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.server;

import java.util.HashMap;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CLanguageServerRegistry {
    private static final String EXTENSION_ID = "org.eclipse.cdt.lsp.serverProvider";
    private static final String SERVER_ELEMENT = "server";
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private final IExtensionPoint cExtensionPoint;
    private ICLanguageServerProvider prioritizedProvider = null;
    private Priority highestPrio = Priority.low;

    public CLanguageServerRegistry() {
        this.cExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_ID);
    }

    public ICLanguageServerProvider createCLanguageServerProvider() {
        this.prioritizedProvider = null;
        this.highestPrio = Priority.low;
        HashMap<Priority, ICLanguageServerProvider> providers = new HashMap<Priority, ICLanguageServerProvider>();
        IConfigurationElement[] iConfigurationElementArray = this.cExtensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageServerProvider provider;
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (SERVER_ELEMENT.equals(configurationElement.getName()) && (provider = (ICLanguageServerProvider)this.getInstanceFromExtension(configurationElement, ICLanguageServerProvider.class)) != null) {
                providers.put(Priority.valueOf(configurationElement.getAttribute(PRIORITY)), provider);
            }
            ++n2;
        }
        if (providers.isEmpty()) {
            Platform.getLog(this.getClass()).warn("No C/C++ language server defined");
        } else {
            providers.forEach((key, value) -> {
                if (key.compareTo(this.highestPrio) >= 0) {
                    this.highestPrio = key;
                    this.prioritizedProvider = value;
                }
            });
        }
        return this.prioritizedProvider;
    }

    private <T> Object getInstanceFromExtension(IConfigurationElement configurationElement, Class<T> clazz) {
        Object result = null;
        try {
            Object obj = configurationElement.createExecutableExtension(CLASS);
            result = Adapters.adapt((Object)obj, clazz);
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).log(e.getStatus());
        }
        return result;
    }

    private static enum Priority {
        low,
        normal,
        high;

    }
}

