/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private final IWorkbenchPart fTargetPart;
    private final IVerticalRulerInfo fRulerInfo;

    public AbstractBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo info) {
        Assert.isTrue((boolean)(part instanceof ITextEditor));
        this.fTargetPart = part;
        this.fRulerInfo = info;
    }

    protected IBreakpoint getBreakpoint() {
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            return CDebugUIUtils.getBreakpointFromEditor((ITextEditor)targetPart, this.getVerticalRulerInfo());
        }
        return null;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRulerInfo;
    }
}

