/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.core.runtime.CoreException;

public class EvalBinary
extends CPPDependentEvaluation {
    public static final int op_arrayAccess = 127;
    private final int fOperator;
    private final ICPPEvaluation fArg1;
    private final ICPPEvaluation fArg2;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private ICPPEvaluation fOverloadCall;
    private IType fType;
    private IType fCommonType;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalBinary(int operator, ICPPEvaluation arg1, ICPPEvaluation arg2, IASTNode pointOfDefinition) {
        this(operator, arg1, arg2, EvalBinary.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinary(int operator, ICPPEvaluation arg1, ICPPEvaluation arg2, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fArg1 = arg1;
        this.fArg2 = arg2;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public ICPPEvaluation getArg1() {
        return this.fArg1;
    }

    public ICPPEvaluation getArg2() {
        return this.fArg2;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            ICPPFunction overload;
            this.fType = this.isTypeDependent() ? new TypeOfDependentExpression(this) : ((overload = this.getOverload()) != null ? ExpressionTypes.restoreTypedefs(ExpressionTypes.typeFromFunctionCall(overload), this.fArg1.getType(), this.fArg2.getType()) : this.computeType());
        }
        if (this.fType instanceof CPPBasicType) {
            this.fType = ((CPPBasicType)this.fType).clone(-1073741825);
        }
        return this.fType;
    }

    private IType getCommonType() {
        if (this.fCommonType == null) {
            this.fCommonType = this.computeCommonType();
        }
        return this.fCommonType;
    }

    private ICPPEvaluation createOperatorOverloadEvaluation(ICPPFunction overload, ICPPEvaluation arg1, ICPPEvaluation arg2) {
        EvalFunctionCall operatorCall;
        IASTNode point = CPPSemantics.getCurrentLookupPoint();
        if (overload instanceof ICPPMethod) {
            EvalMemberAccess opAccess = new EvalMemberAccess(arg1.getType(), IASTExpression.ValueCategory.LVALUE, (IBinding)overload, arg1, false, point);
            ICPPEvaluation[] args = new ICPPEvaluation[]{opAccess, arg2};
            operatorCall = new EvalFunctionCall(args, arg1, point);
        } else {
            EvalBinding op = new EvalBinding((IBinding)overload, (IType)overload.getType(), point);
            ICPPEvaluation[] args = new ICPPEvaluation[]{op, arg1, arg2};
            operatorCall = new EvalFunctionCall(args, null, point);
        }
        return operatorCall;
    }

    private boolean operatorAllowsContextualConversion() {
        return this.fOperator == 15 || this.fOperator == 16;
    }

    @Override
    public IValue getValue() {
        IASTExpression.ValueCategory sourceCategory;
        IType sourceType;
        IASTExpression.ValueCategory targetCategory;
        IType targetType;
        IType type;
        ICPPEvaluation arg1 = this.fArg1;
        ICPPEvaluation arg2 = this.fArg2;
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            IType[] parameterTypes = SemanticUtil.getParameterTypesIncludingImplicitThis(overload);
            if (parameterTypes.length >= 2) {
                boolean allowContextualConversion = this.operatorAllowsContextualConversion();
                arg1 = EvalBinary.maybeApplyConversion(this.fArg1, parameterTypes[0], allowContextualConversion, true);
                arg2 = EvalBinary.maybeApplyConversion(this.fArg2, parameterTypes[1], allowContextualConversion, true);
            } else {
                CCorePlugin.log(4, "Unexpected overload for binary operator " + this.fOperator + ": '" + overload.getName() + "'");
            }
            if (!(overload instanceof CPPImplicitFunction)) {
                if (!overload.isConstexpr()) {
                    return IntegralValue.ERROR;
                }
                if (this.fOverloadCall == null) {
                    this.fOverloadCall = this.createOperatorOverloadEvaluation(overload, arg1, arg2);
                }
                return this.fOverloadCall.getValue();
            }
        }
        boolean isWithAssignment = EvalBinary.isBinaryOperationWithAssignment(this.fOperator);
        if ((this.fOperator == 17 || isWithAssignment) && !SemanticUtil.isValidType(type = EvalBinary.computeTypeForAssignment(targetType = this.fArg1.getType(), targetCategory = this.fArg1.getValueCategory(), sourceType = isWithAssignment ? this.getCommonType() : this.fArg2.getType(), sourceCategory = isWithAssignment ? IASTExpression.ValueCategory.XVALUE : this.fArg2.getValueCategory()))) {
            return IntegralValue.ERROR;
        }
        IValue v1 = arg1.getValue();
        if (v1 == null || v1 == IntegralValue.UNKNOWN) {
            return IntegralValue.UNKNOWN;
        }
        IValue v2 = arg2.getValue();
        if (v2 == null || v2 == IntegralValue.UNKNOWN) {
            return IntegralValue.UNKNOWN;
        }
        switch (this.fOperator) {
            case 28: {
                if (!v1.equals(v2)) break;
                return IntegralValue.create(true);
            }
            case 29: {
                if (!v1.equals(v2)) break;
                return IntegralValue.create(false);
            }
            case 17: {
                return v2;
            }
        }
        Number num1 = v1.numberValue();
        if (num1 != null) {
            if (num1 instanceof Long && num1.longValue() == 0L ? this.fOperator == 15 : this.fOperator == 16) {
                return v1;
            }
            Number num2 = v2.numberValue();
            if (num2 != null) {
                return ValueFactory.evaluateBinaryExpression(this.fOperator, v1, v2, this.getCommonType());
            }
        }
        return DependentValue.create(this);
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fType != null) {
            return this.fType instanceof TypeOfDependentExpression;
        }
        return this.fArg1.isTypeDependent() || this.fArg2.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        return this.fArg1.isValueDependent() || this.fArg2.isValueDependent();
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalBinary)) {
            return false;
        }
        EvalBinary o = (EvalBinary)other;
        return this.fOperator == o.fOperator && this.fArg1.isEquivalentTo(o.fArg1) && this.fArg2.isEquivalentTo(o.fArg2);
    }

    private boolean computeIsConstantExpression() {
        return this.fArg1.isConstantExpression() && this.fArg2.isConstantExpression() && EvalBinary.isNullOrConstexprFunc(this.getOverload());
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        if (this.isTypeDependent()) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        switch (this.fOperator) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 127: {
                return IASTExpression.ValueCategory.LVALUE;
            }
            case 30: {
                if (this.getType() instanceof ICPPFunctionType) break;
                return this.fArg1.getValueCategory();
            }
            case 31: {
                if (this.getType() instanceof ICPPFunctionType) break;
                return IASTExpression.ValueCategory.LVALUE;
            }
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public ICPPFunction getOverload() {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload();
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload() {
        if (this.isTypeDependent()) {
            return null;
        }
        if (this.fOperator == 127) {
            IType type = this.fArg1.getType();
            if ((type = SemanticUtil.getNestedType(type, 13)) instanceof ICPPClassType) {
                return CPPSemantics.findOverloadedBinaryOperator(this.getTemplateDefinitionScope(), OverloadableOperator.BRACKET, this.fArg1, this.fArg2);
            }
        } else {
            OverloadableOperator op = OverloadableOperator.fromBinaryExpression(this.fOperator);
            if (op != null) {
                return CPPSemantics.findOverloadedBinaryOperator(this.getTemplateDefinitionScope(), op, this.fArg1, this.fArg2);
            }
        }
        return null;
    }

    private static IType computeTypeForAssignment(IType targetType, IASTExpression.ValueCategory targetCategory, IType sourceType, IASTExpression.ValueCategory sourceCategory) {
        if (targetCategory != IASTExpression.ValueCategory.LVALUE) {
            return ProblemType.ASSIGNMENT_TO_RVALUE;
        }
        IType targetNested = SemanticUtil.getNestedType(targetType, 5);
        if (TypeTraits.isFunction(targetNested) || SemanticUtil.isConst(targetNested)) {
            return ProblemType.ASSIGNMENT_TO_NON_MODIFIABLE_LVALUE;
        }
        Cost cost = null;
        try {
            IType targetT = SemanticUtil.getNestedType(targetType, 21);
            cost = Conversions.checkImplicitConversionSequence(targetT, sourceType, IASTExpression.ValueCategory.XVALUE, Conversions.UDCMode.ALLOWED, Conversions.Context.ORDINARY, false);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        if (cost == null || !cost.converts()) {
            return ProblemType.NO_CONVERSION_FOR_EXPRESSION;
        }
        return targetType;
    }

    public IType computeType() {
        ICPPFunction o = this.getOverload();
        if (o != null) {
            return ExpressionTypes.typeFromFunctionCall(o);
        }
        boolean isWithAssignment = EvalBinary.isBinaryOperationWithAssignment(this.fOperator);
        if (this.fOperator == 17 || isWithAssignment) {
            IType targetType = this.fArg1.getType();
            IASTExpression.ValueCategory targetCategory = this.fArg1.getValueCategory();
            IType sourceType = isWithAssignment ? this.getCommonType() : this.fArg2.getType();
            IASTExpression.ValueCategory sourceCategory = isWithAssignment ? IASTExpression.ValueCategory.XVALUE : this.fArg2.getValueCategory();
            return EvalBinary.computeTypeForAssignment(targetType, targetCategory, sourceType, sourceCategory);
        }
        switch (this.fOperator) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return CPPBasicType.BOOLEAN;
            }
            case 35: {
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
        }
        return this.getCommonType();
    }

    private IType computeCommonType() {
        IType originalType1 = this.fArg1.getType();
        IType type1 = ExpressionTypes.prvalueTypeWithResolvedTypedefs(originalType1);
        if (type1 instanceof ISemanticProblem) {
            return type1;
        }
        IType originalType2 = this.fArg2.getType();
        IType type2 = ExpressionTypes.prvalueTypeWithResolvedTypedefs(originalType2);
        if (type2 instanceof ISemanticProblem) {
            return type2;
        }
        IType type = CPPArithmeticConversion.convertCppOperandTypes(this.fOperator, type1, type2);
        if (type != null) {
            return ExpressionTypes.restoreTypedefs(type, originalType1, originalType2);
        }
        switch (this.fOperator) {
            case 127: {
                if (type1 instanceof IPointerType) {
                    return ExpressionTypes.glvalueType(((IPointerType)type1).getType());
                }
                if (type2 instanceof IPointerType) {
                    return ExpressionTypes.glvalueType(((IPointerType)type2).getType());
                }
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
            case 4: {
                if (type1 instanceof IPointerType) {
                    return ExpressionTypes.restoreTypedefs(type1, originalType1);
                }
                if (!(type2 instanceof IPointerType)) break;
                return ExpressionTypes.restoreTypedefs(type2, originalType2);
            }
            case 5: {
                if (!(type1 instanceof IPointerType)) break;
                if (type2 instanceof IPointerType) {
                    return CPPVisitor.getPointerDiffType();
                }
                return originalType1;
            }
            case 30: 
            case 31: {
                if (type2 instanceof ICPPPointerToMemberType) {
                    IType t = ((ICPPPointerToMemberType)type2).getType();
                    if (t instanceof ICPPFunctionType) {
                        return t;
                    }
                    if (this.fOperator == 30 && this.fArg1.getValueCategory() == IASTExpression.ValueCategory.PRVALUE) {
                        return ExpressionTypes.prvalueType(t);
                    }
                    return ExpressionTypes.glvalueType(t);
                }
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
        }
        return type1;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)1);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalEvaluation(this.fArg1, includeValue);
        buffer.marshalEvaluation(this.fArg2, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        ICPPEvaluation arg1 = buffer.unmarshalEvaluation();
        ICPPEvaluation arg2 = buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalBinary(op, arg1, arg2, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation arg1 = this.fArg1.instantiate(context, maxDepth);
        ICPPEvaluation arg2 = this.fArg2.instantiate(context, maxDepth);
        if (arg1 == this.fArg1 && arg2 == this.fArg2) {
            return this;
        }
        return new EvalBinary(this.fOperator, arg1, arg2, this.getTemplateDefinition());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        EvalBinary eval;
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            ICPPEvaluation operatorCall = this.createOperatorOverloadEvaluation(overload, this.fArg1, this.fArg2);
            return operatorCall.computeForFunctionCall(record, context);
        }
        EvalUtil.Pair<ICPPEvaluation, ICPPEvaluation> vp1 = EvalUtil.getValuePair(this.fArg1, record, context);
        ICPPEvaluation updateable1 = vp1.getFirst();
        ICPPEvaluation fixed1 = vp1.getSecond();
        EvalUtil.Pair<ICPPEvaluation, ICPPEvaluation> vp2 = EvalUtil.getValuePair(this.fArg2, record, context);
        ICPPEvaluation fixed2 = vp2.getSecond();
        EvalBinary evalBinary = eval = fixed1 == this.fArg1 && fixed2 == this.fArg2 ? this : new EvalBinary(this.fOperator, fixed1, fixed2, this.getTemplateDefinition());
        if (EvalBinary.isBinaryOperationWithAssignment(this.fOperator)) {
            if (this.isPointerToArray(fixed1) && this.hasIntType(fixed2)) {
                EvalPointer evalPointer = (EvalPointer)fixed1;
                int currentPos = evalPointer.getPosition();
                int rhs = fixed2.getValue().numberValue().intValue();
                if (this.fOperator == 21) {
                    evalPointer.setPosition(currentPos + rhs);
                    return eval;
                }
                if (this.fOperator != 22) return EvalFixed.INCOMPLETE;
                evalPointer.setPosition(currentPos - rhs);
                return eval;
            }
            if (updateable1 == EvalFixed.INCOMPLETE) {
                return EvalFixed.INCOMPLETE;
            }
            int binaryOperator = EvalBinary.getBinaryOperatorWithoutAssignment(this.fOperator);
            EvalBinary binaryOpEval = new EvalBinary(binaryOperator, fixed1, fixed2, this.getTemplateDefinition());
            EvalBinary assignmentEval = new EvalBinary(17, updateable1, (ICPPEvaluation)binaryOpEval, this.getTemplateDefinition());
            return assignmentEval.computeForFunctionCall(record, context);
        }
        if (this.fOperator == 17) {
            ICPPEvaluation newValue = null;
            newValue = fixed2 instanceof EvalPointer ? fixed2 : new EvalFixed(fixed2.getType(), fixed2.getValueCategory(), fixed2.getValue());
            if (updateable1 instanceof EvalReference && !(updateable1 instanceof EvalPointer)) {
                EvalReference evalRef = (EvalReference)updateable1;
                evalRef.update(newValue);
                return updateable1;
            }
            if (updateable1 instanceof EvalCompositeAccess) {
                EvalCompositeAccess evalCompAccess = (EvalCompositeAccess)updateable1;
                evalCompAccess.update(newValue);
                return updateable1;
            }
            if (!(updateable1 instanceof EvalBinding)) return updateable1;
            EvalBinding evalBinding = (EvalBinding)updateable1;
            record.update(evalBinding.getBinding(), newValue);
            return updateable1;
        }
        if (this.fOperator == 127) {
            Number numericValue = fixed2.getValue().numberValue();
            if (numericValue == null) {
                return EvalFixed.INCOMPLETE;
            }
            ICPPEvaluation composite = fixed1;
            int arrayIndex = numericValue.intValue();
            if (!(fixed1 instanceof EvalPointer)) return new EvalCompositeAccess(composite, arrayIndex);
            ICPPEvaluation elementEval = ((EvalPointer)fixed1).getTargetEvaluation();
            if (!(elementEval instanceof EvalCompositeAccess)) return new EvalCompositeAccess(composite, arrayIndex);
            composite = ((EvalCompositeAccess)elementEval).getParent();
            arrayIndex += ((EvalPointer)fixed1).getPosition();
            return new EvalCompositeAccess(composite, arrayIndex);
        }
        if ((this.isArray(fixed1) || this.isArray(fixed2)) && (this.hasIntType(fixed1) || this.hasIntType(fixed2))) {
            int offset = this.hasIntType(fixed1) ? fixed1.getValue().numberValue().intValue() : fixed2.getValue().numberValue().intValue();
            EvalCompositeAccess evalCompositeAccess = new EvalCompositeAccess(this.isArray(fixed1) ? fixed1 : fixed2, offset);
            return new EvalPointer(record, evalCompositeAccess, evalCompositeAccess.getTemplateDefinition());
        }
        if (!this.isPointerToArray(fixed1)) {
            if (!this.isPointerToArray(fixed2)) return eval;
        }
        if (!this.hasIntType(fixed1)) {
            if (!this.hasIntType(fixed2)) return eval;
        }
        EvalPointer pointer = this.isPointerToArray(fixed1) ? ((EvalPointer)fixed1).copy() : ((EvalPointer)fixed2).copy();
        pointer.setPosition(eval.getValue().numberValue().intValue());
        return pointer;
    }

    private boolean hasIntType(ICPPEvaluation arg2) {
        IType type = arg2.getType();
        return type instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eInt;
    }

    private boolean isArray(ICPPEvaluation eval) {
        return eval.getType() instanceof IArrayType;
    }

    private boolean isPointerToArray(ICPPEvaluation argument) {
        if (argument instanceof EvalPointer) {
            EvalPointer evalPointer = (EvalPointer)argument;
            ICPPEvaluation pointerValue = evalPointer.dereference().getTargetEvaluation();
            return pointerValue instanceof EvalCompositeAccess;
        }
        return false;
    }

    private static boolean isBinaryOperationWithAssignment(int operator) {
        switch (operator) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private static int getBinaryOperatorWithoutAssignment(int operator) {
        switch (operator) {
            case 25: {
                return 12;
            }
            case 27: {
                return 14;
            }
            case 26: {
                return 13;
            }
            case 19: {
                return 2;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 5;
            }
            case 18: {
                return 1;
            }
            case 20: {
                return 3;
            }
            case 23: {
                return 6;
            }
            case 24: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Operator must be binary operation with assignment");
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.combinePackSize(this.fArg1.determinePackSize(tpMap), this.fArg2.determinePackSize(tpMap));
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fArg1.referencesTemplateParameter() || this.fArg2.referencesTemplateParameter();
    }

    public String toString() {
        return this.fArg1.toString() + " <op> " + this.fArg2.toString();
    }

    @Override
    public boolean isNoexcept() {
        ICPPFunction overload = this.getOverload();
        if (overload != null && !EvalUtil.evaluateNoexceptSpecifier(overload.getType().getNoexceptSpecifier())) {
            return false;
        }
        return this.fArg1.isNoexcept() && this.fArg2.isNoexcept();
    }
}

