/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend2.lib;

import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.DefaultLineDelimiter;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtend2.lib.WhitespaceMatcher;

@GwtCompatible
public class StringConcatenation
implements CharSequence {
    public static final String DEFAULT_LINE_DELIMITER = DefaultLineDelimiter.get();
    private static final int SEGMENTS_SIZE_INCREMENT = 16;
    private static final int SEGMENTS_INITIAL_SIZE = 48;
    private final ArrayList<String> segments = new ArrayList(48);
    private int lastSegmentsSize = 48;
    private String cachedToString;
    private final String lineDelimiter;

    public StringConcatenation() {
        this(DEFAULT_LINE_DELIMITER);
    }

    public StringConcatenation(String lineDelimiter) {
        if (lineDelimiter == null || lineDelimiter.length() == 0) {
            throw new IllegalArgumentException("lineDelimiter must not be null or empty");
        }
        this.lineDelimiter = lineDelimiter;
    }

    private void growSegments(int increment) {
        int targetSize = this.segments.size() + increment;
        if (targetSize <= this.lastSegmentsSize) {
            return;
        }
        int mod = targetSize % 16;
        if (mod != 0) {
            targetSize += 16 - mod;
        }
        this.segments.ensureCapacity(targetSize);
        this.lastSegmentsSize = targetSize;
    }

    public void append(Object object) {
        this.append(object, this.segments.size());
    }

    public void append(String str) {
        if (str != null) {
            this.append(str, this.segments.size());
        }
    }

    public void append(StringConcatenation concat) {
        if (concat != null) {
            this.appendSegments(this.segments.size(), concat.getSignificantContent(), concat.lineDelimiter);
        }
    }

    public void append(StringConcatenationClient client) {
        if (client != null) {
            client.appendTo(new SimpleTarget(this, this.segments.size()));
        }
    }

    protected void append(Object object, int index) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.append((String)object, index);
        } else if (object instanceof StringConcatenation) {
            StringConcatenation other = (StringConcatenation)object;
            this.appendSegments(index, other.getSignificantContent(), other.lineDelimiter);
        } else if (object instanceof StringConcatenationClient) {
            StringConcatenationClient other = (StringConcatenationClient)object;
            other.appendTo(new SimpleTarget(this, index));
        } else {
            String text = this.getStringRepresentation(object);
            if (text != null) {
                this.append(text, index);
            }
        }
    }

    private void append(String text, int index) {
        int initial = StringConcatenation.initialSegmentSize(text);
        if (initial == text.length()) {
            this.appendSegment(index, text);
        } else {
            this.appendSegments(index, this.continueSplitting(text, initial));
        }
    }

    public void append(Object object, String indentation) {
        this.append(object, indentation, this.segments.size());
    }

    public void append(String str, String indentation) {
        if (indentation.isEmpty()) {
            this.append(str);
        } else if (str != null) {
            this.append(indentation, str, this.segments.size());
        }
    }

    public void append(StringConcatenation concat, String indentation) {
        if (indentation.isEmpty()) {
            this.append(concat);
        } else if (concat != null) {
            this.appendSegments(indentation, this.segments.size(), concat.getSignificantContent(), concat.lineDelimiter);
        }
    }

    public void append(StringConcatenationClient client, String indentation) {
        if (indentation.isEmpty()) {
            this.append(client);
        } else if (client != null) {
            client.appendTo(new IndentedTarget(this, indentation, this.segments.size()));
        }
    }

    protected void append(Object object, String indentation, int index) {
        if (indentation.length() == 0) {
            this.append(object, index);
            return;
        }
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.append(indentation, (String)object, index);
        } else if (object instanceof StringConcatenation) {
            StringConcatenation other = (StringConcatenation)object;
            List<String> otherSegments = other.getSignificantContent();
            this.appendSegments(indentation, index, otherSegments, other.lineDelimiter);
        } else if (object instanceof StringConcatenationClient) {
            StringConcatenationClient other = (StringConcatenationClient)object;
            other.appendTo(new IndentedTarget(this, indentation, index));
        } else {
            String text = this.getStringRepresentation(object);
            if (text != null) {
                this.append(indentation, text, index);
            }
        }
    }

    private void append(String indentation, String text, int index) {
        int initial = StringConcatenation.initialSegmentSize(text);
        if (initial == text.length()) {
            this.appendSegment(index, text);
        } else {
            this.appendSegments(indentation, index, this.continueSplitting(text, initial), this.lineDelimiter);
        }
    }

    protected String getStringRepresentation(Object object) {
        return object.toString();
    }

    public void appendImmediate(Object object, String indentation) {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            int j = 0;
            while (j < segment.length()) {
                if (!WhitespaceMatcher.isWhitespace(segment.charAt(j))) {
                    this.append(object, indentation, i + 1);
                    return;
                }
                ++j;
            }
            --i;
        }
        this.append(object, indentation, 0);
    }

    protected void appendSegments(String indentation, int index, List<String> otherSegments, String otherDelimiter) {
        if (otherSegments.isEmpty()) {
            return;
        }
        this.growSegments(otherSegments.size());
        for (String otherSegment : otherSegments) {
            if (otherDelimiter.equals(otherSegment)) {
                this.segments.add(index++, this.lineDelimiter);
                this.segments.add(index++, indentation);
                continue;
            }
            this.segments.add(index++, otherSegment);
        }
        this.cachedToString = null;
    }

    protected void appendSegments(int index, List<String> otherSegments, String otherDelimiter) {
        if (otherDelimiter.equals(this.lineDelimiter)) {
            this.appendSegments(index, otherSegments);
        } else {
            if (otherSegments.isEmpty()) {
                return;
            }
            this.growSegments(otherSegments.size());
            for (String otherSegment : otherSegments) {
                if (otherDelimiter.equals(otherSegment)) {
                    this.segments.add(index++, this.lineDelimiter);
                    continue;
                }
                this.segments.add(index++, otherSegment);
            }
            this.cachedToString = null;
        }
    }

    protected void appendSegments(int index, List<String> otherSegments) {
        this.growSegments(otherSegments.size());
        if (this.segments.addAll(index, otherSegments)) {
            this.cachedToString = null;
        }
    }

    private void appendSegment(int index, String segment) {
        this.growSegments(1);
        this.segments.add(index, segment);
        this.cachedToString = null;
    }

    public void newLine() {
        this.growSegments(1);
        this.segments.add(this.lineDelimiter);
        this.cachedToString = null;
    }

    public void newLineIfNotEmpty() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            if (this.lineDelimiter.equals(segment)) {
                this.segments.subList(i + 1, this.segments.size()).clear();
                this.cachedToString = null;
                return;
            }
            int j = 0;
            while (j < segment.length()) {
                if (!WhitespaceMatcher.isWhitespace(segment.charAt(j))) {
                    this.newLine();
                    return;
                }
                ++j;
            }
            --i;
        }
        this.segments.clear();
        this.cachedToString = null;
    }

    @Override
    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        List<String> significantContent = this.getSignificantContent();
        StringBuilder builder = new StringBuilder(significantContent.size() * 4);
        for (String segment : significantContent) {
            builder.append(segment);
        }
        this.cachedToString = builder.toString();
        return this.cachedToString;
    }

    protected final List<String> getContent() {
        return this.segments;
    }

    protected List<String> getSignificantContent() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            if (this.lineDelimiter.equals(segment)) {
                return this.segments.subList(0, i + 1);
            }
            int j = 0;
            while (j < segment.length()) {
                if (!WhitespaceMatcher.isWhitespace(segment.charAt(j))) {
                    return this.segments;
                }
                ++j;
            }
            --i;
        }
        return this.segments;
    }

    protected String getLineDelimiter() {
        return this.lineDelimiter;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    protected List<String> splitLinesAndNewLines(String text) {
        if (text == null) {
            return Collections.emptyList();
        }
        int idx = StringConcatenation.initialSegmentSize(text);
        if (idx == text.length()) {
            return Collections.singletonList(text);
        }
        return this.continueSplitting(text, idx);
    }

    private static int initialSegmentSize(String text) {
        int length = text.length();
        int idx = 0;
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r' || currentChar == '\n') break;
            ++idx;
        }
        return idx;
    }

    private List<String> continueSplitting(String text, int idx) {
        int length = text.length();
        int nextLineOffset = 0;
        ArrayList<String> result = new ArrayList<String>(5);
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r') {
                int delimiterLength = 1;
                if (idx + 1 < length && text.charAt(idx + 1) == '\n') {
                    ++delimiterLength;
                    ++idx;
                }
                int lineLength = idx - delimiterLength - nextLineOffset + 1;
                result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                result.add(this.lineDelimiter);
                nextLineOffset = idx + 1;
            } else if (currentChar == '\n') {
                int lineLength = idx - nextLineOffset;
                result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                result.add(this.lineDelimiter);
                nextLineOffset = idx + 1;
            }
            ++idx;
        }
        if (nextLineOffset != length) {
            int lineLength = length - nextLineOffset;
            result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
        }
        return result;
    }

    private static class IndentedTarget
    extends SimpleTarget {
        private final String indentation;

        private IndentedTarget(StringConcatenation target, String indentation, int index) {
            super(target, index);
            this.indentation = indentation;
        }

        @Override
        public void newLineIfNotEmpty() {
            super.newLineIfNotEmpty();
            super.append(this.indentation);
        }

        @Override
        public void newLine() {
            super.newLine();
            super.append(this.indentation);
        }

        @Override
        public void appendImmediate(Object object, String indentation) {
            super.appendImmediate(object, this.indentation + indentation);
        }

        @Override
        public void append(Object object, String indentation) {
            super.append(object, this.indentation + indentation);
        }

        @Override
        public void append(Object object) {
            super.append(object, this.indentation);
        }
    }

    private static class SimpleTarget
    implements StringConcatenationClient.TargetStringConcatenation {
        private final StringConcatenation target;
        private final int offsetFixup;

        private SimpleTarget(StringConcatenation target, int index) {
            this.target = target;
            this.offsetFixup = target.segments.size() - index;
        }

        @Override
        public int length() {
            return this.target.length();
        }

        @Override
        public char charAt(int index) {
            return this.target.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.target.subSequence(start, end);
        }

        @Override
        public void newLineIfNotEmpty() {
            this.target.newLineIfNotEmpty();
        }

        @Override
        public void newLine() {
            this.target.newLine();
        }

        @Override
        public void appendImmediate(Object object, String indentation) {
            this.target.appendImmediate(object, indentation);
        }

        @Override
        public void append(Object object, String indentation) {
            if (this.offsetFixup == 0) {
                this.target.append(object, indentation);
            } else {
                this.target.append(object, indentation, this.target.segments.size() - this.offsetFixup);
            }
        }

        @Override
        public void append(Object object) {
            this.target.append(object, this.target.segments.size() - this.offsetFixup);
        }
    }
}

