/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.exslt.ui.internal.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.exslt.ui.internal.contentassist.CommonSelectContentAssistRequest;
import org.eclipse.wst.xsl.exslt.ui.internal.contentassist.CommonTestContentAssistRequest;
import org.eclipse.wst.xsl.ui.provisional.contentassist.IContentAssistProposalRequest;
import org.eclipse.wst.xsl.ui.provisional.contentassist.NullContentAssistRequest;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EXSLTContentAssistRequestFactory {
    private static final String ATTR_SELECT = "select";
    private static final String ATTR_TEST = "test";
    private static final String ATTR_MATCH = "match";
    private ITextViewer textViewer;
    private int documentPosition;
    private IDOMNode xmlNode;
    private IStructuredDocumentRegion sdRegion;
    private ITextRegion completionRegion;
    private String matchString;

    public EXSLTContentAssistRequestFactory(ITextViewer textViewer, int documentPosition, IDOMNode xmlNode, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion, String matchString) {
        this.textViewer = textViewer;
        this.documentPosition = documentPosition;
        this.xmlNode = xmlNode;
        this.sdRegion = sdRegion;
        this.completionRegion = completionRegion;
        this.matchString = matchString;
    }

    public IContentAssistProposalRequest getContentAssistRequest() {
        NamedNodeMap nodeMap = this.xmlNode.getAttributes();
        IDOMElement element = (IDOMElement)this.xmlNode;
        IContentAssistProposalRequest proposal = this.commonAttributeProposals(nodeMap);
        if (proposal instanceof NullContentAssistRequest && this.isElementProposal(element)) {
            proposal = this.getNullProposal();
        }
        return proposal;
    }

    private boolean isElementProposal(IDOMElement element) {
        element.getLocalName();
        return false;
    }

    private IContentAssistProposalRequest commonAttributeProposals(NamedNodeMap nodeMap) {
        if (this.hasAttributeAtTextRegion(ATTR_SELECT, nodeMap, this.completionRegion)) {
            return new CommonSelectContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (this.hasAttributeAtTextRegion(ATTR_TEST, nodeMap, this.completionRegion)) {
            return new CommonTestContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        return this.getNullProposal();
    }

    protected boolean hasAttributeAtTextRegion(String attrName, NamedNodeMap nodeMap, ITextRegion aRegion) {
        IDOMAttr attrNode = (IDOMAttr)nodeMap.getNamedItem(attrName);
        return attrNode != null && attrNode.getValueRegion() != null && attrNode.getValueRegion().getStart() == aRegion.getStart();
    }

    private IContentAssistProposalRequest getNullProposal() {
        return new NullContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
    }
}

