/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class BasicModel
implements Model {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String fName;
    private Hashtable fElements;
    private Element fRoot;
    private int fUniqueNumberCounter;

    public BasicModel(String name) {
        this.fName = name;
        this.fElements = new Hashtable();
        this.fRoot = null;
        this.fUniqueNumberCounter = 0;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getUniqueNumber() {
        ++this.fUniqueNumberCounter;
        return this.fUniqueNumberCounter;
    }

    @Override
    public String makeMUID(String name) {
        String num = String.valueOf(this.getUniqueNumber());
        String muid = String.valueOf(name) + num;
        return muid;
    }

    @Override
    public boolean setRootElement(Element root) {
        if (root.getModel() == null) {
            this.addElement(root);
        } else if (root.getModel() != this) {
            return false;
        }
        this.fRoot = root;
        return true;
    }

    @Override
    public Element getRootElement() {
        if (this.fRoot == null) {
            this.fRoot = this.getFirstElement();
        }
        return this.fRoot;
    }

    @Override
    public Vector getElementsByName(String name) {
        Vector<Element> vector = new Vector<Element>();
        Enumeration e = this.fElements.keys();
        while (e.hasMoreElements()) {
            Element element = (Element)e.nextElement();
            if (!element.getName().equals(name)) continue;
            vector.addElement(element);
        }
        return vector;
    }

    @Override
    public boolean addElement(Element element) {
        if (element.getModel() != null) {
            return false;
        }
        this.fElements.put(element, element);
        return true;
    }

    @Override
    public boolean removeElement(Element element) {
        if (element.getModel() != this) {
            return false;
        }
        element.disconnectAll();
        if (this.fRoot == element) {
            this.fRoot = null;
        }
        return this.fElements.remove(element) == element;
    }

    @Override
    public Enumeration getElements() {
        return this.fElements.elements();
    }

    @Override
    public int getNumberOfElements() {
        return this.fElements.size();
    }

    @Override
    public boolean containsElement(Element element) {
        return this.fElements.contains(element);
    }

    private Element getFirstElement() {
        Enumeration e = this.getElements();
        return e.hasMoreElements() ? (Element)e.nextElement() : null;
    }

    public String toString() {
        return this.getName();
    }
}

