/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public class EmptyVariableSupport
extends VariableSupport {
    private Expression m_initializer;

    protected EmptyVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public EmptyVariableSupport(JavaInfo javaInfo, Expression initializer) {
        super(javaInfo);
        this.m_initializer = initializer;
    }

    public final String toString() {
        return "empty";
    }

    @Override
    public final boolean isDefault() {
        return true;
    }

    public final Expression getInitializer() {
        return this.m_initializer;
    }

    public final void materialize() throws Exception {
        this.m_javaInfo.getBroadcastJava().variable_emptyMaterializeBefore(this);
        if (this.getEnclosingField() != null) {
            this.materialize_newField();
        } else if (this.isPureInitializer()) {
            this.materialize_sameStatement();
        } else {
            this.materialize_newStatement();
        }
    }

    @Override
    public final boolean hasName() {
        return true;
    }

    @Override
    public final String getName() {
        return null;
    }

    @Override
    public final void setName(String newName) throws Exception {
        this.materialize();
        this.m_javaInfo.getVariableSupport().setName(newName);
    }

    @Override
    public final String getTitle() {
        return "(no variable)";
    }

    @Override
    public boolean hasExpression(NodeTarget target) {
        return true;
    }

    @Override
    public final String getReferenceExpression(NodeTarget target) throws Exception {
        this.ensureLocalVariable_withUpdatingTarget(target);
        return this.m_javaInfo.getVariableSupport().getReferenceExpression(target);
    }

    @Override
    public final String getAccessExpression(NodeTarget target) throws Exception {
        return this.getReferenceExpression(target) + ".";
    }

    private void ensureLocalVariable_withUpdatingTarget(NodeTarget target) throws Exception {
        StatementTarget statementTarget = target.getStatementTarget();
        if (statementTarget != null) {
            boolean targetUsesThisStatement = statementTarget.getStatement() == this.getStatement();
            this.materialize();
            if (targetUsesThisStatement) {
                statementTarget.setStatement(this.getStatement());
            }
        }
    }

    @Override
    public final boolean canConvertLocalToField() {
        return true;
    }

    @Override
    public final void convertLocalToField() throws Exception {
        this.materialize();
        this.m_javaInfo.getVariableSupport().convertLocalToField();
    }

    @Override
    public final boolean canConvertFieldToLocal() {
        return true;
    }

    @Override
    public final void convertFieldToLocal() throws Exception {
        this.materialize();
    }

    @Override
    public final StatementTarget getStatementTarget() throws Exception {
        this.materialize();
        return this.m_javaInfo.getVariableSupport().getStatementTarget();
    }

    @Override
    public void ensureInstanceReadyAt(StatementTarget target) throws Exception {
        if (this.shouldMoveOnlyInitializater()) {
            ExpressionStatement statement = (ExpressionStatement)this.m_initializer.getParent();
            this.m_javaInfo.getEditor().moveStatement((Statement)statement, target);
        } else {
            this.materialize();
            this.m_javaInfo.getVariableSupport().ensureInstanceReadyAt(target);
        }
    }

    @Override
    public StatementTarget getAssociationTarget(StatementTarget target) throws Exception {
        return target;
    }

    private boolean isPureInitializer() {
        return this.m_initializer.getParent() instanceof ExpressionStatement;
    }

    private boolean shouldMoveOnlyInitializater() {
        if (this.isPureInitializer()) {
            return this.m_javaInfo.getChildrenJava().isEmpty();
        }
        return false;
    }

    private Statement getStatement() {
        return AstNodeUtils.getEnclosingStatement((ASTNode)this.m_initializer);
    }

    private FieldDeclaration getEnclosingField() {
        return AstNodeUtils.getEnclosingFieldDeclaration((ASTNode)this.m_initializer);
    }

    private void materialize_sameStatement() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        ExpressionStatement oldStatement = (ExpressionStatement)this.m_initializer.getParent();
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(this.m_initializer);
        String typeName = editor.getTypeBindingSource(typeBinding);
        int position = oldStatement.getStartPosition();
        Object source = "";
        Type newType = editor.getParser().parseQualifiedType(position, typeName);
        source = (String)source + typeName + " ";
        String variableName = editor.getUniqueVariableName(this.m_initializer.getStartPosition(), NamesManager.getName(this.m_javaInfo), null);
        SimpleName newDeclarationVariable = editor.getParser().parseVariable(position + ((String)source).length(), variableName, null, typeBinding, false, 0);
        source = (String)source + variableName + " = ";
        String initializerSource = editor.getSource((ASTNode)this.m_initializer);
        oldStatement.setExpression((Expression)editor.getParser().parseSimpleName(0, "__wbp_Tmp"));
        AstNodeUtils.moveNode((ASTNode)this.m_initializer, position + ((String)source).length());
        source = (String)source + initializerSource;
        VariableDeclarationFragment newFragment = this.m_initializer.getAST().newVariableDeclarationFragment();
        newFragment.setName(newDeclarationVariable);
        newFragment.setInitializer(this.m_initializer);
        AstNodeUtils.setSourceRange((ASTNode)newFragment, (ASTNode)newDeclarationVariable, (ASTNode)this.m_initializer);
        VariableDeclarationStatement newStatement = this.m_initializer.getAST().newVariableDeclarationStatement(newFragment);
        newStatement.setType(newType);
        AstNodeUtils.setSourceRange((ASTNode)newStatement, (ASTNode)newType, (ASTNode)newFragment, 1);
        source = (String)source + ";";
        editor.replaceSubstring(oldStatement.getStartPosition(), oldStatement.getLength(), (String)source);
        List<Statement> statements = DomGenerics.statements((Block)oldStatement.getParent());
        int index = statements.indexOf(oldStatement);
        statements.set(index, (Statement)newStatement);
        editor.resolveImports((ASTNode)newStatement);
        this.m_javaInfo.setVariableSupport(new LocalUniqueVariableSupport(this.m_javaInfo, newDeclarationVariable));
    }

    private void materialize_newStatement() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        Statement oldStatement = this.getStatement();
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(this.m_initializer);
        String typeName = editor.getTypeBindingSource(typeBinding);
        int position = oldStatement.getStartPosition();
        Object source = "";
        Type newType = editor.getParser().parseQualifiedType(position, typeName);
        source = (String)source + typeName + " ";
        String variableName = editor.getUniqueVariableName(this.m_initializer.getStartPosition(), NamesManager.getName(this.m_javaInfo), null);
        SimpleName newDeclarationVariable = editor.getParser().parseVariable(position + ((String)source).length(), variableName, null, typeBinding, false, 0);
        source = (String)source + variableName + " = ";
        String initializerSource = editor.getSource((ASTNode)this.m_initializer);
        int originalInitializerPosition = this.m_initializer.getStartPosition();
        int originalInitializerLength = this.m_initializer.getLength();
        SimpleName newUseVariable = editor.getParser().parseVariable(originalInitializerPosition, variableName, null, typeBinding, false, 0);
        AstEditor.replaceNode((ASTNode)this.m_initializer, (ASTNode)newUseVariable);
        this.m_javaInfo.addRelatedNode((ASTNode)newUseVariable);
        editor.replaceSubstring(originalInitializerPosition, originalInitializerLength, newUseVariable.getIdentifier());
        AstNodeUtils.moveNode((ASTNode)newUseVariable, originalInitializerPosition);
        editor.inlineParenthesizedExpression((Expression)newUseVariable);
        AstNodeUtils.moveNode((ASTNode)this.m_initializer, position + ((String)source).length());
        source = (String)source + initializerSource;
        VariableDeclarationFragment newFragment = this.m_initializer.getAST().newVariableDeclarationFragment();
        newFragment.setName(newDeclarationVariable);
        newFragment.setInitializer(this.m_initializer);
        AstNodeUtils.setSourceRange((ASTNode)newFragment, (ASTNode)newDeclarationVariable, (ASTNode)this.m_initializer);
        VariableDeclarationStatement newStatement = this.m_initializer.getAST().newVariableDeclarationStatement(newFragment);
        newStatement.setType(newType);
        AstNodeUtils.setSourceRange((ASTNode)newStatement, (ASTNode)newType, (ASTNode)newFragment, 1);
        source = (String)source + ";";
        source = (String)source + editor.getGeneration().getEndOfLine() + editor.getWhitespaceToLeft(position, false);
        editor.replaceSubstring(position, 0, (String)source);
        List<Statement> statements = DomGenerics.statements((Block)oldStatement.getParent());
        int index = statements.indexOf(oldStatement);
        statements.add(index, (Statement)newStatement);
        editor.resolveImports((ASTNode)newStatement);
        this.m_javaInfo.setVariableSupport(new LocalUniqueVariableSupport(this.m_javaInfo, newDeclarationVariable));
    }

    private void materialize_newField() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        FieldDeclaration oldField = this.getEnclosingField();
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(this.m_initializer);
        String typeName = editor.getTypeBindingSource(typeBinding);
        int position = oldField.getStartPosition();
        Object source = "";
        source = (String)source + "private ";
        Type newType = editor.getParser().parseQualifiedType(position + ((String)source).length(), typeName);
        source = (String)source + typeName + " ";
        String variableName = editor.getUniqueVariableName(this.m_initializer.getStartPosition(), NamesManager.getName(this.m_javaInfo), null);
        SimpleName newDeclarationVariable = editor.getParser().parseVariable(position + ((String)source).length(), variableName, null, typeBinding, false, 0);
        source = (String)source + variableName + " = ";
        String initializerSource = editor.getSource((ASTNode)this.m_initializer);
        int originalInitializerPosition = this.m_initializer.getStartPosition();
        int originalInitializerLength = this.m_initializer.getLength();
        SimpleName newUseVariable = editor.getParser().parseVariable(originalInitializerPosition, variableName, null, typeBinding, false, 0);
        AstEditor.replaceNode((ASTNode)this.m_initializer, (ASTNode)newUseVariable);
        this.m_javaInfo.addRelatedNode((ASTNode)newUseVariable);
        editor.replaceSubstring(originalInitializerPosition, originalInitializerLength, newUseVariable.getIdentifier());
        AstNodeUtils.moveNode((ASTNode)newUseVariable, originalInitializerPosition);
        editor.inlineParenthesizedExpression((Expression)newUseVariable);
        AstNodeUtils.moveNode((ASTNode)this.m_initializer, position + ((String)source).length());
        source = (String)source + initializerSource;
        VariableDeclarationFragment newFragment = this.m_initializer.getAST().newVariableDeclarationFragment();
        newFragment.setName(newDeclarationVariable);
        newFragment.setInitializer(this.m_initializer);
        AstNodeUtils.setSourceRange((ASTNode)newFragment, (ASTNode)newDeclarationVariable, (ASTNode)this.m_initializer);
        FieldDeclaration newField = this.m_initializer.getAST().newFieldDeclaration(newFragment);
        newField.setType(newType);
        AstNodeUtils.setSourceRange((ASTNode)newField, (ASTNode)newType, (ASTNode)newFragment, 1);
        source = (String)source + ";";
        source = (String)source + editor.getGeneration().getEndOfLine() + editor.getWhitespaceToLeft(position, false);
        editor.replaceSubstring(position, 0, (String)source);
        TypeDeclaration typeDeclaration = (TypeDeclaration)oldField.getParent();
        List<BodyDeclaration> bodyDeclarations = DomGenerics.bodyDeclarations(typeDeclaration);
        int index = bodyDeclarations.indexOf(oldField);
        bodyDeclarations.add(index, (BodyDeclaration)newField);
        editor.resolveImports((ASTNode)newField);
        this.m_javaInfo.setVariableSupport(new FieldInitializerVariableSupport(this.m_javaInfo, (Expression)newDeclarationVariable));
    }

    protected final void add_setInitializer(Expression initializer) throws Exception {
        this.m_initializer = initializer;
        this.m_javaInfo.addRelatedNode((ASTNode)this.m_initializer);
        this.m_javaInfo.getCreationSupport().add_setSourceExpression(this.m_initializer);
    }
}

