/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.ScopeArea;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FiltersConfigurationDialog
extends TrayDialog {
    private static final String SELECTED_FILTER_GROUP = "SELECTED_FILTER_GROUP";
    private static final String PREV_SELECTED_ELEMENTS = "PREV_SELECTED_ELEMENTS";
    private static int DEFAULTS_BUTTON_ID = 25;
    private final Collection<MarkerFieldFilterGroup> filterGroups;
    private CheckboxTableViewer configsTable;
    private MarkerFieldFilterGroup selectedFilterGroup;
    private final MarkerContentGenerator generator;
    private boolean andFilters = false;
    private Button removeButton;
    private Button renameButton;
    private Button allButton;
    private Button limitButton;
    private Text limitText;
    private final GroupFilterConfigurationArea scopeArea = this.createScopeArea();
    private ScrolledForm form;
    private Collection<FilterConfigurationArea> configAreas;
    private Label limitsLabel;
    private Object[] previouslyChecked = new Object[0];
    private Group configComposite;
    private Composite compositeLimits;

    public FiltersConfigurationDialog(Shell parentShell, MarkerContentGenerator generator) {
        super(parentShell);
        this.filterGroups = this.makeWorkingCopy(generator.getAllFilters());
        this.generator = generator;
        this.andFilters = false;
        this.setHelpAvailable(false);
    }

    boolean andFilters() {
        return this.andFilters;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MarkerMessages.configureFiltersDialog_title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        container.setFont(parent.getFont());
        Composite composite = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(container.getBackground());
        this.createSelectAllButton(composite);
        this.configComposite = new Group(composite, 0);
        this.configComposite.setText(MarkerMessages.MarkerConfigurationsLabel);
        this.configComposite.setLayout((Layout)new GridLayout(3, false));
        this.configComposite.setLayoutData((Object)new GridData(1808));
        this.configComposite.setBackground(composite.getBackground());
        this.createConfigs((Composite)this.configComposite);
        this.createConfigDesc((Composite)this.configComposite);
        this.createAllConfigArea(composite);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        FiltersConfigurationDialog.applyDialogFont((Control)container);
        this.initUI();
        return container;
    }

    protected ScopeArea createScopeArea() {
        return new ScopeArea();
    }

    private void initUI() {
        this.configsTable.setInput(this.filterGroups);
        IStructuredSelection selection = this.getInitialSelection();
        this.configsTable.setSelection((ISelection)selection);
        if (selection.isEmpty()) {
            this.setFieldsEnabled(false);
        }
        for (MarkerFieldFilterGroup group : this.filterGroups) {
            boolean enabled = group.isEnabled();
            this.configsTable.setChecked((Object)group, enabled);
        }
        this.updateRadioButtonsFromTable();
        int limits = this.generator.getMarkerLimits();
        boolean limitsEnabled = this.generator.isMarkerLimitsEnabled();
        this.limitButton.setSelection(limitsEnabled);
        this.updateLimitTextEnablement();
        this.limitText.setText(Integer.toString(limits));
        this.configsTable.getTable().setFocus();
    }

    private void updateRadioButtonsFromTable() {
        boolean showAll = this.isShowAll();
        this.allButton.setSelection(showAll);
        this.updateConfigComposite(!showAll);
    }

    private void updateConfigComposite(boolean enabled) {
        if (enabled) {
            this.updateButtonEnablement(this.getSelectionFromTable());
        }
    }

    private void updateLimitTextEnablement() {
        boolean useLimits = this.limitButton.getSelection();
        this.limitsLabel.setEnabled(useLimits);
        this.limitText.setEnabled(useLimits);
    }

    private void updateShowAll(boolean showAll) {
        this.allButton.setSelection(showAll);
        this.updateConfigComposite(!showAll);
        this.updateLimitTextEnablement();
        if (showAll) {
            this.previouslyChecked = this.configsTable.getCheckedElements();
            this.configsTable.setAllChecked(false);
        } else if (this.previouslyChecked != null && this.previouslyChecked.length > 0) {
            this.configsTable.setCheckedElements(this.previouslyChecked);
        } else if (this.filterGroups.size() > 0) {
            MarkerFieldFilterGroup group = this.filterGroups.iterator().next();
            this.configsTable.setChecked((Object)group, true);
        }
    }

    private boolean isShowAll() {
        return this.configsTable.getCheckedElements().length == 0;
    }

    private void createAllConfigArea(Composite parent) {
        this.compositeLimits = new Composite(parent, 0);
        GridLayout glCompositeLimits = new GridLayout(3, false);
        this.compositeLimits.setLayout((Layout)glCompositeLimits);
        this.limitButton = new Button(this.compositeLimits, 32);
        this.limitButton.setText(MarkerMessages.MarkerPreferences_MarkerLimits);
        this.limitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.updateLimitTextEnablement();
            }
        });
        GridData limitData = new GridData();
        limitData.verticalIndent = 5;
        this.limitButton.setLayoutData((Object)limitData);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData compositeData = new GridData(768);
        compositeData.horizontalIndent = 20;
        composite.setLayoutData((Object)compositeData);
        this.limitsLabel = new Label(composite, 0);
        this.limitsLabel.setText(MarkerMessages.MarkerPreferences_VisibleItems);
        this.limitText = new Text(composite, 2048);
        GridData textData = new GridData();
        textData.widthHint = this.convertWidthInCharsToPixels(10);
        this.limitText.setLayoutData((Object)textData);
        this.limitText.addVerifyListener(e -> {
            if (e.character != '\u0000' && e.keyCode != 8 && e.keyCode != 127 && !Character.isDigit(e.character)) {
                e.doit = false;
            }
        });
        this.limitText.addModifyListener(e -> {
            boolean isInvalid = false;
            try {
                int value = Integer.parseInt(this.limitText.getText());
                if (value <= 0) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                this.limitText.setText(Integer.toString(this.generator.getMarkerLimits()));
            }
        });
        Composite defaultButtonComposite = new Composite(composite, 0);
        GridLayout defaultButtonLayout = new GridLayout(1, false);
        defaultButtonComposite.setLayout((Layout)defaultButtonLayout);
        GridData defaultButtonCompositeData = new GridData(0x1000008, 0x1000008, true, false);
        defaultButtonComposite.setLayoutData((Object)defaultButtonCompositeData);
        this.createButton(defaultButtonComposite, DEFAULTS_BUTTON_ID, JFaceResources.getString((String)"defaults"), false);
    }

    private void createConfigs(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(parent.getBackground());
        this.configsTable = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.widthHint = this.convertHorizontalDLUsToPixels(120);
        this.configsTable.getControl().setLayoutData((Object)tableData);
        this.configsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.configsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MarkerFieldFilterGroup)element).getName();
            }
        });
        this.configsTable.addCheckStateListener(event -> {
            this.configsTable.setSelection((ISelection)new StructuredSelection(event.getElement()));
            this.updateRadioButtonsFromTable();
        });
        this.configsTable.addSelectionChangedListener(event -> {
            this.storeConfiguration();
            MarkerFieldFilterGroup group = this.getSelectionFromTable();
            if (group == null) {
                this.setFieldsEnabled(false);
            } else {
                this.setFieldsEnabled(true);
            }
            this.updateButtonEnablement(group);
            this.updateConfigDesc(group);
            this.selectedFilterGroup = group;
        });
        this.createButtons(composite);
    }

    private void storeConfiguration() {
        if (this.selectedFilterGroup == null) {
            return;
        }
        this.scopeArea.applyToGroup(this.selectedFilterGroup);
        for (FilterConfigurationArea area : this.configAreas) {
            if (area instanceof GroupFilterConfigurationArea) {
                ((GroupFilterConfigurationArea)area).applyToGroup(this.selectedFilterGroup);
            }
            area.apply(this.selectedFilterGroup.getFilter(area.getField()));
        }
        this.configsTable.refresh((Object)this.selectedFilterGroup);
    }

    private void updateConfigDesc(MarkerFieldFilterGroup configuration) {
        if (configuration == null) {
            return;
        }
        this.scopeArea.initializeFromGroup(configuration);
        for (FilterConfigurationArea area : this.configAreas) {
            if (area instanceof GroupFilterConfigurationArea) {
                ((GroupFilterConfigurationArea)area).initializeFromGroup(configuration);
            }
            area.initialize(configuration.getFilter(area.getField()));
        }
    }

    private void createConfigDesc(Composite parent) {
        Label separator = new Label(parent, 514);
        separator.setLayoutData((Object)new GridData(1040));
        Composite descComposite = new Composite(parent, 0);
        descComposite.setLayout((Layout)new FillLayout());
        descComposite.setLayoutData((Object)new GridData(1808));
        descComposite.setBackground(parent.getBackground());
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(e -> toolkit.dispose());
        this.form = toolkit.createScrolledForm(descComposite);
        this.form.setBackground(parent.getBackground());
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.configAreas = this.generator.createFilterConfigurationFields();
        this.createFieldArea(toolkit, this.form, this.scopeArea, true);
        Iterator<FilterConfigurationArea> areas = this.configAreas.iterator();
        while (areas.hasNext()) {
            this.createFieldArea(toolkit, this.form, areas.next(), true);
        }
    }

    private void createFieldArea(FormToolkit toolkit, final ScrolledForm scrolledForm, FilterConfigurationArea area, boolean expand) {
        ExpandableComposite expandable = toolkit.createExpandableComposite(scrolledForm.getBody(), 2);
        expandable.setText(area.getTitle());
        expandable.setBackground(scrolledForm.getBackground());
        expandable.setLayout((Layout)new GridLayout());
        expandable.setLayoutData((Object)new GridData(4, 4, true, area.grabExcessVerticalSpace()));
        expandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                scrolledForm.reflow(true);
            }
        });
        Composite sectionClient = toolkit.createComposite((Composite)expandable);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 3;
        sectionClient.setLayout((Layout)gridLayout);
        sectionClient.setLayoutData((Object)new GridData(4, 0, true, false));
        sectionClient.setBackground(scrolledForm.getBackground());
        area.createContents(sectionClient);
        expandable.setClient((Control)sectionClient);
        expandable.setExpanded(expand);
    }

    private void createButtons(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttons.setLayout((Layout)buttonLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 1;
        buttons.setLayoutData((Object)buttonsData);
        Button addNew = new Button(buttons, 8);
        addNew.setText(MarkerMessages.MarkerFilter_addFilterName);
        addNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.addConfiguration();
            }
        });
        this.setButtonLayoutData(addNew);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(MarkerMessages.MarkerFilter_deleteSelectedName);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.removeFilters((ISelection)FiltersConfigurationDialog.this.configsTable.getStructuredSelection());
            }
        });
        this.removeButton.setEnabled(false);
        this.setButtonLayoutData(this.removeButton);
        this.renameButton = new Button(buttons, 8);
        this.renameButton.setText(MarkerMessages.MarkerFilter_renameName);
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.renameFilter();
            }
        });
        this.renameButton.setEnabled(false);
        this.setButtonLayoutData(this.renameButton);
    }

    private void renameFilter() {
        MarkerFieldFilterGroup filterGroup = this.getSelectionFromTable();
        IInputValidator nameValidator = this.getNameValidator(filterGroup.getName(), this.getCurrentConfigurationNames());
        InputDialog inputDialog = new InputDialog(this.getShell(), MarkerMessages.MarkerFilterDialog_title, MarkerMessages.MarkerFilterDialog_message, filterGroup.getName(), nameValidator);
        if (inputDialog.open() == 0) {
            filterGroup.setName(inputDialog.getValue());
            this.configsTable.refresh((Object)filterGroup);
        }
    }

    private IInputValidator getNameValidator(String currentName, Collection<String> existingNames) {
        return newText -> {
            if ((newText = newText.trim()).isEmpty()) {
                return MarkerMessages.MarkerFilterDialog_emptyMessage;
            }
            if (existingNames.contains(newText) && !currentName.equals(newText)) {
                return NLS.bind((String)MarkerMessages.filtersDialog_conflictingName, (Object)newText);
            }
            return null;
        };
    }

    private void createSelectAllButton(Composite parent) {
        this.allButton = new Button(parent, 32);
        this.allButton.setText(MarkerMessages.ALL_Title);
        this.allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.updateShowAll(FiltersConfigurationDialog.this.allButton.getSelection());
            }
        });
    }

    private Collection<String> getCurrentConfigurationNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<MarkerFieldFilterGroup> filterIterator = this.filterGroups.iterator();
        while (filterIterator.hasNext()) {
            names.add(filterIterator.next().getName());
        }
        return names;
    }

    private void addConfiguration() {
        String newName = this.getNewConfigurationName(this.getCurrentConfigurationNames(), MarkerMessages.MarkerFilter_newFilterName);
        MarkerFieldFilterGroup configuration = this.createConfiguration(newName);
        this.filterGroups.add(configuration);
        this.configsTable.refresh();
        this.configsTable.setSelection((ISelection)new StructuredSelection((Object)configuration));
        this.configsTable.setChecked((Object)configuration, true);
        this.updateRadioButtonsFromTable();
    }

    private String getNewConfigurationName(Collection<String> avoidNames, String initialName) {
        Object configName = initialName;
        int i = 1;
        while (avoidNames.contains(configName)) {
            configName = initialName + " " + i;
            ++i;
        }
        return configName;
    }

    private MarkerFieldFilterGroup createConfiguration(String newName) {
        MarkerFieldFilterGroup config = new MarkerFieldFilterGroup(null, this.generator);
        config.setName(newName);
        return config;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText(MarkerMessages.filtersDialog_applyAndCloseButton);
        this.setButtonLayoutData(okButton);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FiltersConfigurationDialog.class)).getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            settings = dialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return settings;
    }

    Collection<MarkerFieldFilterGroup> getFilters() {
        return this.filterGroups;
    }

    private IStructuredSelection getInitialSelection() {
        IDialogSettings settings = this.getDialogSettings();
        String selectedGroupName = settings.get(SELECTED_FILTER_GROUP);
        MarkerFieldFilterGroup selectedGroup = null;
        if (selectedGroupName == null && this.filterGroups.size() > 0) {
            selectedGroup = this.filterGroups.iterator().next();
        } else {
            for (MarkerFieldFilterGroup group : this.filterGroups) {
                if (!group.getName().equals(selectedGroupName)) continue;
                selectedGroup = group;
                break;
            }
        }
        String[] selectedElementNames = settings.getArray(PREV_SELECTED_ELEMENTS);
        ArrayList<MarkerFieldFilterGroup> selectedElements = new ArrayList<MarkerFieldFilterGroup>();
        if (selectedElementNames != null) {
            String[] stringArray = selectedElementNames;
            int n = selectedElementNames.length;
            int n2 = 0;
            while (n2 < n) {
                String selectedElementName = stringArray[n2];
                for (MarkerFieldFilterGroup group : this.filterGroups) {
                    if (!Objects.equals(group.getName(), selectedElementName)) continue;
                    selectedElements.add(group);
                    break;
                }
                ++n2;
            }
            this.previouslyChecked = selectedElements.toArray();
        }
        if (selectedGroup != null) {
            return new StructuredSelection((Object)selectedGroup);
        }
        return StructuredSelection.EMPTY;
    }

    private Collection<MarkerFieldFilterGroup> makeWorkingCopy(Collection<MarkerFieldFilterGroup> groups) {
        Iterator<MarkerFieldFilterGroup> initialFiltersIterator = groups.iterator();
        ArrayList<MarkerFieldFilterGroup> returnFilters = new ArrayList<MarkerFieldFilterGroup>(groups.size());
        while (initialFiltersIterator.hasNext()) {
            MarkerFieldFilterGroup group = initialFiltersIterator.next();
            MarkerFieldFilterGroup copy = group.makeWorkingCopy();
            if (copy == null) continue;
            returnFilters.add(copy);
        }
        return returnFilters;
    }

    protected void okPressed() {
        this.generator.setMarkerLimitsEnabled(this.limitButton.getSelection());
        this.generator.setMarkerLimits(Integer.parseInt(this.limitText.getText().trim()));
        for (MarkerFieldFilterGroup group : this.filterGroups) {
            group.setEnabled(this.configsTable.getChecked((Object)group));
        }
        this.storeConfiguration();
        this.saveDialogSettings();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == DEFAULTS_BUTTON_ID) {
            this.performDefaults();
        }
        super.buttonPressed(buttonId);
    }

    protected void performDefaults() {
        this.andFilters = false;
        this.filterGroups.clear();
        ArrayList<MarkerFieldFilterGroup> declaredFilters = new ArrayList<MarkerFieldFilterGroup>(this.generator.getDeclaredFilters());
        this.filterGroups.addAll(declaredFilters);
        this.configsTable.refresh();
        for (MarkerFieldFilterGroup marker : declaredFilters) {
            if (!marker.isEnabled()) continue;
            this.configsTable.setChecked((Object)marker, true);
        }
        IPreferenceStore preferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean useMarkerLimits = preferenceStore.getBoolean("USE_MARKER_LIMITS");
        int markerLimits = preferenceStore.getInt("MARKER_LIMITS_VALUE");
        this.limitButton.setSelection(useMarkerLimits);
        this.updateLimitTextEnablement();
        this.limitText.setText(Integer.toString(markerLimits));
        this.updateRadioButtonsFromTable();
    }

    private void removeFilters(ISelection selection) {
        this.filterGroups.remove(((IStructuredSelection)selection).getFirstElement());
        this.configsTable.refresh();
        this.updateRadioButtonsFromTable();
    }

    private void saveDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.selectedFilterGroup != null) {
            settings.put(SELECTED_FILTER_GROUP, this.selectedFilterGroup.getName());
        }
        String[] selectedNames = new String[this.previouslyChecked.length];
        int i = 0;
        while (i < selectedNames.length) {
            selectedNames[i] = ((MarkerFieldFilterGroup)this.previouslyChecked[i]).getName();
            ++i;
        }
        settings.put(PREV_SELECTED_ELEMENTS, selectedNames);
    }

    private void updateButtonEnablement(MarkerFieldFilterGroup group) {
        boolean enabled = group != null && !group.isSystem();
        this.removeButton.setEnabled(enabled);
        this.renameButton.setEnabled(enabled);
    }

    private MarkerFieldFilterGroup getSelectionFromTable() {
        IStructuredSelection selection = this.configsTable.getStructuredSelection();
        return (MarkerFieldFilterGroup)selection.getFirstElement();
    }

    private void setEnabled(boolean enabled, Control control) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setEnabled(enabled, child);
                ++n2;
            }
        }
    }

    private void setFieldsEnabled(boolean enabled) {
        this.setEnabled(enabled, (Control)this.form);
    }
}

