/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.ide.model.WorkingSetAdapterFactory;

public class WorkingSetResourceMapping
extends ResourceMapping {
    private final IWorkingSet set;

    public WorkingSetResourceMapping(IWorkingSet workingSet) {
        this.set = workingSet;
    }

    public Object getModelObject() {
        return this.set;
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    public IProject[] getProjects() {
        HashSet result = new HashSet();
        ResourceMapping[] resourceMappingArray = this.getMappings();
        int n = resourceMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            Collections.addAll(result, mapping.getProjects());
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor mon) throws CoreException {
        ResourceMapping[] mappings = this.getMappings();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)mappings.length);
        ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            result.addAll(Arrays.asList(mapping.getTraversals(context, (IProgressMonitor)subMonitor.split(1))));
            ++n2;
        }
        return result.toArray(new ResourceTraversal[result.size()]);
    }

    private ResourceMapping[] getMappings() {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IAdaptable[] iAdaptableArray = this.set.getElements();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            ResourceMapping mapping = WorkingSetAdapterFactory.getContributedResourceMapping(adaptable);
            if (mapping == null) {
                mapping = WorkingSetAdapterFactory.getResourceMapping(adaptable);
            }
            if (mapping != null) {
                result.add(mapping);
            }
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public boolean contains(ResourceMapping mapping) {
        ResourceMapping[] resourceMappingArray = this.getMappings();
        int n = resourceMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping childMapping = resourceMappingArray[n2];
            if (childMapping.contains(mapping)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

