/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public abstract class ElementsStrategy
extends AbstractCompletionStrategy {
    protected boolean useCurrentNamespace = true;

    public ElementsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ElementsStrategy(ICompletionContext context) {
        super(context);
    }

    public ISourceRange getReplacementRangeForMember(AbstractCompletionContext context) throws BadLocationException {
        ISourceRange basicRange = this.getReplacementRange(context);
        int move = context.isAbsoluteName() ? 1 : 0;
        String namespacePrefix = context.getNamespaceName();
        if (namespacePrefix != null) {
            move += 1 + namespacePrefix.length();
        }
        return new SourceRange(basicRange.getOffset() + move, basicRange.getLength() - move);
    }

    public int getRelevance(String currentNamespace, IMember model) {
        IModelElement parent;
        block7: {
            block6: {
                parent = model.getParent();
                if (model.getElementType() != 7 || !PHPFlags.isNamespace(model.getFlags())) break block6;
                return -10;
            }
            if (currentNamespace != null) break block7;
            if (parent.getElementType() == 5) {
                return 10;
            }
        }
        try {
            if (parent.getElementName().equalsIgnoreCase(currentNamespace)) {
                return 10;
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        return 0;
    }
}

