/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionVariableReference;

public class ReflectionArrayVariableReference
extends ReflectionVariableReference {
    public static final int VARIABLE_ARRAY = 1;
    public static final int VARIABLE_HASHTABLE = 2;
    private final Expression index;
    private final int arrayType;

    public ReflectionArrayVariableReference(int start, int end, Expression name, Expression index, int arrayType) {
        super(start, end, name);
        this.index = index;
        this.arrayType = arrayType;
    }

    public static String getArrayType(int type) {
        switch (type) {
            case 1: {
                return "array";
            }
            case 2: {
                return "hashtable";
            }
        }
        throw new IllegalArgumentException();
    }

    public Expression getIndex() {
        return this.index;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    @Override
    public int getKind() {
        return 65;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            this.getExpression().traverse(visitor);
            if (this.index != null) {
                this.index.traverse(visitor);
            }
            visitor.endvisit((Expression)this);
        }
    }
}

