/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.m2m.internal.qvt.oml.QvtNamesChecker;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtCompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtNamespace;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtProject;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtBaseElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtModelException;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtNamespace;

public class QvtCompilationUnit
extends QvtBaseElement
implements IQvtCompilationUnit {
    private QvtNamespace fNamespace;
    private IFile fFile;
    private String fMainModuleName;

    protected QvtCompilationUnit(QvtNamespace parent, String compilationUnitFileName) {
        super(parent, compilationUnitFileName);
        if (parent == null || compilationUnitFileName == null) {
            throw new IllegalArgumentException();
        }
        assert (QvtNamesChecker.isValidCompilationUnitFileName((String)compilationUnitFileName));
        this.fNamespace = parent;
        this.fMainModuleName = QvtNamesChecker.getCompilationUnitMainModuleName((String)compilationUnitFileName);
    }

    @Override
    public String getName() {
        return this.fMainModuleName;
    }

    @Override
    public IQvtNamespace getNamespace() {
        return this.fNamespace;
    }

    @Override
    public IQvtProject getQvtProject() {
        return this.fNamespace.getQvtProject();
    }

    @Override
    public String getQualifiedName() {
        if (this.fNamespace.isDefaultNamespace()) {
            return this.getName();
        }
        return String.valueOf(this.fNamespace.getQualifiedName()) + "." + this.getName();
    }

    @Override
    public int getElementType() {
        return 3;
    }

    @Override
    public IResource getUnderlyingResource() throws QvtModelException {
        return this.getUnderlyingFile();
    }

    public IFile getUnderlyingFile() {
        if (this.fFile == null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getFullPath());
        }
        return this.fFile;
    }
}

