/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.handlers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class RegisterMetamodel
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection iss = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IFile currentFile = (IFile)iss.getFirstElement();
        String artifactUri = currentFile.getFullPath().toString();
        this.init(artifactUri);
        return null;
    }

    private Set<EObject> getElementsByType(Resource extent, String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = extent.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!eo.eClass().getName().equals(type)) continue;
            ret.add(eo);
        }
        return ret;
    }

    private void init(String metamodelURL) {
        ResourceSetImpl myEcoreResourceSet = new ResourceSetImpl();
        Resource mmExtent = myEcoreResourceSet.getResource(URI.createURI((String)metamodelURL), true);
        for (EPackage ePackage : this.getElementsByType(mmExtent, "EPackage")) {
            this.registerPackage(ePackage);
        }
        for (EObject eObject : this.getElementsByType(mmExtent, "EDataType")) {
            EStructuralFeature sf = eObject.eClass().getEStructuralFeature("name");
            EStructuralFeature isf = eObject.eClass().getEStructuralFeature("instanceClassName");
            String tname = (String)eObject.eGet(sf);
            String icn = (String)eObject.eGet(isf);
            if (icn != null) continue;
            if (tname.equals("Boolean")) {
                icn = "boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            sf = eObject.eClass().getEStructuralFeature("instanceClassName");
            eObject.eSet(sf, (Object)icn);
        }
    }

    private void registerPackage(EPackage p) {
        System.out.println(p);
        String nsURI = p.getNsURI();
        if (nsURI == null) {
            nsURI = p.getName();
            p.setNsURI(nsURI);
        }
        EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)p);
    }
}

