/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ai.mcp.transports;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import org.eclipse.ecf.ai.mcp.transports.AbstractStringChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStringChannel
extends AbstractStringChannel {
    private static final Logger logger = LoggerFactory.getLogger(ClientStringChannel.class);
    protected SocketChannel client;
    protected final Object connectLock = new Object();

    public ClientStringChannel(Selector selector, int incomingBufferSize, ExecutorService executor) {
        super(selector, incomingBufferSize, executor);
    }

    public ClientStringChannel() throws IOException {
    }

    public ClientStringChannel(Selector selector, int incomingBufferSize) {
        super(selector, incomingBufferSize);
    }

    public ClientStringChannel(Selector selector) {
        super(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketChannel doConnect(SocketChannel client, SocketAddress address, AbstractStringChannel.IOConsumer<SocketChannel> connectHandler, AbstractStringChannel.IOConsumer<String> readHandler) throws IOException {
        this.debug("connect targetAddress={}", address);
        client.configureBlocking(false);
        client.register(this.selector, 8);
        this.configureConnectSocketChannel(client, address);
        this.start(null, c -> {
            Object object = this.connectLock;
            synchronized (object) {
                if (connectHandler != null) {
                    connectHandler.apply((SocketChannel)c);
                }
                this.connectLock.notifyAll();
            }
        }, readHandler);
        client.connect(address);
        try {
            this.debug("connect targetAddress={}", address);
            Object object = this.connectLock;
            synchronized (object) {
                this.connectLock.wait(this.connectTimeout);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Connect to address=" + String.valueOf(address) + " timed out after " + String.valueOf(this.connectTimeout) + "ms");
        }
        this.debug("connected client={}", client);
        return client;
    }

    public void connect(StandardProtocolFamily protocol, SocketAddress address, AbstractStringChannel.IOConsumer<SocketChannel> connectHandler, AbstractStringChannel.IOConsumer<String> readHandler) throws IOException {
        if (this.client != null) {
            throw new IOException("Already connected");
        }
        this.client = this.doConnect(SocketChannel.open(protocol), address, connectHandler, readHandler);
    }

    @Override
    protected void handleException(SelectionKey key, Throwable e) {
        if (logger.isDebugEnabled()) {
            logger.debug("handleException", e);
        }
        this.close();
    }

    @Override
    public void close() {
        this.hardCloseClient(this.client, client -> {
            this.client = null;
        });
    }

    public void writeMessage(String message) throws IOException {
        if (this.client == null) {
            throw new IOException("Cannot write until client connected");
        }
        this.writeMessageToChannel(this.client, message);
    }
}

