/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.core;

import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.debug.core.AbstractDLTKDebugToolkit;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDLTKDebugToolkit;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.internal.debug.core.model.VariableNameComparator;

public class ScriptDebugManager {
    private static final String SCRIPT_DEBUG_MODEL_EXT_POINT = "org.eclipse.dltk.debug.scriptDebugModel";
    private static final String NATURE_ID = "natureId";
    private static final String DEBUG_MODEL_ID = "debugModelId";
    private static final String TYPE_FACTORY = "typeFactory";
    private static final String VARIABLE_NAME_COMPARATOR = "variableNameComparator";
    private static final String DEBUG_TOOLKIT = "debugToolkit";
    private static ScriptDebugManager instance;
    private final HashMap<String, Info> natureToInfoMap = new HashMap();
    private final HashMap<String, String> modelToNatureMap = new HashMap();

    public static synchronized ScriptDebugManager getInstance() {
        if (instance == null) {
            instance = new ScriptDebugManager();
        }
        return instance;
    }

    private void loadExtenstionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(SCRIPT_DEBUG_MODEL_EXT_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length > 0) {
                IConfigurationElement element = elements[0];
                String natureId = element.getAttribute(NATURE_ID);
                String debugModelId = element.getAttribute(DEBUG_MODEL_ID);
                IScriptTypeFactory typeFactory = null;
                try {
                    typeFactory = (IScriptTypeFactory)element.createExecutableExtension(TYPE_FACTORY);
                }
                catch (CoreException e) {
                    DLTKDebugPlugin.log(e);
                }
                Comparator comparator = null;
                String comparatorId = element.getAttribute(VARIABLE_NAME_COMPARATOR);
                if (comparatorId != null) {
                    try {
                        comparator = (Comparator)element.createExecutableExtension(VARIABLE_NAME_COMPARATOR);
                    }
                    catch (CoreException e) {
                        DLTKDebugPlugin.log(e);
                    }
                }
                if (comparator == null) {
                    comparator = new VariableNameComparator();
                }
                IDLTKDebugToolkit debugToolkit = null;
                if (element.getAttribute(DEBUG_TOOLKIT) != null) {
                    try {
                        debugToolkit = (IDLTKDebugToolkit)element.createExecutableExtension(DEBUG_TOOLKIT);
                    }
                    catch (Exception e) {
                        DLTKDebugPlugin.log(e);
                    }
                }
                if (debugToolkit == null) {
                    debugToolkit = new DefaultDebugToolkit();
                }
                if (natureId != null && debugModelId != null) {
                    this.natureToInfoMap.put(natureId, new Info(debugModelId, typeFactory, debugToolkit, comparator));
                    this.modelToNatureMap.put(debugModelId, natureId);
                }
            }
            ++i;
        }
    }

    protected Info getInfo(String natureId) {
        return this.natureToInfoMap.get(natureId);
    }

    protected ScriptDebugManager() {
        this.loadExtenstionPoints();
    }

    public String getNatureByDebugModel(String debugModelId) {
        return this.modelToNatureMap.get(debugModelId);
    }

    public String getDebugModelByNature(String natureId) {
        return this.getInfo((String)natureId).debugModelId;
    }

    public IScriptTypeFactory getTypeFactoryByNature(String natureId) {
        return this.getInfo((String)natureId).typeFactory;
    }

    public IScriptTypeFactory getTypeFactoryByDebugModel(String debugModelId) {
        return this.getTypeFactoryByNature(this.getNatureByDebugModel(debugModelId));
    }

    public Comparator getVariableNameComparatorByNature(String natureId) {
        return this.getInfo((String)natureId).comparator;
    }

    public Comparator getVariableNameComparatorByDebugModel(String debugModelId) {
        return this.getVariableNameComparatorByNature(this.getNatureByDebugModel(debugModelId));
    }

    public IDLTKDebugToolkit getDebugToolkitByNature(String natureId) {
        return this.getInfo((String)natureId).debugToolkit;
    }

    public IDLTKDebugToolkit getDebugToolkitByDebugModel(String debugModelId) {
        return this.getDebugToolkitByNature(this.getNatureByDebugModel(debugModelId));
    }

    private static class DefaultDebugToolkit
    extends AbstractDLTKDebugToolkit {
        private DefaultDebugToolkit() {
        }
    }

    private static class Info {
        public final String debugModelId;
        public final IScriptTypeFactory typeFactory;
        public final Comparator comparator;
        public final IDLTKDebugToolkit debugToolkit;

        public Info(String debugModelId, IScriptTypeFactory typeFactory, IDLTKDebugToolkit debugToolkit, Comparator comparator) {
            this.debugModelId = debugModelId;
            this.typeFactory = typeFactory;
            this.debugToolkit = debugToolkit;
            this.comparator = comparator;
        }
    }
}

