/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelStatus;

public abstract class AbstractExternalSourceModule
extends AbstractSourceModule
implements IExternalSourceModule {
    protected AbstractExternalSourceModule(ModelElement parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) {
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor) {
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) {
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        throw new ModelException(new ModelStatus(967, this));
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) {
    }

    @Override
    public void discardWorkingCopy() {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IStorage.class) {
            return (T)this;
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    public ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) {
        return this;
    }

    @Override
    public boolean isWorkingCopy() {
        return true;
    }

    @Override
    protected boolean hasBuffer() {
        return false;
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
        this.openWhenClosed(this.createElementInfo(), monitor);
    }

    @Override
    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        this.copy(container, sibling, rename, replace, monitor);
    }

    @Override
    public void reconcile(boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) {
    }

    @Override
    public void rename(String name, boolean replace, IProgressMonitor monitor) {
    }

    @Override
    protected void closing(Object info) {
    }

    @Override
    protected IStatus validateSourceModule(IDLTKLanguageToolkit toolkit, IResource resource) {
        IPath path = this.getFullPath();
        if (toolkit == null) {
            toolkit = DLTKLanguageManager.findToolkit(path);
        }
        if (toolkit != null && DLTKContentTypeManager.isValidFileNameForContentType(toolkit, path)) {
            return IModelStatus.VERIFIED_OK;
        }
        return null;
    }
}

