/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.preferences;

import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SQLBuilderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore _store = this.getPreferenceStore();
    Button _btnOmitCurrentSchemaInSQL;
    Button _btnUseAUIDAsCurrentSchema;
    Button _btnSpecifyCurrentSchema;
    Text _txtCurrentSchema;

    protected Control createContents(Composite parent) {
        GridData gd = null;
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, true);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        Label lblCurrentSchemaDesc = new Label(composite, 16384);
        lblCurrentSchemaDesc.setText(Messages._UI_PREFERENCES_OMIT_SCHEMA_DESC);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 1;
        lblCurrentSchemaDesc.setLayoutData((Object)gd);
        this._btnOmitCurrentSchemaInSQL = new Button(composite, 32);
        this._btnOmitCurrentSchemaInSQL.setText(Messages._UI_PREFERENCES_OMIT_SCHEMA_IN_SQL);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 1;
        this._btnOmitCurrentSchemaInSQL.setLayoutData((Object)gd);
        this._btnOmitCurrentSchemaInSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLBuilderPreferencePage.this.updateControls();
            }
        });
        Group groupSpecifySchema = new Group(composite, 16);
        gd = new GridData(4, 1, true, false);
        groupSpecifySchema.setLayoutData((Object)gd);
        GridLayout groupSpecifySchemaLayout = new GridLayout(3, true);
        groupSpecifySchema.setLayout((Layout)groupSpecifySchemaLayout);
        groupSpecifySchema.setText(Messages._UI_PREFERENCES_OMIT_SCHEMA_SPECIFY_SCHEMA_GROUP_TITLE);
        this._btnUseAUIDAsCurrentSchema = new Button((Composite)groupSpecifySchema, 16);
        this._btnUseAUIDAsCurrentSchema.setText(Messages._UI_PREFERENCES_OMIT_SCHEMA_USE_AUID_AS_CURRENT_SCHEMA);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 3;
        this._btnUseAUIDAsCurrentSchema.setLayoutData((Object)gd);
        this._btnUseAUIDAsCurrentSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLBuilderPreferencePage.this.updateControls();
            }
        });
        this._btnSpecifyCurrentSchema = new Button((Composite)groupSpecifySchema, 16);
        this._btnSpecifyCurrentSchema.setText(Messages._UI_PREFERENCES_OMIT_SCHEMA_SCHEMA_NAME);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 1;
        this._btnSpecifyCurrentSchema.setLayoutData((Object)gd);
        this._btnSpecifyCurrentSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLBuilderPreferencePage.this.updateControls();
            }
        });
        this._txtCurrentSchema = new Text((Composite)groupSpecifySchema, 2048);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 2;
        this._txtCurrentSchema.setLayoutData((Object)gd);
        this.initializeValues();
        this.updateControls();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void updateControls() {
        if (this._btnOmitCurrentSchemaInSQL.getSelection()) {
            this._btnUseAUIDAsCurrentSchema.setEnabled(true);
            this._btnSpecifyCurrentSchema.setEnabled(true);
            if (this._btnUseAUIDAsCurrentSchema.getSelection()) {
                this._txtCurrentSchema.setEnabled(false);
            } else {
                this._txtCurrentSchema.setEnabled(true);
            }
        } else {
            this._btnUseAUIDAsCurrentSchema.setEnabled(false);
            this._btnSpecifyCurrentSchema.setEnabled(false);
            this._txtCurrentSchema.setEnabled(false);
        }
    }

    private void initializeValues() {
        this._btnOmitCurrentSchemaInSQL.setSelection(this._store.getBoolean("omit.current.schema.in.sql"));
        if (this._store.getBoolean("omit.current.schema.use.auid")) {
            this._btnUseAUIDAsCurrentSchema.setSelection(true);
            this._btnSpecifyCurrentSchema.setSelection(false);
        } else {
            this._btnSpecifyCurrentSchema.setSelection(true);
            this._btnUseAUIDAsCurrentSchema.setSelection(false);
        }
        this._txtCurrentSchema.setText(this._store.getString("omit.current.schema.current.schema"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SQLBuilderPlugin.getPlugin().getPreferenceStore();
    }

    public boolean performOk() {
        this._store.setValue("omit.current.schema.in.sql", this._btnOmitCurrentSchemaInSQL.getSelection());
        this._store.setValue("omit.current.schema.use.auid", this._btnUseAUIDAsCurrentSchema.getSelection());
        this._store.setValue("omit.current.schema.current.schema", this._txtCurrentSchema.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this._btnOmitCurrentSchemaInSQL.setSelection(this._store.getDefaultBoolean("omit.current.schema.in.sql"));
        if (this._store.getDefaultBoolean("omit.current.schema.use.auid")) {
            this._btnUseAUIDAsCurrentSchema.setSelection(true);
            this._btnSpecifyCurrentSchema.setSelection(false);
        } else {
            this._btnSpecifyCurrentSchema.setSelection(true);
            this._btnUseAUIDAsCurrentSchema.setSelection(false);
        }
        this._txtCurrentSchema.setText(this._store.getDefaultString("omit.current.schema.current.schema"));
        this.updateControls();
    }
}

