/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.AbstractCModelOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CAnnotationIterator;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.asm.AsmContentOutlinePage;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICModelBasedEditor;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.text.AsmSourceViewerConfiguration;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AsmTextEditor
extends TextEditor
implements ISelectionChangedListener,
ICModelBasedEditor {
    private AbstractCModelOutlinePage fOutlinePage;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private ActionGroup fOpenInViewGroup;

    protected void initializeEditor() {
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(store);
        IColorManager colorManager = CDTUITools.getColorManager();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AsmSourceViewerConfiguration(colorManager, store, this, "___c_partitioning"));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setEditorContextMenuId("#ASMEditorContext");
        this.setRulerContextMenuId("#ASMEditorRulerContext");
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] parentPrefPageIds = super.collectContextMenuPreferencePages();
        String[] prefPageIds = new String[parentPrefPageIds.length + 1];
        int nIds = 0;
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeColoringPreferencePage";
        System.arraycopy(parentPrefPageIds, 0, prefPageIds, nIds, parentPrefPageIds.length);
        return prefPageIds;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IContentOutlinePage.class.equals(adapter)) {
            return (T)((Object)this.getOutlinePage());
        }
        return (T)super.getAdapter(adapter);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
    }

    public void dispose() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fOpenInViewGroup != null) {
            this.fOpenInViewGroup.dispose();
            this.fOpenInViewGroup = null;
        }
        super.dispose();
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof AsmSourceViewerConfiguration) {
            return ((AsmSourceViewerConfiguration)configuration).affectsTextPresentation(event);
        }
        return false;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof AsmSourceViewerConfiguration) {
            ((AsmSourceViewerConfiguration)configuration).handlePropertyChangeEvent(event);
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        boolean hasCElement;
        menu.add((IContributionItem)new GroupMarker("group.top"));
        menu.add((IContributionItem)new Separator("group.debug"));
        menu.add((IContributionItem)new GroupMarker("group.debug.end"));
        super.editorContextMenuAboutToShow(menu);
        boolean bl = hasCElement = this.getInputCElement() != null;
        if (hasCElement) {
            this.addAction(menu, "group.open", "OpenDeclarations");
            this.fOpenInViewGroup.fillContextMenu(menu);
        }
    }

    public AbstractCModelOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new AsmContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        AsmTextEditor.setOutlinePageInput(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public static void setOutlinePageInput(AbstractCModelOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            page.setInput((ITranslationUnit)manager.getWorkingCopy(input));
        }
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        ISourceReference element = this.computeHighlightRangeSourceReference();
        this.updateStatusLine();
        this.synchronizeOutlinePage();
        this.setSelection(element, false);
    }

    protected void synchronizeOutlinePage() {
        if (this.fOutlinePage != null && this.fOutlinePage.isLinkingEnabled()) {
            this.fOutlinePage.removeSelectionChangedListener(this);
            this.fOutlinePage.synchronizeSelectionWithEditor();
            this.fOutlinePage.addSelectionChangedListener(this);
        }
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (annotation instanceof ICAnnotation && ((ICAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator parent = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        CAnnotationIterator e = new CAnnotationIterator(parent, false);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getSelection().x);
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getSelection().x;
        }
        ICElement element = this.getElementAt(caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        return (ISourceReference)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICElement getElementAt(int offset, boolean reconcile) {
        IWorkingCopy unit = this.getInputCElement();
        if (unit != null) {
            try {
                if (reconcile && unit instanceof IWorkingCopy) {
                    IWorkingCopy iWorkingCopy = unit;
                    synchronized (iWorkingCopy) {
                        unit.reconcile();
                    }
                    return unit.getElementAtOffset(offset);
                }
                if (unit.isConsistent()) {
                    return unit.getElementAtOffset(offset);
                }
            }
            catch (CModelException x) {
                CUIPlugin.log(x.getStatus());
            }
        }
        return null;
    }

    public IWorkingCopy getInputCElement() {
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void setSelection(ICElement element) {
        if (element instanceof ISourceReference && !(element instanceof ITranslationUnit)) {
            ISourceReference reference = (ISourceReference)element;
            this.setSelection(reference, true);
        }
    }

    public void setSelection(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            StyledText textWidget = null;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer != null) {
                textWidget = sourceViewer.getTextWidget();
            }
            if (textWidget == null) {
                return;
            }
            try {
                this.setSelection(element.getSourceRange(), moveCursor);
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        block19: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (element != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer == null) {
                    return;
                }
                textWidget = sourceViewer.getTextWidget();
                if (textWidget == null) {
                    return;
                }
                try {
                    IRegion alternateRegion = null;
                    int start = element.getStartPos();
                    int length = element.getLength();
                    if (start < 0 || length < 0) {
                        start = 0;
                        length = 0;
                    }
                    if (length == 0 && start == 0 && element.getStartLine() > 0) {
                        start = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getStartLine() - 1);
                        length = element.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getEndLine()) - start : start;
                        alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine() - 1);
                        if ((start == length || length < 0) && alternateRegion != null) {
                            start = alternateRegion.getOffset();
                            length = alternateRegion.getLength();
                        }
                    }
                    this.setHighlightRange(start, length, moveCursor);
                    if (!moveCursor) break block19;
                    start = element.getIdStartPos();
                    length = element.getIdLength();
                    if (start == 0 && length == 0 && alternateRegion != null) {
                        start = alternateRegion.getOffset();
                        length = alternateRegion.getLength();
                    }
                    if (start > -1 && length > 0) {
                        try {
                            textWidget.setRedraw(false);
                            sourceViewer.revealRange(start, length);
                            sourceViewer.setSelectedRange(start, length);
                        }
                        finally {
                            textWidget.setRedraw(true);
                        }
                        this.markInNavigationHistory();
                    }
                    this.updateStatusField("InputPosition");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (BadLocationException badLocationException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    public ITranslationUnit getTranslationUnit() {
        return this.getInputCElement();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.cdt.ui.asmEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        this.fOpenInViewGroup = new OpenViewActionGroup(this);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fOpenInViewGroup.fillActionBars(actionBars);
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)AsmTextEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AsmTextEditor.this.selectionChanged();
        }
    }
}

