/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerWizard;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathIncludeSymbolEntryBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CPathIncludeSymbolEntryPage
extends CPathIncludeSymbolEntryBasePage {
    private TreeListDialogField<CPElementGroup> fIncludeSymPathsList;
    private SelectionButtonDialogField fShowInheritedPaths;
    private ICProject fCurrCProject;
    private CPElementFilter fFilter;
    private IStatusChangeListener fContext;
    private final int IDX_ADD_FOLDER_FILE = 0;
    private final int IDX_ADD_SYMBOL = 2;
    private final int IDX_ADD_EXT_INCLUDE = 4;
    private final int IDX_ADD_WS_INCLUDE = 5;
    private final int IDX_ADD_CONTRIBUTED = 7;
    private final int IDX_EDIT = 9;
    private final int IDX_REMOVE = 10;
    private final int IDX_EXPORT = 12;
    private final int IDX_UP = 14;
    private final int IDX_DOWN = 15;
    private static final String[] buttonLabel;
    private CPElementGroup fTopGroup;

    static {
        String[] stringArray = new String[16];
        stringArray[0] = CPathEntryMessages.IncludeSymbolEntryPage_addFolderFile;
        stringArray[2] = CPathEntryMessages.IncludeSymbolEntryPage_addUserSymbol;
        stringArray[4] = CPathEntryMessages.IncludeSymbolEntryPage_addExternalInclude;
        stringArray[5] = CPathEntryMessages.IncludeSymbolEntryPage_addFromWorkspace;
        stringArray[7] = CPathEntryMessages.IncludeSymbolEntryPage_addContributed;
        stringArray[9] = CPathEntryMessages.IncludeSymbolEntryPage_edit;
        stringArray[10] = CPathEntryMessages.IncludeSymbolEntryPage_remove;
        stringArray[12] = CPathEntryMessages.IncludeSymbolEntryPage_export;
        stringArray[14] = CPathEntryMessages.IncludeSymbolEntryPage_up;
        stringArray[15] = CPathEntryMessages.IncludeSymbolEntryPage_down;
        buttonLabel = stringArray;
    }

    public CPathIncludeSymbolEntryPage(IStatusChangeListener context) {
        super(CPathEntryMessages.IncludeSymbolEntryPage_title);
        this.fContext = context;
        IncludeSymbolAdapter adapter = new IncludeSymbolAdapter();
        this.fIncludeSymPathsList = new TreeListDialogField<CPElementGroup>((ITreeListAdapter)adapter, buttonLabel, (ILabelProvider)new CPElementLabelProvider(true, false)){

            @Override
            protected int getTreeStyle() {
                return super.getTreeStyle() & 0xFFFFFFFD;
            }
        };
        this.fIncludeSymPathsList.setLabelText(CPathEntryMessages.IncludeSymbolEntryPage_label);
        this.fIncludeSymPathsList.enableButton(10, false);
        this.fIncludeSymPathsList.enableButton(9, false);
        this.fIncludeSymPathsList.enableButton(7, true);
        this.fIncludeSymPathsList.enableButton(4, true);
        this.fIncludeSymPathsList.enableButton(5, true);
        this.fIncludeSymPathsList.enableButton(2, true);
        this.fIncludeSymPathsList.enableButton(12, false);
        this.fIncludeSymPathsList.enableButton(14, false);
        this.fIncludeSymPathsList.enableButton(15, false);
        this.fIncludeSymPathsList.setTreeExpansionLevel(2);
        this.fShowInheritedPaths = new SelectionButtonDialogField(32);
        this.fShowInheritedPaths.setSelection(true);
        this.fShowInheritedPaths.setLabelText(CPathEntryMessages.IncludeSymbolsEntryPage_show_inherited_check);
        this.fShowInheritedPaths.setDialogFieldListener(adapter);
        this.fFilter = new CPElementFilter(new int[]{-1, 16, 64, 32}, false, true);
    }

    @Override
    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fIncludeSymPathsList, this.fShowInheritedPaths}, true);
        LayoutUtil.setHorizontalGrabbing(this.fIncludeSymPathsList.getTreeControl(null), true);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fIncludeSymPathsList.setButtonsMinWidth(buttonBarWidth);
        this.setControl((Control)composite);
        this.fIncludeSymPathsList.getTreeViewer().addFilter((ViewerFilter)this.fFilter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_include");
    }

    public Image getImage() {
        return CDTSharedImages.getImage("icons/obj16/includes_container.gif");
    }

    @Override
    public void init(ICElement cElement, List<CPElement> cPaths) {
        this.fCurrCProject = cElement.getCProject();
        List<CPElementGroup> elements = this.createGroups(cElement, cPaths);
        this.fIncludeSymPathsList.setElements(elements);
        this.updateStatus();
    }

    private void updateStatus() {
        CPElement entryError = null;
        int nErrorEntries = 0;
        Object status = Status.OK_STATUS;
        List<CPElement> elements = this.getCPaths();
        int i = elements.size() - 1;
        while (i >= 0) {
            CPElement currElement = elements.get(i);
            if (currElement.getStatus().getSeverity() != 0) {
                ++nErrorEntries;
                if (entryError == null) {
                    entryError = currElement;
                }
            }
            --i;
        }
        if (nErrorEntries > 0) {
            status = nErrorEntries == 1 && entryError != null ? entryError.getStatus() : new Status(2, "org.eclipse.cdt.ui", -1, NLS.bind((String)CPathEntryMessages.CPElement_status_multiplePathErrors, (Object)String.valueOf(nErrorEntries)), null);
        }
        this.fContext.statusChanged((IStatus)status);
    }

    private void updateStatus(List<?> selected) {
        if (selected.size() != 1) {
            this.updateStatus();
            return;
        }
        CPElement element = null;
        if (selected.get(0) instanceof CPElement) {
            element = (CPElement)selected.get(0);
        } else if (selected.get(0) instanceof CPElementAttribute) {
            element = ((CPElementAttribute)selected.get(0)).getParent();
        }
        if (element == null || element.getStatus().getSeverity() == 0) {
            this.updateStatus();
            return;
        }
        this.fContext.statusChanged(element.getStatus());
    }

    private List<CPElementGroup> createGroups(ICElement element, List<?> cPaths) {
        CPElement cpelement;
        ArrayList<CPElementGroup> resourceGroups = new ArrayList<CPElementGroup>(5);
        this.fTopGroup = new CPElementGroup(element.getResource());
        resourceGroups.add(this.fTopGroup);
        int i = 0;
        while (i < cPaths.size()) {
            cpelement = (CPElement)cPaths.get(i);
            switch (cpelement.getEntryKind()) {
                case 32: {
                    this.fTopGroup.addChild(cpelement);
                }
            }
            ++i;
        }
        i = 0;
        while (i < cPaths.size()) {
            cpelement = (CPElement)cPaths.get(i);
            switch (cpelement.getEntryKind()) {
                case 16: 
                case 64: {
                    CPElementGroup resGroup = new CPElementGroup(cpelement.getResource());
                    int ndx = resourceGroups.indexOf(resGroup);
                    if (ndx == -1) {
                        resourceGroups.add(resGroup);
                    } else {
                        resGroup = (CPElementGroup)resourceGroups.get(ndx);
                    }
                    resGroup.addChild(cpelement);
                }
            }
            ++i;
        }
        i = 0;
        while (i < cPaths.size()) {
            cpelement = (CPElement)cPaths.get(i);
            switch (cpelement.getEntryKind()) {
                case 16: 
                case 64: {
                    this.addPathToResourceGroups(cpelement, null, resourceGroups);
                }
            }
            ++i;
        }
        return resourceGroups;
    }

    private void addPathToResourceGroup(CPElement element, CPElementGroup parent, CPElementGroup group) {
        IPath resPath = element.getPath();
        IPath[] exclusions = (IPath[])element.getAttribute("exclusion");
        if (!(group == parent && group.getResource().equals((Object)element.getResource()) || !resPath.isPrefixOf(group.getPath()) || !resPath.equals((Object)group.getPath()) && CoreModelUtil.isExcludedPath((IPath)group.getResource().getFullPath().removeFirstSegments(resPath.segmentCount()), (IPath[])exclusions))) {
            if (parent != null) {
                int insertHere = -1;
                int ndx = parent.indexof(element);
                if (ndx != -1) {
                    CPElement[] children = parent.getChildren(element.getEntryKind());
                    int i = ndx;
                    while (i < children.length) {
                        insertHere = group.indexof(new CPElement(children[i], group.getPath(), group.getResource()));
                        if (insertHere != -1) {
                            group.addChild(new CPElement(element, group.getPath(), group.getResource()), insertHere);
                            break;
                        }
                        ++i;
                    }
                }
                if (insertHere == -1) {
                    group.addChild(new CPElement(element, group.getPath(), group.getResource()));
                }
            } else {
                group.addChild(new CPElement(element, group.getPath(), group.getResource()));
            }
        }
    }

    private void addPathToResourceGroups(CPElement element, CPElementGroup parent, List<CPElementGroup> groups) {
        if (parent != null) {
            parent.addChild(element);
        }
        int i = 0;
        while (i < groups.size()) {
            CPElementGroup group = groups.get(i);
            this.addPathToResourceGroup(element, parent, group);
            ++i;
        }
    }

    private void updatePathOnResourceGroups(CPElement element, List<CPElementGroup> groups) {
        CPElementGroup parent = element.getParent();
        IPath resPath = element.getPath();
        IPath[] exclusions = (IPath[])element.getAttribute("exclusion");
        int i = 0;
        while (i < groups.size()) {
            CPElementGroup group = groups.get(i);
            if (group != parent) {
                CPElement[] elements;
                boolean found = false;
                CPElement[] cPElementArray = elements = group.getChildren(element.getEntryKind());
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    CPElement element2 = cPElementArray[n2];
                    if (element2.getInherited() == element) {
                        found = true;
                        if (!CoreModelUtil.isExcludedPath((IPath)group.getResource().getFullPath().removeFirstSegments(resPath.segmentCount()), (IPath[])exclusions)) {
                            group.replaceChild(element2, new CPElement(element, group.getPath(), group.getResource()));
                            break;
                        }
                        group.removeChild(element2);
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    this.addPathToResourceGroup(element, parent, group);
                }
            }
            ++i;
        }
    }

    private CPElement removePathFromResourceGroups(CPElement element, List<CPElementGroup> groups) {
        CPElement Inherited = element.getInherited();
        CPElementGroup resGroup = element.getParent();
        resGroup.removeChild(element);
        if (Inherited != null) {
            IPath exclude = element.getPath().removeFirstSegments(Inherited.getPath().segmentCount());
            IPath[] exclusions = (IPath[])Inherited.getAttribute("exclusion");
            IPath[] newExlusions = new IPath[exclusions.length + 1];
            System.arraycopy(exclusions, 0, newExlusions, 0, exclusions.length);
            newExlusions[exclusions.length] = exclude;
            Inherited.setAttribute("exclusion", newExlusions);
            return null;
        }
        int i = 0;
        while (i < groups.size()) {
            CPElement[] elements;
            CPElementGroup group = groups.get(i);
            CPElement[] cPElementArray = elements = group.getChildren(element.getEntryKind());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                CPElement element2 = cPElementArray[n2];
                if (element2.getInherited() == element) {
                    group.removeChild(element2);
                    break;
                }
                ++n2;
            }
            ++i;
        }
        return element;
    }

    private boolean canAddPath(List<?> selected) {
        CPElementGroup group = this.getSelectedGroup();
        if (group != null) {
            return group.getEntryKind() == -1;
        }
        return false;
    }

    private boolean canRemove(List<?> selected) {
        CPElementAttribute attrib;
        if (selected.size() != 1) {
            return false;
        }
        Object elem = selected.get(0);
        if (elem instanceof CPElement) {
            CPElement element = (CPElement)elem;
            if (element.getParentContainer() == null) {
                return element.getEntryKind() == 16 || element.getEntryKind() == 64;
            }
        } else if (elem instanceof CPElementAttribute && (attrib = (CPElementAttribute)elem).getKey().equals("exclusion") && ((IPath[])attrib.getValue()).length > 0) {
            return true;
        }
        return false;
    }

    private void removeEntry() {
        List<?> selected = this.getSelection();
        Object elem = selected.get(0);
        if (elem instanceof CPElement) {
            CPElement element = (CPElement)elem;
            CPElementGroup parent = element.getParent();
            if (this.removePathFromResourceGroups(element, this.fIncludeSymPathsList.getElements()) == null) {
                this.updatePathOnResourceGroups(element.getInherited(), this.fIncludeSymPathsList.getElements());
            }
            this.fIncludeSymPathsList.refresh();
            this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)parent));
        } else if (elem instanceof CPElementAttribute) {
            CPElementAttribute attrib = (CPElementAttribute)elem;
            String key = attrib.getKey();
            Path[] value = key.equals("exclusion") ? new Path[]{} : null;
            attrib.getParent().setAttribute(key, value);
            this.updatePathOnResourceGroups(attrib.getParent(), this.fIncludeSymPathsList.getElements());
            this.fIncludeSymPathsList.refresh();
        }
        this.updateStatus();
    }

    private boolean canEdit(List<?> selected) {
        CPElement element;
        if (selected.size() != 1) {
            return false;
        }
        Object elem = selected.get(0);
        if (elem instanceof CPElement && (element = (CPElement)selected.get(0)).getParentContainer() == null && element.getInherited() == null) {
            IPath path = (IPath)element.getAttribute("base-ref");
            if (path != null && !path.equals((Object)Path.EMPTY)) {
                return false;
            }
            return element.getEntryKind() == 16 || element.getEntryKind() == 64 || element.getEntryKind() == 32;
        }
        return elem instanceof CPElementAttribute;
    }

    private void editEntry() {
        List<Object> selElements = this.fIncludeSymPathsList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object element = selElements.get(0);
        if (element instanceof CPElement) {
            this.editElementEntry((CPElement)element);
        } else if (element instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)element);
        }
    }

    private void editElementEntry(CPElement element) {
        IPath path = (IPath)element.getAttribute("base-ref");
        if (path != null && !path.equals((Object)Path.EMPTY)) {
            return;
        }
        if (element.getEntryKind() == 64) {
            this.addSymbol(element);
        } else if (element.getEntryKind() == 16) {
            path = (IPath)element.getAttribute("base-path");
            if (path != null && !path.equals((Object)Path.EMPTY)) {
                CPElement[] includes = this.openWorkspacePathEntryDialog(null);
                if (includes != null && includes.length > 0) {
                    includes[0].setExported(element.isExported());
                }
            } else {
                this.addInclude(element);
            }
        } else if (element.getEntryKind() == 32) {
            CPElement[] res = null;
            res = this.openContainerSelectionDialog(element);
            if (res != null && res.length > 0) {
                CPElement curr = res[0];
                curr.setExported(element.isExported());
                this.fTopGroup.replaceChild(element, curr);
                this.fIncludeSymPathsList.refresh();
            }
        }
    }

    private void editAttributeEntry(CPElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("exclusion")) {
            CPElement selElement = elem.getParent();
            ExclusionPatternDialog dialog = new ExclusionPatternDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("exclusion", dialog.getExclusionPattern());
                this.updatePathOnResourceGroups(selElement, this.fIncludeSymPathsList.getElements());
                this.fIncludeSymPathsList.refresh();
                this.updateStatus();
            }
        }
    }

    private void exportEntry() {
        CPElement element;
        element.setExported(!(element = (CPElement)this.getSelection().get(0)).isExported());
        this.fIncludeSymPathsList.refresh(element);
    }

    private boolean canExport(List<?> selected) {
        CPElement element;
        if (selected.size() != 1) {
            return false;
        }
        Object elem = selected.get(0);
        if (elem instanceof CPElement && (element = (CPElement)selected.get(0)).getParentContainer() == null && element.getInherited() == null) {
            IPath base_ref = (IPath)element.getAttribute("base-ref");
            if (base_ref != null && !base_ref.equals((Object)Path.EMPTY)) {
                return false;
            }
            return element.getEntryKind() == 16 || element.getEntryKind() == 64;
        }
        return false;
    }

    private boolean canMove(List<?> selected) {
        if (selected.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selected.size()) {
            Object element = selected.get(i);
            if (!(element instanceof CPElement)) {
                return false;
            }
            CPElement elem = (CPElement)element;
            if (elem.getEntryKind() != 16 && elem.getEntryKind() != 64) {
                return false;
            }
            if (elem.getParentContainer() != null || elem.getInherited() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canMoveUp(List<?> selected) {
        if (!this.canMove(selected)) {
            return false;
        }
        CPElement first = (CPElement)selected.get(0);
        CPElementGroup parent = first.getParent();
        CPElement[] children = parent.getChildren(first.getEntryKind());
        int indx = Arrays.asList(children).indexOf(first);
        return indx > 0;
    }

    private boolean canMoveDown(List<?> selected) {
        if (!this.canMove(selected)) {
            return false;
        }
        CPElement last = (CPElement)selected.get(selected.size() - 1);
        CPElementGroup parent = last.getParent();
        CPElement[] children = parent.getChildren(last.getEntryKind());
        int indx = Arrays.asList(children).indexOf(last);
        return indx < children.length - 1 && children[indx + 1].getInherited() == null;
    }

    private boolean moveUp(CPElement element) {
        boolean rc = false;
        int kind = element.getEntryKind();
        for (CPElementGroup group : this.fIncludeSymPathsList.getElements()) {
            CPElement[] children = group.getChildren(kind);
            int k = 0;
            while (k < children.length) {
                CPElement child = children[k];
                if (element.equals(child) || child.getInherited() != null && child.getInherited().equals(element)) {
                    if (child.getInherited() != null && k > 0 && children[k - 1].getInherited() == null) break;
                    int prevIndex = k - 1;
                    if (prevIndex >= 0) {
                        children[k] = children[prevIndex];
                        children[prevIndex] = child;
                        rc = true;
                        break;
                    }
                }
                ++k;
            }
            group.setChildren(children);
        }
        this.fIncludeSymPathsList.refresh();
        this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)element));
        this.fIncludeSymPathsList.setFocus();
        return rc;
    }

    private boolean moveDown(CPElement element) {
        boolean rc = false;
        int kind = element.getEntryKind();
        for (CPElementGroup group : this.fIncludeSymPathsList.getElements()) {
            CPElement[] children = group.getChildren(kind);
            int k = children.length - 1;
            while (k >= 0) {
                int prevIndex;
                CPElement child = children[k];
                if ((element.equals(child) || child.getInherited() != null && child.getInherited().equals(element)) && (prevIndex = k + 1) < children.length) {
                    children[k] = children[prevIndex];
                    children[prevIndex] = child;
                    rc = true;
                    break;
                }
                --k;
            }
            group.setChildren(children);
        }
        this.fIncludeSymPathsList.refresh();
        this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)element));
        this.fIncludeSymPathsList.setFocus();
        return rc;
    }

    private CPElementGroup getSelectedGroup() {
        List<Object> selected = this.fIncludeSymPathsList.getSelectedElements();
        if (!selected.isEmpty()) {
            Object item = selected.get(0);
            if (item instanceof CPElement) {
                item = ((CPElement)item).getParent();
            }
            if (item instanceof CPElementGroup) {
                return (CPElementGroup)item;
            }
        }
        return this.fTopGroup;
    }

    protected void listPageDialogFieldChanged(DialogField field) {
        if (field == this.fShowInheritedPaths) {
            boolean showInherited = this.fShowInheritedPaths.isSelected();
            if (this.fFilter != null) {
                this.fIncludeSymPathsList.getTreeViewer().removeFilter((ViewerFilter)this.fFilter);
            }
            this.fFilter = new CPElementFilter(new int[]{-1, 16, 64, 32}, false, showInherited);
            this.fIncludeSymPathsList.getTreeViewer().addFilter((ViewerFilter)this.fFilter);
            this.fIncludeSymPathsList.refresh();
        }
        this.updateStatus();
    }

    protected void listPageSelectionChanged(TreeListDialogField<?> field) {
        List<Object> selected = field.getSelectedElements();
        field.enableButton(10, this.canRemove(selected));
        field.enableButton(9, this.canEdit(selected));
        field.enableButton(7, this.canAddPath(selected));
        field.enableButton(4, this.canAddPath(selected));
        field.enableButton(5, this.canAddPath(selected));
        field.enableButton(2, this.canAddPath(selected));
        field.enableButton(12, this.canExport(selected));
        field.enableButton(15, this.canMoveDown(selected));
        field.enableButton(14, this.canMoveUp(selected));
        this.updateStatus(selected);
    }

    protected void ListCustomButtonPressed(TreeListDialogField<?> field, int index) {
        switch (index) {
            case 0: {
                this.addNewPathResource();
                break;
            }
            case 2: {
                this.addSymbol(null);
                break;
            }
            case 4: {
                this.addInclude(null);
                break;
            }
            case 5: {
                this.addFromWorkspace();
                break;
            }
            case 7: {
                this.addContributed();
                break;
            }
            case 9: {
                if (!this.canEdit(field.getSelectedElements())) break;
                this.editEntry();
                break;
            }
            case 10: {
                if (!this.canRemove(field.getSelectedElements())) break;
                this.removeEntry();
                break;
            }
            case 15: {
                if (!this.canMoveDown(field.getSelectedElements())) break;
                this.moveDown((CPElement)field.getSelectedElements().get(0));
                break;
            }
            case 14: {
                if (!this.canMoveUp(field.getSelectedElements())) break;
                this.moveUp((CPElement)field.getSelectedElements().get(0));
                break;
            }
            case 12: {
                if (!this.canExport(field.getSelectedElements())) break;
                this.exportEntry();
            }
        }
    }

    protected void ListPageDoubleClicked(TreeListDialogField<?> field) {
        if (this.canEdit(this.fIncludeSymPathsList.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void ListPageKeyPressed(TreeListDialogField<?> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fIncludeSymPathsList && event.character == '\u007f' && event.stateMask == 0 && this.canEdit(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected IPathEntry[] getRawPathEntries() {
        List<CPElement> paths = this.getCPaths();
        IPathEntry[] currEntries = new IPathEntry[paths.size()];
        int i = 0;
        while (i < currEntries.length) {
            CPElement curr = paths.get(i);
            currEntries[i] = curr.getPathEntry();
            ++i;
        }
        return currEntries;
    }

    protected void addNewPathResource() {
        Class[] acceptedClasses = new Class[]{ICProject.class, ICContainer.class, ITranslationUnit.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        String title = CPathEntryMessages.IncludeSymbolEntryPage_newResource_title;
        String message = CPathEntryMessages.IncludeSymbolEntryPage_newResource_description;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new CElementContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrCProject);
        dialog.setInitialSelection((Object)this.fCurrCProject);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IResource resource = elements[0] instanceof IResource ? (IResource)elements[0] : ((ICElement)elements[0]).getResource();
            CPElementGroup newGroup = new CPElementGroup(resource);
            if (!this.fIncludeSymPathsList.getElements().contains(newGroup)) {
                List<CPElementGroup> groups = this.fIncludeSymPathsList.getElements();
                int i = 0;
                while (i < groups.size()) {
                    CPElementGroup group = groups.get(i);
                    if (group.getPath().isPrefixOf(newGroup.getPath())) {
                        CPElement[] cpelements;
                        CPElement[] cPElementArray = cpelements = group.getChildren();
                        int n = cpelements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CPElement cpelement = cPElementArray[n2];
                            if (cpelement.getInherited() == null) {
                                switch (cpelement.getEntryKind()) {
                                    case 16: 
                                    case 64: {
                                        this.addPathToResourceGroup(cpelement, null, newGroup);
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
                this.fIncludeSymPathsList.addElement(newGroup);
            }
            this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)newGroup));
            this.fIncludeSymPathsList.expandElement(newGroup, 1);
        }
    }

    protected void addSymbol(CPElement existing) {
        InputDialog dialog;
        if (existing == null) {
            dialog = new InputDialog(this.getShell(), CPathEntryMessages.IncludeSymbolEntryPage_addSymbol_title, CPathEntryMessages.IncludeSymbolEntryPage_addSymbol_message, "", null);
        } else {
            StringBuilder initialValue = new StringBuilder();
            initialValue.append((String)existing.getAttribute("macroname"));
            initialValue.append('=');
            initialValue.append((String)existing.getAttribute("macrovalue"));
            dialog = new InputDialog(this.getShell(), CPathEntryMessages.IncludeSymbolEntryPage_editSymbol_title, CPathEntryMessages.IncludeSymbolEntryPage_editSymbol_message, initialValue.toString(), null);
        }
        String symbol = null;
        if (dialog.open() == 0 && (symbol = dialog.getValue()) != null && symbol.length() > 0) {
            String name;
            CPElementGroup group = this.getSelectedGroup();
            CPElement newPath = new CPElement(this.fCurrCProject, 64, group.getResource().getFullPath(), group.getResource());
            String value = "";
            int index = symbol.indexOf("=");
            if (index != -1) {
                name = symbol.substring(0, index).trim();
                value = symbol.substring(index + 1).trim();
            } else {
                name = symbol.trim();
            }
            if (existing != null) {
                existing.setAttribute("macroname", name);
                existing.setAttribute("macrovalue", value);
                this.updatePathOnResourceGroups(existing, this.fIncludeSymPathsList.getElements());
                this.fIncludeSymPathsList.refresh();
            } else {
                newPath.setAttribute("macroname", name);
                newPath.setAttribute("macrovalue", value);
                if (!group.contains(newPath)) {
                    this.addPathToResourceGroups(newPath, group, this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)newPath));
                }
                this.updateStatus();
            }
        }
    }

    protected void addInclude(CPElement existing) {
        SelectPathInputDialog dialog = existing == null ? new SelectPathInputDialog(this.getShell(), CPathEntryMessages.IncludeSymbolEntryPage_addExternal_title, CPathEntryMessages.IncludeSymbolEntryPage_addExternal_message, null, null) : new SelectPathInputDialog(this.getShell(), CPathEntryMessages.IncludeSymbolEntryPage_editExternal_title, CPathEntryMessages.IncludeSymbolEntryPage_editExternal_message, ((IPath)existing.getAttribute("includepath")).toOSString(), null);
        String newItem = null;
        if (dialog.open() == 0 && (newItem = dialog.getValue()) != null && !newItem.isEmpty()) {
            if (existing == null) {
                CPElementGroup group = this.getSelectedGroup();
                CPElement newPath = new CPElement(this.fCurrCProject, 16, group.getResource().getFullPath(), group.getResource());
                newPath.setAttribute("includepath", new Path(newItem));
                if (!group.contains(newPath)) {
                    this.addPathToResourceGroups(newPath, group, this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)newPath));
                }
            } else {
                existing.setAttribute("includepath", new Path(newItem));
                this.updatePathOnResourceGroups(existing, this.fIncludeSymPathsList.getElements());
                this.fIncludeSymPathsList.refresh();
            }
            this.updateStatus();
        }
    }

    protected void addFromWorkspace() {
        CPElement[] includes = this.openWorkspacePathEntryDialog(null);
        if (includes != null && includes.length > 0) {
            int nElementsChosen = includes.length;
            CPElementGroup group = this.getSelectedGroup();
            int i = 0;
            while (i < nElementsChosen) {
                CPElement curr = includes[i];
                if (!group.contains(curr)) {
                    this.addPathToResourceGroups(curr, group, this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)curr));
                    this.updateStatus();
                }
                ++i;
            }
        }
    }

    protected void addContributed() {
        CPElement[] includes = this.openContainerSelectionDialog(null);
        if (includes != null && includes.length > 0) {
            int nElementsChosen = includes.length;
            CPElementGroup group = this.getSelectedGroup();
            int i = 0;
            while (i < nElementsChosen) {
                CPElement curr = includes[i];
                if (!group.contains(curr)) {
                    this.addPathToResourceGroups(curr, this.getSelectedGroup(), this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)curr));
                    this.updateStatus();
                }
                ++i;
            }
        }
    }

    protected CPElement[] openWorkspacePathEntryDialog(CPElement existing) {
        Class[] acceptedClasses = new Class[]{ICProject.class, IProject.class, IContainer.class, ICContainer.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, existing == null);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        String title = existing == null ? CPathEntryMessages.IncludeSymbolEntryPage_fromWorkspaceDialog_new_title : CPathEntryMessages.IncludeSymbolEntryPage_fromWorkspaceDialog_edit_title;
        String message = existing == null ? CPathEntryMessages.IncludeSymbolEntryPage_fromWorkspaceDialog_new_description : CPathEntryMessages.IncludeSymbolEntryPage_fromWorkspaceDialog_edit_description;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new CElementContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)CoreModel.getDefault().getCModel());
        if (existing == null) {
            dialog.setInitialSelection((Object)this.fCurrCProject);
        } else {
            dialog.setInitialSelection((Object)existing.getCProject());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPElement[] res = new CPElement[elements.length];
            int i = 0;
            while (i < res.length) {
                IPath includePath;
                IProject project;
                if (elements[i] instanceof IResource) {
                    project = ((IResource)elements[i]).getProject();
                    includePath = ((IResource)elements[i]).getProjectRelativePath();
                } else {
                    project = ((ICElement)elements[i]).getCProject().getProject();
                    includePath = ((ICElement)elements[i]).getResource().getProjectRelativePath();
                }
                CPElementGroup group = this.getSelectedGroup();
                res[i] = new CPElement(this.fCurrCProject, 16, group.getResource().getFullPath(), group.getResource());
                res[i].setAttribute("base-path", project.getFullPath().makeRelative());
                res[i].setAttribute("includepath", includePath);
                ++i;
            }
            return res;
        }
        return null;
    }

    protected CPElement[] openContainerSelectionDialog(CPElement existing) {
        String title;
        IContainerEntry elem = null;
        if (existing == null) {
            title = CPathEntryMessages.IncludeSymbolEntryPage_ContainerDialog_new_title;
        } else {
            title = CPathEntryMessages.IncludeSymbolEntryPage_ContainerDialog_edit_title;
            elem = (IContainerEntry)existing.getPathEntry();
        }
        CPathContainerWizard wizard = new CPathContainerWizard(elem, null, (ICElement)this.fCurrCProject, this.getRawPathEntries(), new int[]{16, 64});
        wizard.setWindowTitle(title);
        if (CPathContainerWizard.openWizard(this.getShell(), wizard) == 0) {
            IPathEntry parent = wizard.getEntriesParent();
            IPathEntry[] elements = wizard.getEntries();
            if (elements != null) {
                CPElement[] res = new CPElement[elements.length];
                CPElementGroup group = this.getSelectedGroup();
                int i = 0;
                while (i < res.length) {
                    if (elements[i].getEntryKind() == 16) {
                        res[i] = new CPElement(this.fCurrCProject, 16, group.getResource().getFullPath(), group.getResource());
                        res[i].setAttribute("includepath", ((IIncludeEntry)elements[i]).getIncludePath());
                        res[i].setAttribute("base-ref", parent.getPath());
                    } else if (elements[i].getEntryKind() == 64) {
                        res[i] = new CPElement(this.fCurrCProject, 64, group.getResource().getFullPath(), group.getResource());
                        res[i].setAttribute("macroname", ((IMacroEntry)elements[i]).getMacroName());
                        res[i].setAttribute("base-ref", parent.getPath());
                    }
                    ++i;
                }
                return res;
            }
            return new CPElement[]{CPElement.createFromExisting(parent, (ICElement)this.fCurrCProject)};
        }
        return null;
    }

    @Override
    public List<?> getSelection() {
        return this.fIncludeSymPathsList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements) {
        this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 16 || kind == 64;
    }

    @Override
    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void performDefaults() {
    }

    @Override
    public List<CPElement> getCPaths() {
        ArrayList<CPElement> cPaths = new ArrayList<CPElement>();
        List<CPElementGroup> groups = this.fIncludeSymPathsList.getElements();
        int i = 0;
        while (i < groups.size()) {
            CPElement[] elements;
            CPElementGroup group = groups.get(i);
            CPElement[] cPElementArray = elements = group.getChildren();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                CPElement element = cPElementArray[n2];
                if (element.getInherited() == null) {
                    cPaths.add(element);
                }
                ++n2;
            }
            ++i;
        }
        return cPaths;
    }

    private class IncludeSymbolAdapter
    implements IDialogFieldListener,
    ITreeListAdapter<CPElementGroup> {
        private final Object[] EMPTY_ARR = new Object[0];

        private IncludeSymbolAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPElementGroup> field, int index) {
            CPathIncludeSymbolEntryPage.this.ListCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPElementGroup> field) {
            CPathIncludeSymbolEntryPage.this.listPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPElementGroup> field) {
            CPathIncludeSymbolEntryPage.this.ListPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPElementGroup> field, KeyEvent event) {
            CPathIncludeSymbolEntryPage.this.ListPageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPElementGroup> field, Object element) {
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren();
            }
            if (element instanceof CPElementGroup) {
                return ((CPElementGroup)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField<CPElementGroup> field, Object element) {
            if (element instanceof CPElementGroup) {
                return ((CPElementGroup)element).getParent();
            }
            if (element instanceof CPElement) {
                return ((CPElement)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPElementGroup> field, Object element) {
            if (element instanceof CPElementGroup) {
                return true;
            }
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren().length > 0;
            }
            return false;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            CPathIncludeSymbolEntryPage.this.listPageDialogFieldChanged(field);
        }
    }

    private class SelectPathInputDialog
    extends InputDialog {
        public SelectPathInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button browse = this.createButton(parent, 3, CPathEntryMessages.IncludeSymbolEntryPage_addExternal_button_browse, false);
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent ev) {
                    String dirname;
                    DirectoryDialog dialog = new DirectoryDialog(SelectPathInputDialog.this.getShell(), 4096);
                    dialog.setText(CPathEntryMessages.IncludeSymbolEntryPage_browseForFolder);
                    String currentName = SelectPathInputDialog.this.getText().getText();
                    if (currentName != null && currentName.trim().length() != 0) {
                        dialog.setFilterPath(currentName);
                    }
                    if ((dirname = dialog.open()) != null) {
                        SelectPathInputDialog.this.getText().setText(dirname);
                    }
                }
            });
        }
    }
}

