/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.functionservice.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class ScriptFunction
implements IScriptFunction {
    private static final long serialVersionUID = 1L;
    private String name;
    private IScriptFunctionCategory category;
    private String dataType;
    private String desc;
    private IScriptFunctionExecutor executor;
    private IScriptFunctionArgument[] argument;
    private boolean allowVarArguments;
    private boolean isStatic;
    private boolean isConstructor;
    private boolean isVisible;

    public ScriptFunction(String name, IScriptFunctionCategory category, IScriptFunctionArgument[] argument, String dataType, String desc, IScriptFunctionExecutor executor, boolean allowVarArguments, boolean isStatic, boolean isConstructor) {
        this.name = name;
        this.category = category;
        this.argument = argument;
        this.dataType = dataType;
        this.desc = desc;
        this.executor = executor;
        this.allowVarArguments = allowVarArguments;
        this.isStatic = isStatic;
        this.isConstructor = isConstructor;
        this.isVisible = true;
    }

    public ScriptFunction(String name, IScriptFunctionCategory category, IScriptFunctionArgument[] argument, String dataType, String desc, IScriptFunctionExecutor executor, boolean allowVarArguments, boolean isStatic, boolean isConstructor, boolean isVisible) {
        this.name = name;
        this.category = category;
        this.argument = argument;
        this.dataType = dataType;
        this.desc = desc;
        this.executor = executor;
        this.allowVarArguments = allowVarArguments;
        this.isStatic = isStatic;
        this.isConstructor = isConstructor;
        this.isVisible = isVisible;
    }

    @Override
    public IScriptFunctionArgument[] getArguments() {
        return this.argument;
    }

    @Override
    public IScriptFunctionCategory getCategory() {
        return this.category;
    }

    @Override
    public String getDataTypeName() {
        return this.dataType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        if (this.executor != null) {
            return this.executor.execute(arguments, context);
        }
        return null;
    }

    @Override
    public boolean allowVarArguments() {
        return this.allowVarArguments;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }
}

