/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;

public class FieldType
implements IndexableFieldType {
    private boolean stored;
    private boolean tokenized = true;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean frozen;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private DocValuesSkipIndexType docValuesSkipIndex = DocValuesSkipIndexType.NONE;
    private int dimensionCount;
    private int indexDimensionCount;
    private int dimensionNumBytes;
    private int vectorDimension;
    private VectorEncoding vectorEncoding = VectorEncoding.FLOAT32;
    private VectorSimilarityFunction vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
    private Map<String, String> attributes;

    public FieldType(IndexableFieldType ref) {
        this.stored = ref.stored();
        this.tokenized = ref.tokenized();
        this.storeTermVectors = ref.storeTermVectors();
        this.storeTermVectorOffsets = ref.storeTermVectorOffsets();
        this.storeTermVectorPositions = ref.storeTermVectorPositions();
        this.storeTermVectorPayloads = ref.storeTermVectorPayloads();
        this.omitNorms = ref.omitNorms();
        this.indexOptions = ref.indexOptions();
        this.docValuesType = ref.docValuesType();
        this.docValuesSkipIndex = ref.docValuesSkipIndexType();
        this.dimensionCount = ref.pointDimensionCount();
        this.indexDimensionCount = ref.pointIndexDimensionCount();
        this.dimensionNumBytes = ref.pointNumBytes();
        this.vectorDimension = ref.vectorDimension();
        this.vectorEncoding = ref.vectorEncoding();
        this.vectorSimilarityFunction = ref.vectorSimilarityFunction();
        if (ref.getAttributes() != null) {
            this.attributes = new HashMap<String, String>(ref.getAttributes());
        }
    }

    public FieldType() {
    }

    protected void checkIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("this FieldType is already frozen and cannot be changed");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public void setStored(boolean value) {
        this.checkIfFrozen();
        this.stored = value;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public void setTokenized(boolean value) {
        this.checkIfFrozen();
        this.tokenized = value;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public void setStoreTermVectors(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectors = value;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    public void setStoreTermVectorOffsets(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorOffsets = value;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    public void setStoreTermVectorPositions(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPositions = value;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    public void setStoreTermVectorPayloads(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPayloads = value;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean value) {
        this.checkIfFrozen();
        this.omitNorms = value;
    }

    @Override
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions value) {
        this.checkIfFrozen();
        if (value == null) {
            throw new NullPointerException("IndexOptions must not be null");
        }
        this.indexOptions = value;
    }

    public void setDimensions(int dimensionCount, int dimensionNumBytes) {
        this.setDimensions(dimensionCount, dimensionCount, dimensionNumBytes);
    }

    public void setDimensions(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
        this.checkIfFrozen();
        if (dimensionCount < 0) {
            throw new IllegalArgumentException("dimensionCount must be >= 0; got " + dimensionCount);
        }
        if (dimensionCount > 16) {
            throw new IllegalArgumentException("dimensionCount must be <= 16; got " + dimensionCount);
        }
        if (indexDimensionCount < 0) {
            throw new IllegalArgumentException("indexDimensionCount must be >= 0; got " + indexDimensionCount);
        }
        if (indexDimensionCount > dimensionCount) {
            throw new IllegalArgumentException("indexDimensionCount must be <= dimensionCount: " + dimensionCount + "; got " + indexDimensionCount);
        }
        if (indexDimensionCount > 8) {
            throw new IllegalArgumentException("indexDimensionCount must be <= 8; got " + indexDimensionCount);
        }
        if (dimensionNumBytes < 0) {
            throw new IllegalArgumentException("dimensionNumBytes must be >= 0; got " + dimensionNumBytes);
        }
        if (dimensionNumBytes > 16) {
            throw new IllegalArgumentException("dimensionNumBytes must be <= 16; got " + dimensionNumBytes);
        }
        if (dimensionCount == 0) {
            if (indexDimensionCount != 0) {
                throw new IllegalArgumentException("when dimensionCount is 0, indexDimensionCount must be 0; got " + indexDimensionCount);
            }
            if (dimensionNumBytes != 0) {
                throw new IllegalArgumentException("when dimensionCount is 0, dimensionNumBytes must be 0; got " + dimensionNumBytes);
            }
        } else {
            if (indexDimensionCount == 0) {
                throw new IllegalArgumentException("when dimensionCount is > 0, indexDimensionCount must be > 0; got " + indexDimensionCount);
            }
            if (dimensionNumBytes == 0) {
                throw new IllegalArgumentException("when dimensionNumBytes is 0, dimensionCount must be 0; got " + dimensionCount);
            }
        }
        this.dimensionCount = dimensionCount;
        this.indexDimensionCount = indexDimensionCount;
        this.dimensionNumBytes = dimensionNumBytes;
    }

    @Override
    public int pointDimensionCount() {
        return this.dimensionCount;
    }

    @Override
    public int pointIndexDimensionCount() {
        return this.indexDimensionCount;
    }

    @Override
    public int pointNumBytes() {
        return this.dimensionNumBytes;
    }

    public void setVectorAttributes(int numDimensions, VectorEncoding encoding, VectorSimilarityFunction similarity) {
        this.checkIfFrozen();
        if (numDimensions <= 0) {
            throw new IllegalArgumentException("vector numDimensions must be > 0; got " + numDimensions);
        }
        this.vectorDimension = numDimensions;
        this.vectorSimilarityFunction = Objects.requireNonNull(similarity);
        this.vectorEncoding = Objects.requireNonNull(encoding);
    }

    @Override
    public int vectorDimension() {
        return this.vectorDimension;
    }

    @Override
    public VectorEncoding vectorEncoding() {
        return this.vectorEncoding;
    }

    @Override
    public VectorSimilarityFunction vectorSimilarityFunction() {
        return this.vectorSimilarityFunction;
    }

    public String putAttribute(String key, String value) {
        this.checkIfFrozen();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes.put(key, value);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.stored()) {
            result.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("indexed");
            if (this.tokenized()) {
                result.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                result.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                result.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                result.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                result.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                result.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                result.append(",indexOptions=");
                result.append((Object)this.indexOptions);
            }
        }
        if (this.dimensionCount != 0) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("pointDimensionCount=");
            result.append(this.dimensionCount);
            result.append(",pointIndexDimensionCount=");
            result.append(this.indexDimensionCount);
            result.append(",pointNumBytes=");
            result.append(this.dimensionNumBytes);
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("docValuesType=");
            result.append((Object)this.docValuesType);
        }
        return result.toString();
    }

    @Override
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public void setDocValuesType(DocValuesType type) {
        this.checkIfFrozen();
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null");
        }
        this.docValuesType = type;
    }

    @Override
    public DocValuesSkipIndexType docValuesSkipIndexType() {
        return this.docValuesSkipIndex;
    }

    public void setDocValuesSkipIndexType(DocValuesSkipIndexType docValuesSkipIndex) {
        this.checkIfFrozen();
        this.docValuesSkipIndex = docValuesSkipIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimensionCount;
        result = 31 * result + this.indexDimensionCount;
        result = 31 * result + this.dimensionNumBytes;
        result = 31 * result + (this.docValuesType == null ? 0 : this.docValuesType.hashCode());
        result = 31 * result + (this.docValuesSkipIndex == null ? 0 : this.docValuesSkipIndex.hashCode());
        result = 31 * result + this.indexOptions.hashCode();
        result = 31 * result + (this.omitNorms ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectorOffsets ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectorPayloads ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectorPositions ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectors ? 1231 : 1237);
        result = 31 * result + (this.stored ? 1231 : 1237);
        result = 31 * result + (this.tokenized ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other = (FieldType)obj;
        if (this.dimensionCount != other.dimensionCount) {
            return false;
        }
        if (this.indexDimensionCount != other.indexDimensionCount) {
            return false;
        }
        if (this.dimensionNumBytes != other.dimensionNumBytes) {
            return false;
        }
        if (this.docValuesType != other.docValuesType) {
            return false;
        }
        if (this.docValuesSkipIndex != other.docValuesSkipIndex) {
            return false;
        }
        if (this.indexOptions != other.indexOptions) {
            return false;
        }
        if (this.omitNorms != other.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != other.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != other.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != other.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != other.storeTermVectors) {
            return false;
        }
        if (this.stored != other.stored) {
            return false;
        }
        return this.tokenized == other.tokenized;
    }
}

