/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.BuildManagerAccess;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.ClosedProjectsQueue;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.builder.impl.XtextBuilder;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

@Singleton
public class ProjectOpenedOrClosedListener
implements IResourceChangeListener {
    private static final Logger log = Logger.getLogger(ProjectOpenedOrClosedListener.class);
    private static boolean reflectErrorLogged = false;
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    @Deprecated
    private BuildScheduler buildScheduler;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private ClosedProjectsQueue closedProjectsQueue;
    @Inject
    private IWorkspace workspace;
    private final RemoveProjectsJob removeProjectsJob = this.createRemoveProjectsJob();

    protected RemoveProjectsJob createRemoveProjectsJob() {
        return new RemoveProjectsJob();
    }

    public ClosedProjectsQueue getClosedProjectsQueue() {
        return this.closedProjectsQueue;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public QueuedBuildData getQueuedBuildData() {
        return this.queuedBuildData;
    }

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    public ToBeBuiltComputer getToBeBuiltComputer() {
        return this.toBeBuiltComputer;
    }

    public IBuilderState getBuilderState() {
        return this.builderState;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.workspace != null && this.workspace.isAutoBuilding()) {
            if (event.getType() == 1) {
                try {
                    Set<IProject> toUpdate = this.findNewProjectsToBuild(event);
                    this.scheduleBuildIfNecessary(toUpdate);
                }
                catch (CoreException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if ((event.getType() == 2 || event.getType() == 4) && event.getResource() instanceof IProject && (XtextProjectHelper.hasNature((IProject)((IProject)event.getResource())) || event.getResource().isAccessible() && event.getResource().isHidden())) {
                this.scheduleRemoveProjectJob((IProject)event.getResource());
            }
        }
    }

    private Set<IProject> findNewProjectsToBuild(IResourceChangeEvent event) throws CoreException {
        LinkedHashSet toUpdate = Sets.newLinkedHashSet();
        event.getDelta().accept(this.createVisitor(toUpdate));
        return toUpdate;
    }

    @Deprecated
    private void scheduleBuildIfNecessary(Set<IProject> toUpdate) {
        if (!toUpdate.isEmpty()) {
            this.buildScheduler.scheduleBuildIfNecessary(toUpdate, IBuildFlag.FORGET_BUILD_STATE_ONLY);
        }
    }

    private IResourceDeltaVisitor createVisitor(final Set<IProject> accumutor) {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                return ProjectOpenedOrClosedListener.this.visitResourceDelta(delta, accumutor);
            }
        };
    }

    protected boolean visitResourceDelta(IResourceDelta delta, Set<IProject> accumulator) {
        if (delta.getResource() instanceof IWorkspaceRoot) {
            return true;
        }
        if (delta.getResource() instanceof IProject) {
            IProject project = (IProject)delta.getResource();
            if ((delta.getKind() & 4) != 0 && project.isOpen()) {
                if ((delta.getFlags() & 0x4000) != 0) {
                    accumulator.add(project);
                }
                if ((delta.getFlags() & 0x80000) != 0) {
                    if (delta.findMember((IPath)new Path(".project")) != null && XtextProjectHelper.hasNature((IProject)project) && XtextProjectHelper.hasBuilder((IProject)project)) {
                        accumulator.add(project);
                    } else if (!XtextProjectHelper.hasNature((IProject)project)) {
                        this.scheduleRemoveProjectJobIfNecessary(project, delta);
                    }
                }
            }
        }
        return false;
    }

    protected void scheduleRemoveProjectJob(IProject project) {
        try {
            ToBeBuilt toBeBuilt = this.getToBeBuiltComputer().removeProject(project, (IProgressMonitor)new NullProgressMonitor());
            if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
                return;
            }
            this.scheduleJob(project.getName(), toBeBuilt);
        }
        finally {
            XtextBuilder builder = BuildManagerAccess.findBuilder(project);
            if (builder != null) {
                builder.forgetLastBuiltState();
            }
        }
    }

    protected void scheduleRemoveProjectJobIfNecessary(IProject project, IResourceDelta delta) {
        try {
            ReflectExtensions reflector = new ReflectExtensions();
            Object oldInfo = reflector.get((Object)delta, "oldInfo");
            Map natures = (Map)reflector.get(oldInfo, "natures");
            if (natures != null && natures.containsKey("org.eclipse.xtext.ui.shared.xtextNature")) {
                this.scheduleRemoveProjectJob(project);
            }
        }
        catch (Exception e) {
            if (!reflectErrorLogged) {
                log.error((Object)"Scheduled unnecessary build due to reflective code failure", (Throwable)e);
                reflectErrorLogged = true;
            }
            this.scheduleRemoveProjectJob(project);
        }
    }

    protected void scheduleJob(String name, ToBeBuilt toBeBuilt) {
        this.closedProjectsQueue.enqueue((Set<String>)ImmutableSet.of((Object)name), toBeBuilt);
        this.removeProjectsJob.setName(Messages.ProjectOpenedOrClosedListener_RemovingProject + name + Messages.ProjectOpenedOrClosedListener_FromIndex);
        this.removeProjectsJob.schedule();
    }

    protected void processClosedProjects(IProgressMonitor monitor) {
        ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
        if (task.isEmpty()) {
            return;
        }
        ImmutableSet<String> removedProjects = task.getProjectNames();
        String projectNames = Joiner.on((String)", ").join(removedProjects);
        String taskName = Messages.ProjectOpenedOrClosedListener_RemovingProject + projectNames + Messages.ProjectOpenedOrClosedListener_FromIndex;
        monitor.setTaskName(taskName);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            try {
                ResourceSet resourceSet = this.createResourceSet();
                BuildData buildData = new BuildData("", resourceSet, task.getToBeBuilt(), this.queuedBuildData, false, BuildManagerAccess::requestBuild, (Set<String>)removedProjects);
                this.getBuilderState().update(buildData, (IProgressMonitor)progress.newChild(1));
            }
            catch (Error | RuntimeException e) {
                task.reschedule();
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    private ResourceSet createResourceSet() {
        ResourceSet resourceSet = this.getResourceSetProvider().get(null);
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        if (resourceSet instanceof ResourceSetImpl) {
            ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
        }
        return resourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void joinRemoveProjectJob() {
        try {
            ProjectOpenedOrClosedListener projectOpenedOrClosedListener = this;
            synchronized (projectOpenedOrClosedListener) {
                this.wait(1L);
            }
            this.removeProjectsJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected class RemoveProjectsJob
    extends WorkspaceJob {
        public RemoveProjectsJob() {
            super(Messages.ProjectOpenedOrClosedListener_RemovingProject.trim() + Messages.ProjectOpenedOrClosedListener_FromIndex);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ProjectOpenedOrClosedListener.this.processClosedProjects(monitor);
            return Status.OK_STATUS;
        }
    }
}

