/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationManager;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetProxy
implements IWorkingSetProxy {
    private String name;
    private Map<String, IWorkingSetConfiguration> configurations;

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public IWorkingSet resolve() {
        return WorkingSetConfigurationManager.WS_MGR.getWorkingSet(this.name);
    }

    @Override
    public Collection<IProject> resolveProjects() {
        HashSet<IProject> result = new HashSet<IProject>();
        IWorkingSet resolvedWS = this.resolve();
        if (resolvedWS != null) {
            IAdaptable[] iAdaptableArray = resolvedWS.getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable next = iAdaptableArray[n2];
                IProject proj = (IProject)next.getAdapter(IProject.class);
                if (proj != null) {
                    result.add(proj);
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return !this.resolveProjects().isEmpty();
    }

    private Map<String, IWorkingSetConfiguration> getConfigurationsMap() {
        if (this.configurations == null) {
            this.configurations = new HashMap<String, IWorkingSetConfiguration>();
        }
        return this.configurations;
    }

    @Override
    public IWorkingSetConfiguration getConfiguration(String name) {
        return this.getConfigurationsMap().get(name);
    }

    @Override
    public Collection<IWorkingSetConfiguration> getConfigurations() {
        return this.getConfigurationsMap().values();
    }

    public void saveState(IMemento memento) {
        memento.putString("name", this.getName());
        for (IWorkingSetConfiguration next : this.getConfigurations()) {
            if (this.isTransient(next)) continue;
            next.saveState(memento.createChild("config"));
        }
    }

    protected boolean isTransient(IWorkingSetConfiguration config) {
        return false;
    }

    @Override
    public void loadState(IMemento memento) {
        this.setName(memento.getString("name"));
        IMemento[] iMementoArray = memento.getChildren("config");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento next = iMementoArray[n2];
            IWorkingSetConfiguration config = this.createWorkingSetConfiguration();
            config.loadState(next);
            this.getConfigurationsMap().put(config.getName(), config);
            ++n2;
        }
    }

    protected IWorkingSetConfiguration createWorkingSetConfiguration() {
        return new WorkingSetConfiguration(this);
    }

    protected void basicRemoveConfiguration(IWorkingSetConfiguration config) {
        this.getConfigurationsMap().remove(config.getName());
    }

    protected void basicAddConfiguration(IWorkingSetConfiguration config) {
        this.getConfigurationsMap().put(config.getName(), config);
    }

    @Override
    public IWorkingSetProxy.ISnapshot createSnapshot(WorkspaceSnapshot workspace) {
        Snapshot result = new Snapshot(this, workspace);
        result.updateActiveConfigurations();
        return result;
    }

    public static class Snapshot
    extends WorkingSetProxy
    implements IWorkingSetProxy.ISnapshot {
        private final WorkspaceSnapshot workspace;
        private IWorkingSetConfiguration.ISnapshot readOnlyConfig;

        protected Snapshot(IWorkingSetProxy workingSet, WorkspaceSnapshot workspace) {
            this.workspace = workspace;
            this.setName(workingSet.getName());
            for (IWorkingSetConfiguration next : workingSet.getConfigurations()) {
                this.basicAddConfiguration(next.createSnapshot(this, workspace));
            }
        }

        @Override
        public final WorkspaceSnapshot getWorkspaceSnapshot() {
            return this.workspace;
        }

        @Override
        public IWorkingSetConfiguration.ISnapshot createConfiguration(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("name is empty");
            }
            if (this.getConfiguration(name) != null) {
                throw new IllegalArgumentException("name is already in use");
            }
            IWorkingSetConfiguration.ISnapshot result = this.createWorkingSetConfiguration();
            result.setName(name);
            this.heuristicSelectProjectConfigurations(result);
            this.basicAddConfiguration(result);
            this.updateActiveConfigurations();
            return result;
        }

        protected void heuristicSelectProjectConfigurations(IWorkingSetConfiguration.ISnapshot newConfig) {
            String nameToSearch = this.getSearchKey(newConfig.getName());
            block0: for (IWorkingSetProjectConfiguration next : newConfig.getProjectConfigurations()) {
                IWorkingSetProjectConfiguration.ISnapshot project = (IWorkingSetProjectConfiguration.ISnapshot)next;
                for (ICConfigurationDescription config : project.resolveConfigurations()) {
                    if (!nameToSearch.equalsIgnoreCase(this.getSearchKey(config.getName()))) continue;
                    project.setSelectedConfigurationID(config.getId());
                    continue block0;
                }
            }
        }

        private String getSearchKey(String configurationName) {
            StringBuilder result = new StringBuilder(configurationName.length());
            configurationName.codePoints().filter(Character::isLetterOrDigit).forEach(result::appendCodePoint);
            return result.toString();
        }

        @Override
        protected IWorkingSetConfiguration.ISnapshot createWorkingSetConfiguration() {
            return new WorkingSetConfiguration.Snapshot(this, this.workspace);
        }

        @Override
        public void removeConfiguration(IWorkingSetConfiguration config) {
            if (WorkingSetConfiguration.isReadOnly(config)) {
                throw new IllegalArgumentException("config is read-only");
            }
            this.basicRemoveConfiguration(config);
        }

        @Override
        public boolean updateActiveConfigurations() {
            boolean result = this.getConfigurations().isEmpty();
            boolean hasActiveConfig = false;
            for (IWorkingSetConfiguration next : this.getConfigurations()) {
                if (!next.isActive() || WorkingSetConfiguration.isReadOnly(next)) continue;
                hasActiveConfig = true;
                break;
            }
            if (hasActiveConfig) {
                if (this.readOnlyConfig != null) {
                    this.basicRemoveConfiguration(this.readOnlyConfig);
                    result = true;
                }
                this.readOnlyConfig = null;
            } else {
                WorkingSetConfiguration.Snapshot ro = new WorkingSetConfiguration.Snapshot((IWorkingSetProxy)this, this.workspace, true);
                ro.basicSetName("");
                this.readOnlyConfig = ro;
                this.basicAddConfiguration(this.readOnlyConfig);
                result = true;
            }
            return result;
        }

        @Override
        protected boolean isTransient(IWorkingSetConfiguration config) {
            return WorkingSetConfiguration.isReadOnly(config);
        }
    }
}

