/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tips.core.IHtmlTip;
import org.eclipse.tips.core.IUrlTip;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipAction;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.TipManager;
import org.eclipse.tips.ui.IBrowserFunctionProvider;
import org.eclipse.tips.ui.ISwtTip;
import org.eclipse.tips.ui.internal.DefaultTipManager;
import org.eclipse.tips.ui.internal.Messages;
import org.eclipse.tips.ui.internal.ProviderSelectionListener;
import org.eclipse.tips.ui.internal.Slider;
import org.eclipse.tips.ui.internal.util.ImageUtil;

public class TipComposite
extends Composite
implements ProviderSelectionListener {
    private static final String EMPTY = "";
    private static final int READ_TIMER = 2000;
    private TipProvider fProvider;
    private final Browser fBrowser;
    private Slider fSlider;
    private TipManager fTipManager;
    private Tip fCurrentTip;
    private final Button fUnreadOnly;
    private Button fPreviousTipButton;
    private final Composite fSWTComposite;
    private final Composite fBrowserComposite;
    private final StackLayout fContentStack;
    private final Button fMultiActionMenuButton;
    private final Composite fNavigationBar;
    private final StackLayout fActionStack;
    private final Composite fEmptyActionComposite;
    private final Composite fSingleActionComposite;
    private final Composite fMultiActionComposite;
    private final Button fSingleActionButton;
    private final Button fMultiActionButton;
    private final Composite fContentComposite;
    private final List<Image> fActionImages = new ArrayList<Image>();
    private final List<BrowserFunction> fBrowserFunctions = new ArrayList<BrowserFunction>();
    private Menu fActionMenu;
    private final ToolBar ftoolBar;
    private final ToolItem fStartupItem;
    private final Button fNextTipButton;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);

    public TipComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout_1 = new GridLayout(1, false);
        gridLayout_1.marginWidth = 2;
        gridLayout_1.marginHeight = 2;
        this.setLayout((Layout)gridLayout_1);
        this.fContentComposite = new Composite((Composite)this, 0);
        this.fContentStack = new StackLayout();
        this.fContentComposite.setLayout((Layout)this.fContentStack);
        GridData gd_gridComposite = new GridData(4, 4, true, true, 1, 1);
        gd_gridComposite.widthHint = 600;
        gd_gridComposite.heightHint = 400;
        this.fContentComposite.setLayoutData((Object)gd_gridComposite);
        this.fBrowserComposite = new Composite(this.fContentComposite, 0);
        this.fBrowserComposite.setLayout((Layout)new FillLayout(256));
        this.fBrowser = new Browser(this.fBrowserComposite, 0);
        this.fBrowser.setJavascriptEnabled(true);
        this.fSWTComposite = new Composite(this.fContentComposite, 0);
        this.fSWTComposite.setLayout((Layout)new FillLayout(256));
        this.fNavigationBar = new Composite((Composite)this, 0);
        this.fNavigationBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_NavigationBar = new GridLayout(2, false);
        gl_NavigationBar.horizontalSpacing = 0;
        gl_NavigationBar.marginHeight = 0;
        gl_NavigationBar.verticalSpacing = 0;
        gl_NavigationBar.marginWidth = 0;
        this.fNavigationBar.setLayout((Layout)gl_NavigationBar);
        Composite preferenceBar = new Composite(this.fNavigationBar, 0);
        FillLayout fl_composite_3 = new FillLayout(256);
        fl_composite_3.marginWidth = 5;
        fl_composite_3.spacing = 5;
        preferenceBar.setLayout((Layout)fl_composite_3);
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        menu.addListener(22, event -> this.startupMenuAboutToShow(menu));
        this.ftoolBar = new ToolBar(preferenceBar, 0x820000);
        this.fStartupItem = new ToolItem(this.ftoolBar, 4);
        this.fStartupItem.setText(Messages.TipComposite_13);
        this.fStartupItem.addListener(13, event -> this.showStartupOptions(menu));
        this.fUnreadOnly = new Button(preferenceBar, 32);
        this.fUnreadOnly.setText(Messages.TipComposite_2);
        this.fUnreadOnly.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTipManager.setServeReadTips(!this.fUnreadOnly.getSelection());
            this.fPreviousTipButton.setEnabled(this.fTipManager.mustServeReadTips());
            this.fSlider.load();
            this.getNextTip();
        }));
        Composite buttonBar = new Composite(this.fNavigationBar, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        GridLayout gl_buttonBar = new GridLayout(4, true);
        gl_buttonBar.marginHeight = 0;
        buttonBar.setLayout((Layout)gl_buttonBar);
        Composite actionComposite = new Composite(buttonBar, 0);
        this.fActionStack = new StackLayout();
        actionComposite.setLayout((Layout)this.fActionStack);
        actionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fSingleActionComposite = new Composite(actionComposite, 0);
        GridLayout gl_SingleActionComposite = new GridLayout(1, false);
        gl_SingleActionComposite.marginWidth = 0;
        this.fSingleActionComposite.setLayout((Layout)gl_SingleActionComposite);
        this.fSingleActionButton = new Button(this.fSingleActionComposite, 0);
        this.fSingleActionButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fSingleActionButton.setText(Messages.TipComposite_3);
        this.fSingleActionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.runTipAction((TipAction)this.fCurrentTip.getActions().get(0))));
        this.fMultiActionComposite = new Composite(actionComposite, 0);
        GridLayout gl_MultiActionComposite = new GridLayout(2, false);
        gl_MultiActionComposite.marginWidth = 0;
        gl_MultiActionComposite.verticalSpacing = 0;
        gl_MultiActionComposite.horizontalSpacing = 0;
        this.fMultiActionComposite.setLayout((Layout)gl_MultiActionComposite);
        this.fMultiActionButton = new Button(this.fMultiActionComposite, 0);
        this.fMultiActionButton.setText(Messages.TipComposite_4);
        this.fMultiActionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.runTipAction((TipAction)this.fCurrentTip.getActions().get(0))));
        this.fMultiActionMenuButton = new Button(this.fMultiActionComposite, 0);
        this.fMultiActionMenuButton.setImage(DefaultTipManager.getImage("icons/popup_menu.svg", this.resourceManager));
        this.fMultiActionMenuButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showActionMenu()));
        this.fEmptyActionComposite = new Composite(actionComposite, 0);
        this.fEmptyActionComposite.setLayout((Layout)new FillLayout(256));
        this.fPreviousTipButton = new Button(buttonBar, 0);
        this.fPreviousTipButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fPreviousTipButton.setText(Messages.TipComposite_7);
        this.fPreviousTipButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getPreviousTip()));
        this.fPreviousTipButton.setEnabled(false);
        this.fNextTipButton = new Button(buttonBar, 0);
        this.fNextTipButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fNextTipButton.setText(Messages.TipComposite_8);
        this.fNextTipButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getNextTip()));
        this.fNextTipButton.setEnabled(false);
        Button btnClose = new Button(buttonBar, 0);
        btnClose.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getParent().dispose()));
        btnClose.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnClose.setText(Messages.TipComposite_9);
        Label label_1 = new Label((Composite)this, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fSlider = new Slider(this, 0);
        GridLayout gridLayout = (GridLayout)this.fSlider.getLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.fSlider.setLayoutData(new GridData(4, 1024, false, false, 1, 1));
        this.fContentStack.topControl = this.fBrowserComposite;
        this.fSlider.addTipProviderListener(this);
        this.loadWaitingScript();
    }

    private void showStartupOptions(Menu menu) {
        Rectangle rect = this.fStartupItem.getBounds();
        Point pt = new Point(rect.x, rect.y + rect.height);
        pt = this.ftoolBar.toDisplay(pt);
        menu.setLocation(pt.x, pt.y);
        menu.setVisible(true);
    }

    private Image getStartupItemImage(int startup) {
        switch (startup) {
            case 1: {
                return DefaultTipManager.getImage("icons/lightbulb.svg", this.resourceManager);
            }
            case 2: {
                return DefaultTipManager.getImage("icons/stop.svg", this.resourceManager);
            }
        }
        return DefaultTipManager.getImage("icons/run_exc.svg", this.resourceManager);
    }

    private void startupMenuAboutToShow(Menu menu) {
        Arrays.asList(menu.getItems()).forEach(Widget::dispose);
        MenuItem item0 = new MenuItem(menu, 32);
        item0.setText(Messages.TipComposite_1);
        item0.setSelection(this.fTipManager.getStartupBehavior() == 0);
        item0.addListener(13, event -> {
            TipManager tipManager = this.fTipManager.setStartupBehavior(0);
        });
        item0.setImage(this.getStartupItemImage(0));
        MenuItem item1 = new MenuItem(menu, 32);
        item1.setText(Messages.TipComposite_5);
        item1.setSelection(this.fTipManager.getStartupBehavior() == 1);
        item1.addListener(13, event -> {
            TipManager tipManager = this.fTipManager.setStartupBehavior(1);
        });
        item1.setImage(this.getStartupItemImage(1));
        MenuItem item2 = new MenuItem(menu, 32);
        item2.setText(Messages.TipComposite_6);
        item2.setSelection(this.fTipManager.getStartupBehavior() == 2);
        item2.addListener(13, event -> {
            TipManager tipManager = this.fTipManager.setStartupBehavior(2);
        });
        item2.setImage(this.getStartupItemImage(2));
    }

    private void showActionMenu() {
        Rectangle rect = this.fMultiActionButton.getBounds();
        Point pt = new Point(rect.x - 1, rect.y + rect.height);
        pt = this.fMultiActionButton.toDisplay(pt);
        this.fActionMenu.setLocation(pt.x, pt.y);
        this.fActionMenu.setVisible(true);
    }

    private void runTipAction(TipAction tipAction) {
        Job job = Job.create((String)MessageFormat.format(Messages.TipComposite_10, tipAction.getTooltip()), monitor -> {
            try {
                tipAction.getRunner().run();
            }
            catch (Exception e) {
                IStatus status = LogUtil.error(this.getClass(), (Throwable)e);
                this.fTipManager.log(status);
                return status;
            }
            return Status.OK_STATUS;
        });
        job.setUser(true);
        job.schedule();
    }

    public void setProvider(TipProvider provider) {
        if (provider == null) {
            return;
        }
        this.fNextTipButton.setEnabled(true);
        this.fProvider = provider;
        this.fSlider.setTipProvider(provider);
        this.getCurrentTip();
    }

    private void hitTimer() {
        final Tip timerTip = this.fCurrentTip;
        final Timer timer = new Timer(Messages.TipComposite_11);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (timerTip == TipComposite.this.fCurrentTip) {
                    TipComposite.this.fTipManager.setAsRead(timerTip);
                    TipComposite.this.fSlider.updateButtons();
                }
                timer.cancel();
            }
        }, 2000L);
    }

    private void getPreviousTip() {
        this.processTip(this.fProvider.getPreviousTip());
    }

    private void getNextTip() {
        if (this.fProvider.getTips().isEmpty() && !this.fTipManager.getProviders().isEmpty()) {
            this.fProvider.getNextTip();
            for (TipProvider provider : this.fTipManager.getProviders()) {
                if (provider.getTips().isEmpty()) continue;
                this.setProvider(provider);
                break;
            }
        }
        this.processTip(this.fProvider.getNextTip());
    }

    private void getCurrentTip() {
        this.processTip(this.fProvider.getCurrentTip());
    }

    private void processTip(Tip tip) {
        this.fCurrentTip = tip;
        this.hitTimer();
        this.enableActionButtons(tip);
        this.prepareForHTML();
        this.loadContent(tip);
    }

    private void loadContent(Tip tip) {
        this.disposeBrowserFunctions();
        if (tip instanceof ISwtTip) {
            this.loadContentSWT(tip);
        } else if (tip instanceof IHtmlTip) {
            this.loadContentHtml((IHtmlTip)tip);
            this.applyBrowserFunctions(tip);
        } else if (tip instanceof IUrlTip) {
            this.loadContentUrl((IUrlTip)tip);
            this.applyBrowserFunctions(tip);
        } else {
            this.fTipManager.log(LogUtil.error(this.getClass(), (String)(Messages.TipComposite_12 + String.valueOf(tip))));
        }
        this.fContentComposite.requestLayout();
    }

    private void applyBrowserFunctions(Tip tip) {
        if (tip instanceof IBrowserFunctionProvider) {
            ((IBrowserFunctionProvider)tip).getBrowserFunctions().forEach((name, function) -> {
                boolean bl = this.fBrowserFunctions.add(this.createBrowserFunction((String)name, (Function<Object[], Object>)function));
            });
        }
    }

    private BrowserFunction createBrowserFunction(String functionName, final Function<Object[], Object> function) {
        return new BrowserFunction(this.getBrowser(), functionName){

            public Object function(Object[] arguments) {
                return function.apply(arguments);
            }
        };
    }

    private void loadContentHtml(IHtmlTip tip) {
        this.fBrowser.setText(this.getHTML(tip).trim());
    }

    private void loadContentUrl(IUrlTip tip) {
        try {
            String url = FileLocator.resolve((URL)new URL(tip.getURL())).toString();
            this.fBrowser.setUrl(url);
        }
        catch (IOException e) {
            this.fTipManager.log(LogUtil.error(this.getClass(), (Throwable)e));
        }
    }

    private void loadContentSWT(Tip tip) {
        Control[] controlArray = this.fSWTComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.fContentStack.topControl = this.fSWTComposite;
        ((ISwtTip)tip).createControl(this.fSWTComposite);
        this.fSWTComposite.requestLayout();
    }

    private void prepareForHTML() {
        this.fContentStack.topControl = this.fBrowserComposite;
        this.loadTimeOutScript();
        this.fBrowserComposite.requestLayout();
    }

    private void disposeBrowserFunctions() {
        this.fBrowserFunctions.forEach(BrowserFunction::dispose);
        this.fBrowserFunctions.clear();
    }

    private void loadTimeOutScript() {
        this.fBrowser.setText(TipComposite.getLoadingScript(500));
    }

    private void loadWaitingScript() {
        this.fBrowser.setText(TipComposite.getWaitingScript(1500));
    }

    private static String getWaitingScript(int timeout) {
        return "<style>div{height: 90vh;display: flex;justify-content: center;align-items: center;}</style><div id=\"txt\"></div><script>var wss=function(){document.getElementById(\"txt\").innerHTML=\"" + Messages.TipComposite_14 + "\"};window.setTimeout(wss," + timeout + ");</script>";
    }

    private void enableActionButtons(Tip tip) {
        this.disposeActionImages();
        List actions = tip.getActions();
        if (actions.isEmpty()) {
            this.fActionStack.topControl = this.fEmptyActionComposite;
        } else if (actions.size() == 1) {
            TipAction action = (TipAction)actions.get(0);
            this.fActionStack.topControl = this.fSingleActionComposite;
            this.fSingleActionButton.setImage(this.getActionImage(action.getTipImage()));
            this.fSingleActionButton.setText(action.getText());
            this.fSingleActionButton.setToolTipText(action.getTooltip());
        } else {
            TipAction action = (TipAction)actions.get(0);
            this.fActionStack.topControl = this.fMultiActionComposite;
            this.fMultiActionButton.setImage(this.getActionImage(((TipAction)actions.get(0)).getTipImage()));
            this.fMultiActionButton.setText(action.getText());
            this.fMultiActionButton.setToolTipText(action.getTooltip());
            this.loadActionMenu(tip);
        }
        this.fEmptyActionComposite.getParent().requestLayout();
        this.fNavigationBar.requestLayout();
    }

    private void disposeActionImages() {
        this.fActionImages.forEach(Resource::dispose);
    }

    private void loadActionMenu(Tip pTip) {
        if (this.fActionMenu != null) {
            this.fActionMenu.dispose();
        }
        this.fActionMenu = new Menu((Decorations)this.fContentComposite.getShell(), 8);
        List actions = pTip.getActions();
        actions.subList(1, actions.size()).forEach(action -> {
            MenuItem item = new MenuItem(this.fActionMenu, 8);
            item.setText(action.getText());
            item.setToolTipText(action.getTooltip());
            item.setText(action.getText());
            item.setImage(this.getActionImage(action.getTipImage()));
            item.addListener(13, e -> this.runTipAction((TipAction)action));
        });
    }

    private Image getActionImage(TipImage tipImage) {
        if (tipImage == null) {
            return null;
        }
        try {
            Image image = new Image((Device)this.getDisplay(), ImageUtil.decodeToImage(tipImage.getBase64Image()));
            this.fActionImages.add(image);
            return image;
        }
        catch (IOException e) {
            this.fTipManager.log(LogUtil.error(this.getClass(), (Throwable)e));
            return null;
        }
    }

    private static String getLoadingScript(int timeout) {
        return "<style>div{position:fixed;top:50%;left:40%}</style><div id=\"txt\"></div><script>var wss=function(){document.getElementById(\"txt\").innerHTML=\"" + Messages.TipComposite_0 + "\"};window.setTimeout(wss," + timeout + ");</script>";
    }

    private String getHTML(IHtmlTip tip) {
        String encodedImage = this.encodeImage(tip);
        return tip.getHTML() + encodedImage;
    }

    private String encodeImage(IHtmlTip tip) {
        TipImage image = tip.getImage();
        if (image == null) {
            return EMPTY;
        }
        return this.encodeImageFromBase64(image);
    }

    private String encodeImageFromBase64(TipImage image) {
        int width = this.fBrowser.getClientArea().width;
        int height = Math.min(this.fBrowser.getClientArea().height / 2, 2 * (width / 3));
        String attributes = image.getIMGAttributes(width, height).trim();
        return "<center> <img " + attributes + " src=\"" + image.getBase64Image() + "\"></center><br/>";
    }

    protected void checkSubclass() {
    }

    public Browser getBrowser() {
        return this.fBrowser;
    }

    public Slider getSlider() {
        return this.fSlider;
    }

    @Override
    public void selected(TipProvider provider) {
        this.setProvider(provider);
    }

    public void setTipManager(TipManager tipManager) {
        this.fTipManager = tipManager;
        this.getDisplay().syncExec(() -> {
            this.fSlider.setTipManager(this.fTipManager);
            this.fUnreadOnly.setSelection(!this.fTipManager.mustServeReadTips());
            this.fPreviousTipButton.setEnabled(this.fTipManager.mustServeReadTips());
        });
    }

    public void dispose() {
        this.disposeActionImages();
        super.dispose();
    }
}

