/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;

public class DefaultCommentMapper {
    Comment[] comments;
    AstLexer scanner;
    int leadingPtr;
    ASTNode[] leadingNodes;
    long[] leadingIndexes;
    int trailingPtr;
    int lastTrailingPtr;
    ASTNode[] trailingNodes;
    long[] trailingIndexes;
    private IDocument document;
    static final int STORAGE_INCREMENT = 16;

    DefaultCommentMapper(Comment[] table) {
        this.comments = table;
    }

    boolean hasSameTable(Comment[] table) {
        return this.comments == table;
    }

    Comment getComment(int position) {
        if (this.comments == null) {
            return null;
        }
        int size = this.comments.length;
        if (size == 0) {
            return null;
        }
        int index = this.getCommentIndex(0, position, 0);
        if (index < 0) {
            return null;
        }
        return this.comments[index];
    }

    private int getCommentIndex(int start, int position, int exact) {
        if (position == 0) {
            if (this.comments.length > 0 && this.comments[0].getStart() == 0) {
                return 0;
            }
            return -1;
        }
        int bottom = start;
        int top = this.comments.length - 1;
        int i = 0;
        int index = -1;
        Comment comment = null;
        while (bottom <= top) {
            i = bottom + (top - bottom) / 2;
            comment = this.comments[i];
            int commentStart = comment.getStart();
            if (position < commentStart) {
                top = i - 1;
                continue;
            }
            if (position >= commentStart + comment.getLength()) {
                bottom = i + 1;
                continue;
            }
            index = i;
            break;
        }
        if (index < 0 && exact != 0) {
            comment = this.comments[i];
            if (position < comment.getStart()) {
                return exact < 0 ? i - 1 : i;
            }
            return exact < 0 ? i : i + 1;
        }
        return index;
    }

    public int getExtendedStartPosition(ASTNode node) {
        if (this.leadingPtr >= 0) {
            long range = -1L;
            int i = 0;
            while (range < 0L && i <= this.leadingPtr) {
                if (this.leadingNodes[i] == node) {
                    range = this.leadingIndexes[i];
                }
                ++i;
            }
            if (range >= 0L) {
                return this.comments[(int)(range >> 32)].getStart();
            }
        }
        return node.getStart();
    }

    public final int getLineNumber(int position, int[] lineRange) {
        try {
            return this.document.getLineOfOffset(position);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException("getLineNumber() in DefaultCommentMapper with " + position);
        }
    }

    public int getExtendedEnd(ASTNode node) {
        int end = node.getEnd();
        if (this.trailingPtr >= 0) {
            long range = -1L;
            int i = 0;
            while (range < 0L && i <= this.trailingPtr) {
                if (this.trailingNodes[i] == node) {
                    range = this.trailingIndexes[i];
                }
                ++i;
            }
            if (range >= 0L) {
                Comment lastComment = this.comments[(int)range];
                end = lastComment.getEnd();
            }
        }
        return end - 1;
    }

    public int getExtendedLength(ASTNode node) {
        return this.getExtendedEnd(node) - this.getExtendedStartPosition(node) + 1;
    }

    int firstLeadingCommentIndex(ASTNode node) {
        if (this.leadingPtr >= 0) {
            int i = 0;
            while (i <= this.leadingPtr) {
                if (this.leadingNodes[i] == node) {
                    return (int)(this.leadingIndexes[i] >> 32);
                }
                ++i;
            }
        }
        return -1;
    }

    int lastTrailingCommentIndex(ASTNode node) {
        if (this.trailingPtr >= 0) {
            int i = 0;
            while (i <= this.trailingPtr) {
                if (this.trailingNodes[i] == node) {
                    return (int)this.trailingIndexes[i];
                }
                ++i;
            }
        }
        return -1;
    }

    void initialize(Program unit, IDocument document, Reader reader, AstLexer sc) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.leadingPtr = -1;
        this.trailingPtr = -1;
        List<Comment> commentsCollection = unit.comments();
        if (this.comments == null) {
            return;
        }
        this.comments = commentsCollection.toArray(new Comment[commentsCollection.size()]);
        int size = this.comments.length;
        if (size == 0) {
            return;
        }
        this.scanner = sc;
        this.scanner.yyreset(reader);
        this.scanner.resetCommentList();
        CommentMapperVisitor commentVisitor = new CommentMapperVisitor();
        unit.accept(commentVisitor);
        int leadingCount = this.leadingPtr + 1;
        if (leadingCount > 0 && leadingCount < this.leadingIndexes.length) {
            this.leadingNodes = new ASTNode[leadingCount];
            System.arraycopy(this.leadingNodes, 0, this.leadingNodes, 0, leadingCount);
            this.leadingIndexes = new long[leadingCount];
            System.arraycopy(this.leadingIndexes, 0, this.leadingIndexes, 0, leadingCount);
        }
        if (this.trailingPtr >= 0) {
            while (this.trailingIndexes[this.trailingPtr] == -1L) {
                --this.trailingPtr;
                if (this.trailingPtr >= 0) continue;
                this.trailingIndexes = null;
                this.trailingNodes = null;
                break;
            }
            int trailingCount = this.trailingPtr + 1;
            if (trailingCount > 0 && trailingCount < this.trailingIndexes.length) {
                this.trailingNodes = new ASTNode[trailingCount];
                System.arraycopy(this.trailingNodes, 0, this.trailingNodes, 0, trailingCount);
                this.trailingIndexes = new long[trailingCount];
                System.arraycopy(this.trailingIndexes, 0, this.trailingIndexes, 0, trailingCount);
            }
        }
        this.scanner = null;
    }

    int storeLeadingComments(ASTNode node, int previousEnd, int[] parentLineRange) {
        int nodeStart;
        int extended = nodeStart = node.getStart();
        int previousEndLine = this.getLineNumber(previousEnd, parentLineRange);
        int nodeStartLine = this.getLineNumber(nodeStart, parentLineRange);
        int idx = this.getCommentIndex(0, nodeStart, -1);
        if (idx == -1) {
            return nodeStart;
        }
        int startIdx = -1;
        int endIdx = idx;
        int previousStart = nodeStart;
        while (idx >= 0 && previousStart >= previousEnd) {
            Comment comment = this.comments[idx];
            int commentStart = comment.getStart();
            int end = commentStart + comment.getLength() - 1;
            int commentLine = this.getLineNumber(commentStart, parentLineRange);
            if (end <= previousEnd || commentLine == previousEndLine && commentLine != nodeStartLine) break;
            if (end + 1 < previousStart) {
                try {
                    this.resetTo(end + 1, previousStart);
                    this.scanner.next_token();
                    String token = this.scanner.yytext();
                    if (token != null && StringUtils.isNotBlank((CharSequence)token)) {
                        if (idx != endIdx) break;
                        return nodeStart;
                    }
                }
                catch (Exception exception) {
                    assert (false);
                    return nodeStart;
                }
            }
            previousStart = commentStart;
            startIdx = idx--;
        }
        if (startIdx != -1 && startIdx <= endIdx) {
            if (++this.leadingPtr == 0) {
                this.leadingNodes = new ASTNode[16];
                this.leadingIndexes = new long[16];
            } else if (this.leadingPtr == this.leadingNodes.length) {
                int newLength = this.leadingPtr * 3 / 2 + 16;
                this.leadingNodes = new ASTNode[newLength];
                System.arraycopy(this.leadingNodes, 0, this.leadingNodes, 0, this.leadingPtr);
                this.leadingIndexes = new long[newLength];
                System.arraycopy(this.leadingIndexes, 0, this.leadingIndexes, 0, this.leadingPtr);
            }
            this.leadingNodes[this.leadingPtr] = node;
            this.leadingIndexes[this.leadingPtr] = ((long)startIdx << 32) + (long)endIdx;
            extended = this.comments[endIdx].getStart();
        }
        return extended;
    }

    private void resetTo(int begin, int end) throws IOException {
        if (this.scanner == null) {
            throw new IllegalArgumentException("null at resetTo(int begin, int end)");
        }
        this.scanner.yyreset(new IntervalDocumentReader(this.document, begin, end));
        this.scanner.setInScriptingState();
    }

    int storeTrailingComments(ASTNode node, int nextStart, boolean lastChild, int[] parentLineRange) {
        int nodeEnd = node.getEnd() - 1;
        if (nodeEnd == nextStart) {
            if (++this.trailingPtr == 0) {
                this.trailingNodes = new ASTNode[16];
                this.trailingIndexes = new long[16];
                this.lastTrailingPtr = -1;
            } else if (this.trailingPtr == this.trailingNodes.length) {
                int newLength = this.trailingPtr * 3 / 2 + 16;
                this.trailingNodes = new ASTNode[newLength];
                System.arraycopy(this.trailingNodes, 0, this.trailingNodes, 0, this.trailingPtr);
                this.trailingIndexes = new long[newLength];
                System.arraycopy(this.trailingIndexes, 0, this.trailingIndexes, 0, this.trailingPtr);
            }
            this.trailingNodes[this.trailingPtr] = node;
            this.trailingIndexes[this.trailingPtr] = -1L;
            return nodeEnd;
        }
        int extended = nodeEnd;
        int nodeEndLine = this.getLineNumber(nodeEnd, parentLineRange);
        int idx = this.getCommentIndex(0, nodeEnd, 1);
        if (idx == -1) {
            return nodeEnd;
        }
        int startIdx = idx;
        int endIdx = -1;
        int length = this.comments.length;
        int commentStart = extended + 1;
        int previousEnd = nodeEnd + 1;
        int sameLineIdx = -1;
        while (idx < length && commentStart < nextStart) {
            int commentLine;
            Comment comment = this.comments[idx];
            commentStart = comment.getStart();
            if (commentStart >= nextStart) break;
            if (previousEnd < commentStart) {
                try {
                    this.resetTo(previousEnd, commentStart);
                    this.scanner.next_token();
                    String token = this.scanner.yytext();
                    if (token != null && StringUtils.isNotBlank((CharSequence)token)) {
                        if (idx != startIdx) break;
                        return nodeEnd;
                    }
                }
                catch (Exception exception) {
                    assert (false);
                    return nodeEnd;
                }
            }
            if ((commentLine = this.getLineNumber(commentStart, parentLineRange)) == nodeEndLine) {
                sameLineIdx = idx;
            }
            previousEnd = commentStart + comment.getLength();
            endIdx = idx++;
        }
        if (endIdx != -1) {
            long nodeRange;
            int previousLine;
            int nextLine;
            if (!lastChild && (nextLine = this.getLineNumber(nextStart, parentLineRange)) - (previousLine = this.getLineNumber(previousEnd, parentLineRange)) <= 1) {
                if (sameLineIdx == -1) {
                    return nodeEnd;
                }
                endIdx = sameLineIdx;
            }
            if (++this.trailingPtr == 0) {
                this.trailingNodes = new ASTNode[16];
                this.trailingIndexes = new long[16];
                this.lastTrailingPtr = -1;
            } else if (this.trailingPtr == this.trailingNodes.length) {
                int newLength = this.trailingPtr * 3 / 2 + 16;
                this.trailingNodes = new ASTNode[newLength];
                System.arraycopy(this.trailingNodes, 0, this.trailingNodes, 0, this.trailingPtr);
                this.trailingIndexes = new long[newLength];
                System.arraycopy(this.trailingIndexes, 0, this.trailingIndexes, 0, this.trailingPtr);
            }
            this.trailingNodes[this.trailingPtr] = node;
            this.trailingIndexes[this.trailingPtr] = nodeRange = ((long)startIdx << 32) + (long)endIdx;
            extended = this.comments[endIdx].getEnd() - 1;
            ASTNode previousNode = node;
            int ptr = this.trailingPtr - 1;
            while (ptr >= 0) {
                ASTNode unresolved;
                long range = this.trailingIndexes[ptr];
                if (range != -1L || previousNode != (unresolved = this.trailingNodes[ptr]).getParent()) break;
                this.trailingIndexes[ptr] = nodeRange;
                previousNode = unresolved;
                --ptr;
            }
            if (ptr > this.lastTrailingPtr) {
                int offset = ptr - this.lastTrailingPtr;
                int i = ptr + 1;
                while (i <= this.trailingPtr) {
                    this.trailingNodes[i - offset] = this.trailingNodes[i];
                    this.trailingIndexes[i - offset] = this.trailingIndexes[i];
                    ++i;
                }
                this.trailingPtr -= offset;
            }
            this.lastTrailingPtr = this.trailingPtr;
        }
        return extended;
    }

    class CommentMapperVisitor
    extends ApplyAll {
        ASTNode topSiblingParent = null;
        ASTNode[] siblings = new ASTNode[10];
        int[][] parentLineRange = new int[10][];
        int siblingPtr = -1;

        CommentMapperVisitor() {
        }

        @Override
        protected boolean apply(ASTNode node) {
            int[] nArray;
            ASTNode sibling;
            ASTNode parent = node.getParent();
            int previousEnd = parent.getStart();
            ASTNode aSTNode = sibling = parent == this.topSiblingParent ? this.siblings[this.siblingPtr] : null;
            if (sibling != null) {
                try {
                    previousEnd = DefaultCommentMapper.this.storeTrailingComments(sibling, node.getStart(), false, this.parentLineRange[this.siblingPtr]);
                }
                catch (Exception exception) {}
            }
            if (node.getType() == 4) {
                return false;
            }
            if (this.siblingPtr > -1) {
                nArray = this.parentLineRange[this.siblingPtr];
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = DefaultCommentMapper.this.document.getNumberOfLines();
            }
            int[] previousLineRange = nArray;
            try {
                DefaultCommentMapper.this.storeLeadingComments(node, previousEnd, previousLineRange);
            }
            catch (Exception exception) {}
            if (this.topSiblingParent != parent) {
                if (this.siblings.length == ++this.siblingPtr) {
                    this.siblings = new ASTNode[this.siblingPtr * 2];
                    System.arraycopy(this.siblings, 0, this.siblings, 0, this.siblingPtr);
                    int[][] nArrayArray = new int[this.siblingPtr * 2][];
                    this.parentLineRange = nArrayArray;
                    System.arraycopy(this.parentLineRange, 0, nArrayArray, 0, this.siblingPtr);
                }
                if (this.topSiblingParent == null) {
                    this.parentLineRange[this.siblingPtr] = previousLineRange;
                } else {
                    int parentStart = parent.getStart();
                    int firstLine = DefaultCommentMapper.this.getLineNumber(parentStart, previousLineRange);
                    int lastLine = DefaultCommentMapper.this.getLineNumber(parentStart + parent.getLength() - 1, previousLineRange);
                    if (this.parentLineRange[this.siblingPtr] == null) {
                        this.parentLineRange[this.siblingPtr] = new int[]{firstLine, lastLine};
                    } else {
                        int[] lineRange = this.parentLineRange[this.siblingPtr];
                        lineRange[0] = firstLine;
                        lineRange[1] = lastLine;
                    }
                }
                this.topSiblingParent = parent;
            }
            this.siblings[this.siblingPtr] = node;
            return true;
        }

        @Override
        public void endVisitNode(ASTNode node) {
            ASTNode sibling;
            ASTNode aSTNode = sibling = this.topSiblingParent == node ? this.siblings[this.siblingPtr] : null;
            if (sibling != null) {
                try {
                    DefaultCommentMapper.this.storeTrailingComments(sibling, node.getEnd() - 1, true, this.parentLineRange[this.siblingPtr]);
                }
                catch (Exception exception) {}
            }
            if (this.topSiblingParent != null && this.topSiblingParent == node) {
                --this.siblingPtr;
                this.topSiblingParent = node.getParent();
            }
        }

        @Override
        public boolean visit(Program node) {
            return true;
        }

        @Override
        public boolean visit(Comment node) {
            return false;
        }
    }

    public static class IntervalDocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IDocument parent;
        private int startPhpRegion;
        private final int endPhpRegion;

        public IntervalDocumentReader(IDocument parent, int startPhpRegion, int endPhpRegion) {
            this.parent = parent;
            this.startPhpRegion = startPhpRegion;
            this.endPhpRegion = endPhpRegion;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.startPhpRegion < this.endPhpRegion ? (int)this.parent.getChar(this.startPhpRegion++) : -1;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(BAD_LOCATION_ERROR + this.startPhpRegion);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            while (i < len) {
                c = this.read();
                if (c == -1) break;
                b[off + i] = (char)c;
                ++i;
            }
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

