/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.factory;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.function.Function;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.TreeFactory;

public class AnnotationFactory<PRODUCT>
extends TreeFactory.ContainerAware {
    private final Class<PRODUCT> productType;
    private final Method[] methods;

    public AnnotationFactory(Class<PRODUCT> productType, IFactoryKey key) {
        super(key);
        this.productType = productType;
        this.methods = productType.getMethods();
    }

    public AnnotationFactory(Class<PRODUCT> productType, String productGroup, String type) {
        super(productGroup, type);
        this.productType = productType;
        this.methods = productType.getMethods();
    }

    public final Class<PRODUCT> getProductType() {
        return this.productType;
    }

    protected final PRODUCT create(Tree config) throws ProductCreationException {
        try {
            PRODUCT product = this.createProduct(config);
            this.configureProduct(product, config);
            return product;
        }
        catch (Exception ex) {
            throw this.productCreationException(config, (Throwable)ex);
        }
    }

    protected PRODUCT createProduct(Tree config) throws Exception {
        Object product;
        Constructor<?> containerConfigConstructor = null;
        Constructor<?> configContainerConstructor = null;
        Constructor<?> configConstructor = null;
        Constructor<?> containerConstructor = null;
        Constructor<?> defaultConstructor = null;
        Constructor<?>[] constructorArray = this.productType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Parameter[] parameters = constructor.getParameters();
            if (parameters.length == 2) {
                if (parameters[0].getType() == IManagedContainer.class && parameters[1].getType() == Tree.class) {
                    containerConfigConstructor = constructor;
                } else if (parameters[0].getType() == Tree.class && parameters[1].getType() == IManagedContainer.class) {
                    configContainerConstructor = constructor;
                }
            } else if (parameters.length == 1) {
                if (parameters[0].getType() == IManagedContainer.class) {
                    containerConstructor = constructor;
                } else if (parameters[0].getType() == Tree.class) {
                    configConstructor = constructor;
                }
            } else if (parameters.length == 0) {
                defaultConstructor = constructor;
            }
            ++n2;
        }
        if (containerConfigConstructor != null) {
            product = containerConfigConstructor.newInstance(this.getContainer(), config);
            return (PRODUCT)product;
        }
        if (configContainerConstructor != null) {
            product = configContainerConstructor.newInstance(config, this.getContainer());
            return (PRODUCT)product;
        }
        if (configConstructor != null) {
            product = configConstructor.newInstance(config);
            this.invokeAnnotatedMethod(product, InjectContainer.class, new Object[0]);
            return (PRODUCT)product;
        }
        if (containerConstructor != null) {
            product = containerConstructor.newInstance(this.getContainer());
            this.invokeAnnotatedMethod(product, InjectConfig.class, config);
            return (PRODUCT)product;
        }
        if (defaultConstructor != null) {
            product = defaultConstructor.newInstance(new Object[0]);
            this.invokeAnnotatedMethod(product, InjectContainer.class, new Object[0]);
            this.invokeAnnotatedMethod(product, InjectConfig.class, config);
            return (PRODUCT)product;
        }
        throw new IllegalStateException("No suitable constructor found in " + this.productType);
    }

    protected void configureProduct(PRODUCT product, Tree config) throws Exception {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                this.injectAttribute(product, config, method);
            }
            catch (Exception ex) {
                throw new IllegalStateException("An attribute could not be injected via " + method, ex);
            }
            try {
                this.injectElement(product, config, method);
            }
            catch (Exception ex) {
                throw new IllegalStateException("An element could not be injected via " + method, ex);
            }
            ++n2;
        }
    }

    protected void injectAttribute(PRODUCT product, Tree config, Method method) throws Exception {
        InjectAttribute annotation = method.getAnnotation(InjectAttribute.class);
        if (annotation != null) {
            String defaultValue;
            String name = annotation.name();
            String value = config.attribute(name);
            if (value == null && !StringUtil.isEmpty(defaultValue = annotation.defaultValue())) {
                value = defaultValue;
            }
            if (value != null) {
                String productGroup;
                boolean stringConverters = annotation.stringConverters();
                if (stringConverters) {
                    value = StringUtil.convert(value, this.getContainer());
                }
                if (!StringUtil.isEmpty(productGroup = annotation.productGroup())) {
                    boolean singleton = annotation.productSingleton();
                    String descriptionAttribute = annotation.descriptionAttribute();
                    Object element = this.createElement(productGroup, value, descriptionAttribute, config, singleton);
                    if (element != null) {
                        method.invoke(product, element);
                    }
                    return;
                }
                Class<?> parameterType = method.getParameters()[0].getType();
                boolean enumCaseSensitive = this.isEnumCaseSensitive();
                Object argument = StringUtil.parse(value, this.getContainer(), parameterType, enumCaseSensitive);
                method.invoke(product, argument);
            }
        }
    }

    protected boolean isEnumCaseSensitive() {
        return false;
    }

    protected void injectElement(PRODUCT product, Tree config, Method method) throws IllegalAccessException, InvocationTargetException {
        InjectElement annotation = method.getAnnotation(InjectElement.class);
        if (annotation != null) {
            List<Tree> elementConfigs;
            Function<Tree, String> typeFunction;
            boolean elementNameIsFactoryType;
            String name = annotation.name();
            String productGroup = annotation.productGroup();
            boolean singleton = annotation.productSingleton();
            String descriptionAttribute = annotation.descriptionAttribute();
            InjectElement.Cardinality cardinality = annotation.cardinality();
            if (cardinality == InjectElement.Cardinality.DETECT) {
                cardinality = this.detectCardinality(product, config, method);
            }
            if (elementNameIsFactoryType = StringUtil.isEmpty(name)) {
                typeFunction = Tree::name;
                elementConfigs = config.children();
            } else {
                String factoryTypeAttribute = annotation.factoryTypeAttribute();
                String defaultFactoryType = annotation.defaultFactoryType();
                String factoryTypePrefix = annotation.factoryTypePrefix();
                String factoryTypeSuffix = annotation.factoryTypeSuffix();
                typeFunction = elementConfig -> this.getElementType((Tree)elementConfig, factoryTypeAttribute, defaultFactoryType, factoryTypePrefix, factoryTypeSuffix);
                elementConfigs = config.children(name);
            }
            for (Tree elementConfig2 : elementConfigs) {
                String type = typeFunction.apply(elementConfig2);
                Object element = this.createElement(productGroup, type, descriptionAttribute, elementConfig2, singleton);
                if (element == null) continue;
                method.invoke(product, element);
                if (cardinality == InjectElement.Cardinality.FIRST) break;
            }
        }
    }

    @Deprecated
    protected String getElementType(Tree elementConfig, String factoryTypeAttribute, String defaultFactoryType) {
        return this.getElementType(elementConfig, factoryTypeAttribute, defaultFactoryType, "", "");
    }

    protected String getElementType(Tree elementConfig, String factoryTypeAttribute, String defaultFactoryType, String factoryTypePrefix, String factoryTypeSuffix) {
        String type = elementConfig.attribute(factoryTypeAttribute);
        if (type == null) {
            type = defaultFactoryType;
        }
        if (StringUtil.isEmpty(type)) {
            throw new IllegalStateException("Factory type is not specified");
        }
        return String.valueOf(StringUtil.safe(factoryTypePrefix)) + type + StringUtil.safe(factoryTypeSuffix);
    }

    protected Object createElement(String productGroup, String type, String descriptionAttribute, Tree elementConfig, boolean singleton) throws ProductCreationException {
        IManagedContainer container = this.getContainer();
        if (!StringUtil.isEmpty(descriptionAttribute)) {
            String description = elementConfig.attribute(descriptionAttribute);
            if (singleton) {
                return container.getElementOrNull(productGroup, type, description);
            }
            return container.createElement(productGroup, type, description);
        }
        if (singleton) {
            return container.getElementOrNull(productGroup, type, elementConfig);
        }
        return container.createElement(productGroup, type, elementConfig);
    }

    private InjectElement.Cardinality detectCardinality(PRODUCT product, Tree config, Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("add") || methodName.startsWith("append") || methodName.startsWith("insert")) {
            return InjectElement.Cardinality.MULTIPLE;
        }
        return InjectElement.Cardinality.FIRST;
    }

    private <A extends Annotation> boolean invokeAnnotatedMethod(PRODUCT product, Class<A> annotationClass, Object ... arguments) throws Exception {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(annotationClass) != null) {
                method.invoke(product, arguments);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Inherited
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InjectAttribute {
        public String name();

        public String defaultValue() default "";

        public boolean stringConverters() default true;

        public String productGroup() default "";

        public boolean productSingleton() default false;

        public String descriptionAttribute() default "";
    }

    @Inherited
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InjectConfig {
    }

    @Inherited
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InjectContainer {
    }

    @Inherited
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InjectElement {
        public static final String FACTORY_TYPE_ATTRIBUTE = "type";

        public String name() default "";

        public String productGroup();

        public boolean productSingleton() default false;

        public String factoryTypeAttribute() default "type";

        public String defaultFactoryType() default "";

        public String factoryTypePrefix() default "";

        public String factoryTypeSuffix() default "";

        public String descriptionAttribute() default "";

        public Cardinality cardinality() default Cardinality.DETECT;

        public static enum Cardinality {
            DETECT,
            FIRST,
            MULTIPLE;

        }
    }
}

