/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.font;

import java.awt.Toolkit;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.CSSFont;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFontManager;
import org.eclipse.jst.pagedesigner.css2.property.FontWeightMeta;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.CacheManager;
import org.eclipse.jst.pagedesigner.utils.ICacheEntryCreator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class CSSFontManager
implements ICSSFontManager {
    private static CSSFontManager _instance;
    private static final boolean DEBUG = false;
    private int _totalFont = 0;
    private static final int CACHESIZE = 100;
    private static final double FONT_SCALE;
    private CacheManager _cacheManager = new CacheManager(new ICacheEntryCreator<CSSFont, Font>(){

        @Override
        public Font createEntry(CSSFont key) {
            Font font = new Font(null, CSSFontManager.cssFontToLocalFont(key.getFontFamily()), (int)Math.round((double)key.getFontSize() / FONT_SCALE), key.getSwtFontStyle());
            return font;
        }

        @Override
        public void dispose(CSSFont key, Font entry) {
            entry.dispose();
        }
    }, 100);

    static {
        FONT_SCALE = CSSFontManager.getFontDPI() / 72.0;
    }

    static double getFontDPI() {
        Object value;
        double fontDPI = -1.0;
        if ("gtk".equals(SWT.getPlatform()) && (value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI")) instanceof Integer) {
            fontDPI = (Integer)value / 1024;
            if (fontDPI == -1.0) {
                fontDPI = 96.0;
            }
            if (fontDPI < 50.0) {
                fontDPI = 50.0;
            }
        }
        if (fontDPI == -1.0) {
            fontDPI = Display.getCurrent().getDPI().x;
        }
        return fontDPI;
    }

    static String cssFontToLocalFont(String original) {
        if ("serif".equalsIgnoreCase(original)) {
            return "Georgia";
        }
        if ("sans-serif".equalsIgnoreCase(original)) {
            return "Arial";
        }
        if ("cursive".equalsIgnoreCase(original)) {
            return "Comic Sans MS";
        }
        if ("fantasy".equalsIgnoreCase(original)) {
            return CSSFontManager.cssFontToLocalFont("serif");
        }
        if ("monospace".equalsIgnoreCase(original)) {
            return "Courier New";
        }
        return original;
    }

    private CSSFontManager() {
    }

    private String resolveFontStyleString(ICSSStyle style) {
        StringBuffer sb = new StringBuffer();
        sb.append("font-family").append(":");
        sb.append("'").append((String)style.getStyleProperty("font-family")).append("'");
        sb.append(";");
        sb.append("font-style").append(":");
        sb.append((String)style.getStyleProperty("font-style")).append(";");
        sb.append("font-weight").append(":");
        sb.append(((Integer)style.getStyleProperty("font-weight")).toString()).append(";");
        sb.append("font-size").append(":");
        int fontSize = this.getFontSize(style, style.getStyleProperty("font-size"));
        sb.append(Integer.toString(fontSize));
        return sb.toString();
    }

    @Override
    public ICSSFont createFont(ICSSStyle style) {
        String fontfamily = (String)style.getStyleProperty("font-family");
        Object fontsizeobj = style.getStyleProperty("font-size");
        int fontsize = this.getFontSize(style, fontsizeobj);
        int fontstyle = this.getFontStyle(style);
        int fontweight = (Integer)style.getStyleProperty("font-weight");
        return new CSSFont(fontfamily, fontsize, fontstyle, fontweight, this.resolveFontStyleString(style));
    }

    private int getFontSize(ICSSStyle style, Object fontsizeobj) {
        int fontsize = fontsizeobj instanceof Length ? ((Length)fontsizeobj).getValue() : style.getParentStyle().getCSSFont().getFontSize();
        return fontsize;
    }

    private int getFontStyle(ICSSStyle style) {
        String fontstylestr = (String)style.getStyleProperty("font-style");
        int fontstyle = "italic".equals(fontstylestr) || "oblique".equals(fontstylestr) ? 2 : 0;
        return fontstyle;
    }

    @Override
    public void dispose() {
        this._cacheManager.disposeAll();
    }

    public ICSSFont createDefaultFont() {
        CSSFont result = new CSSFont("Times New Roman", 16, 0, FontWeightMeta.NORMAL_WEIGHT, "");
        return result;
    }

    public Font getSwtFont(CSSFont f) {
        return (Font)this._cacheManager.getEntry(f);
    }

    public static CSSFontManager getInstance() {
        if (_instance == null) {
            _instance = new CSSFontManager();
        }
        return _instance;
    }
}

