/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors.parser;

import java.util.HashMap;
import org.eclipse.cdt.autotools.ui.editors.parser.ParseException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AutoconfOutlineErrorHandler {
    public static final String PARSE_ERROR_MARKER_ID = "org.eclipse.cdt.autotools.ui.outlineparsefileerror";
    private IFile file;
    private IDocument document;

    public AutoconfOutlineErrorHandler(IStorageEditorInput input, IDocument document) {
        this.document = document;
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        try {
            IPath absPath = input.getStorage().getFullPath();
            IPath rootPath = root.getLocation();
            Path relPath = new Path("");
            int i = 0;
            while (i < rootPath.segmentCount()) {
                relPath = relPath.append("../");
                ++i;
            }
            relPath = relPath.append(absPath);
            this.file = root.getFileForLocation((IPath)relPath);
            if (this.file == null) {
                this.file = root.getFile((IPath)relPath);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void handleError(ParseException e) {
        Integer charEnd;
        if (!this.file.exists()) {
            return;
        }
        int lineNumber = e.getLineNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        MarkerUtilities.setLineNumber(map, (int)lineNumber);
        MarkerUtilities.setMessage(map, (String)e.getMessage());
        map.put("message", e.getMessage());
        map.put("location", this.file.getFullPath().toString());
        Integer charStart = this.getCharOffset(lineNumber, e.getStartColumn());
        if (charStart != null) {
            map.put("charStart", charStart);
        }
        if ((charEnd = this.getCharOffset(lineNumber, e.getEndColumn())) != null) {
            map.put("charEnd", charEnd);
        }
        map.put("severity", e.getSeverity());
        try {
            MarkerUtilities.createMarker((IResource)this.file, map, (String)PARSE_ERROR_MARKER_ID);
        }
        catch (CoreException ee) {
            ee.printStackTrace();
        }
    }

    public void removeAllExistingMarkers() {
        if (!this.file.exists()) {
            return;
        }
        try {
            this.file.deleteMarkers(PARSE_ERROR_MARKER_ID, true, 0);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    public void removeExistingMarkers(int offset, int length) {
        if (!this.file.exists()) {
            return;
        }
        try {
            IMarker[] markers = this.file.findMarkers(PARSE_ERROR_MARKER_ID, true, 0);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                int charEnd = MarkerUtilities.getCharEnd((IMarker)marker);
                int charStart = MarkerUtilities.getCharStart((IMarker)marker);
                if (charStart >= offset && charEnd <= offset + length) {
                    marker.delete();
                }
                ++i;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private Integer getCharOffset(int lineNumber, int columnNumber) {
        try {
            return this.document.getLineOffset(lineNumber) + columnNumber;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

