/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.gef;

import java.util.ArrayList;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wb.gef.core.IEditPartViewer;

public final class EditPartsSelectionProvider
implements ISelectionProvider {
    private final IEditPartViewer m_viewer;
    private final EventListenerList m_eventTable = new EventListenerList();
    private final ISelectionChangedListener m_selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            EditPartsSelectionProvider.this.fireSelectionChanged();
        }
    };

    public EditPartsSelectionProvider(IEditPartViewer viewer) {
        this.m_viewer = viewer;
    }

    public ISelection getSelection() {
        ArrayList<Object> models = new ArrayList<Object>();
        for (EditPart editPart : this.m_viewer.getSelectedEditParts()) {
            models.add(editPart.getModel());
        }
        return new StructuredSelection(models);
    }

    public void setSelection(ISelection selection) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        for (Object model : (StructuredSelection)selection) {
            EditPart editPart = (EditPart)this.m_viewer.getEditPartRegistry().get(model);
            if (editPart == null) continue;
            editParts.add(editPart);
        }
        this.m_viewer.setSelection((ISelection)new StructuredSelection(editParts));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.m_eventTable.getListeners(ISelectionChangedListener.class).hasNext()) {
            this.m_viewer.addSelectionChangedListener(this.m_selectionListener);
        }
        this.m_eventTable.addListener(ISelectionChangedListener.class, (Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_eventTable.removeListener(ISelectionChangedListener.class, (Object)listener);
        if (!this.m_eventTable.getListeners(ISelectionChangedListener.class).hasNext()) {
            this.m_viewer.removeSelectionChangedListener(this.m_selectionListener);
        }
    }

    private void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.m_eventTable.getListenersIterable(ISelectionChangedListener.class)) {
            listener.selectionChanged(event);
        }
    }
}

