/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildrenGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildrenTree;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;

public abstract class DefaultObjectPresentation
implements IObjectPresentation {
    private final ObjectInfo m_object;

    public DefaultObjectPresentation(ObjectInfo object) {
        this.m_object = object;
    }

    @Override
    public List<ObjectInfo> getChildrenTree() throws Exception {
        ArrayList<ObjectInfo> children = new ArrayList<ObjectInfo>();
        for (ObjectInfo child : this.m_object.getChildren()) {
            boolean[] visible = new boolean[]{true};
            visible[0] = visible[0] & child.getPresentation().isVisible();
            this.m_object.getBroadcast(ObjectInfoChildTree.class).invoke(child, visible);
            if (!visible[0]) continue;
            children.add(child);
        }
        this.m_object.getBroadcast(ObjectInfoChildrenTree.class).invoke(this.m_object, children);
        return children;
    }

    @Override
    public List<ObjectInfo> getChildrenGraphical() throws Exception {
        ArrayList<ObjectInfo> children = new ArrayList<ObjectInfo>();
        for (ObjectInfo child : this.m_object.getChildren()) {
            boolean[] visible = new boolean[]{true};
            visible[0] = visible[0] & child.getPresentation().isVisible();
            this.m_object.getBroadcast(ObjectInfoChildGraphical.class).invoke(child, visible);
            if (!visible[0]) continue;
            children.add(child);
        }
        this.m_object.getBroadcast(ObjectInfoChildrenGraphical.class).invoke(children);
        return children;
    }

    @Override
    public ImageDescriptor getIcon() throws Exception {
        return null;
    }

    @Override
    public boolean isVisible() throws Exception {
        return true;
    }
}

