/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;

public final class BorderOfChildLayoutRequestValidator
implements ILayoutRequestValidator {
    public static final ILayoutRequestValidator INSTANCE = new BorderOfChildLayoutRequestValidator();

    private BorderOfChildLayoutRequestValidator() {
    }

    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        return BorderOfChildLayoutRequestValidator.isTargetingToHost_containerSelected(host, request);
    }

    @Override
    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        return BorderOfChildLayoutRequestValidator.isTargetingToHost_containerSelected(host, request);
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        return true;
    }

    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        if (host instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalHost = (GraphicalEditPart)host;
            if (((EditPart)request.getEditParts().get(0)).getParent() == host.getParent()) {
                return BorderOfChildLayoutRequestValidator.isTargeting_innerPartOfHost(graphicalHost, request);
            }
        }
        return true;
    }

    private static boolean isTargetingToHost_containerSelected(EditPart host, DropRequest request) {
        GraphicalEditPart graphicalHost;
        if (host instanceof GraphicalEditPart && BorderOfChildLayoutRequestValidator.isTransparentOnBorders(graphicalHost = (GraphicalEditPart)host)) {
            return BorderOfChildLayoutRequestValidator.isTargeting_innerPartOfHost(graphicalHost, request);
        }
        return true;
    }

    private static boolean isTargeting_innerPartOfHost(GraphicalEditPart host, DropRequest request) {
        Figure hostFigure = host.getFigure();
        Point location = request.getLocation().getCopy();
        FigureUtils.translateAbsoluteToFigure2((IFigure)hostFigure, (Translatable)location);
        Rectangle hostClientArea = hostFigure.getClientArea();
        return hostClientArea.getExpanded(-3, -3).contains(location);
    }

    private static boolean isTransparentOnBorders(GraphicalEditPart host) {
        Object hostModel = host.getModel();
        IParametersProvider provider = GlobalState.getParametersProvider();
        if (provider.hasTrueParameter(hostModel, "GEF.transparentOnBorders.always")) {
            return true;
        }
        return BorderOfChildLayoutRequestValidator.isChildOf_selectedEditPart((EditPart)host);
    }

    private static boolean isChildOf_selectedEditPart(EditPart child) {
        List selectedEditParts = child.getViewer().getSelectedEditParts();
        return selectedEditParts.size() == 1 && BorderOfChildLayoutRequestValidator.areParentChild((EditPart)selectedEditParts.get(0), child);
    }

    private static boolean areParentChild(EditPart parent, EditPart child) {
        EditPart part = child.getParent();
        while (part != null) {
            if (part == parent) {
                return true;
            }
            part = part.getParent();
        }
        return false;
    }
}

