/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.grid;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.IHeadersProvider;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.helpers.BroadcastListenerHelper;
import org.eclipse.wb.core.gef.policy.helpers.SelectionListenerHelper;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridHelper;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.draw2d.SemiTransparentFigure;

public abstract class AbstractGridLayoutEditPolicy
extends LayoutEditPolicy
implements IHeadersProvider {
    protected AbstractGridHelper m_gridTargetHelper;
    protected AbstractGridHelper m_gridSelectionHelper;
    protected GridTarget m_target;
    private final Figure m_targetFeedback = new SemiTransparentFigure(64);
    private TextFeedback m_textFeedback;
    private static final Color m_goodTargetFillColor = new Color(0, 255, 0);
    private static final Color m_goodTargetBorderColor = new Color(192, 255, 192);
    private static final Color m_badTargetFillColor = new Color(255, 0, 0);
    private static final Color m_badTargetBorderColor = new Color(255, 192, 192);
    private final Figure m_insertColumnFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private final Figure m_insertRowFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private static final Color m_insertTargetFillColor = new Color(null, 255, 255, 128);
    private static final Color m_insertTargetBorderColor = new Color(null, 255, 235, 30);
    protected static final int INSERT_MARGINS = 5;
    public static final int INSERT_COLUMN_SIZE = 7;
    public static final int INSERT_ROW_SIZE = 5;

    public AbstractGridLayoutEditPolicy(ObjectInfo layout) {
        new BroadcastListenerHelper(layout, this, new ObjectEventListener(){

            @Override
            public void refreshed2() throws Exception {
                AbstractGridLayoutEditPolicy.this.refreshSelectionGrid();
            }
        });
        new SelectionListenerHelper(this, (EditPartListener)new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editPart) {
                AbstractGridLayoutEditPolicy.this.refreshSelectionGrid();
            }
        });
    }

    protected abstract IGridInfo getGridInfo();

    @Override
    public void deactivate() {
        super.deactivate();
        this.m_gridSelectionHelper.eraseGridFeedback();
    }

    private void refreshSelectionGrid() {
        EditPolicy parentLayoutEditPolicy;
        this.m_gridSelectionHelper.eraseGridFeedback();
        if (this.getHost().getSelected() != 0 && !((parentLayoutEditPolicy = this.getHost().getParent().getEditPolicy("LayoutEditPolicy")) instanceof AbstractGridLayoutEditPolicy)) {
            this.m_gridSelectionHelper.showGridFeedback();
        }
    }

    @Override
    protected final void showLayoutTargetFeedback(Request request) {
        IGridInfo gridInfo = this.getGridInfo();
        this.m_gridTargetHelper.showGridFeedback();
        try {
            Point location = ((DropRequest)request).getLocation();
            this.updateGridTarget(location);
            this.removeTargetFigures();
            this.showInsertFeedbacks(this.m_target.m_columnInsertBounds, this.m_target.m_rowInsertBounds);
            if (!this.m_target.m_feedbackBounds.isEmpty()) {
                this.validateTarget(gridInfo);
                if (!this.m_target.m_valid) {
                    if (this.showOccupiedLayoutTargetFeedback(request)) {
                        return;
                    }
                } else {
                    this.eraseOccupiedLayoutTargetFeedback(request);
                }
                if (this.m_target.m_valid) {
                    this.m_targetFeedback.setBackgroundColor(m_goodTargetFillColor);
                    this.m_targetFeedback.setBorder(new LineBorder(m_goodTargetBorderColor));
                } else {
                    this.m_targetFeedback.setBackgroundColor(m_badTargetFillColor);
                    this.m_targetFeedback.setBorder(new LineBorder(m_badTargetBorderColor));
                }
                this.getLayer("Handle Layer Sub 1").add((IFigure)this.m_targetFeedback);
                Rectangle bounds = this.m_target.m_feedbackBounds.getCopy();
                bounds.shrink(1, 1);
                PolicyUtils.translateModelToFeedback(this, (Translatable)bounds);
                this.m_targetFeedback.setBounds(bounds);
                if (this.m_textFeedback == null) {
                    this.m_textFeedback = new TextFeedback(this.getFeedbackLayer());
                    this.m_textFeedback.add();
                }
                this.m_textFeedback.setText("column " + this.m_target.m_column + ", row " + this.m_target.m_row);
                this.m_textFeedback.setLocation(location.getTranslated(15, 33));
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    private void validateTarget(IGridInfo gridInfo) {
        IAbstractComponentInfo targetComponent = null;
        if (targetComponent == null && this.m_target.m_columnInsert) {
            IAbstractComponentInfo leftTarget = gridInfo.getOccupied(this.m_target.m_column - 1, this.m_target.m_row);
            IAbstractComponentInfo rightTarget = gridInfo.getOccupied(this.m_target.m_column, this.m_target.m_row);
            if (leftTarget != null && leftTarget == rightTarget) {
                targetComponent = leftTarget;
            }
        }
        if (targetComponent == null && this.m_target.m_rowInsert) {
            IAbstractComponentInfo topTarget = gridInfo.getOccupied(this.m_target.m_column, this.m_target.m_row - 1);
            IAbstractComponentInfo bottomTarget = gridInfo.getOccupied(this.m_target.m_column, this.m_target.m_row);
            if (topTarget != null && topTarget == bottomTarget) {
                targetComponent = topTarget;
            }
        }
        if (targetComponent == null && !this.m_target.m_columnInsert && !this.m_target.m_rowInsert) {
            targetComponent = gridInfo.getOccupied(this.m_target.m_column, this.m_target.m_row);
        }
        if (targetComponent != null) {
            this.m_target.m_valid = false;
            Rectangle targetCells = gridInfo.getComponentCells(targetComponent);
            if (targetCells != null) {
                this.m_target.m_feedbackBounds = gridInfo.getCellsRectangle(targetCells);
            }
        }
    }

    @Override
    protected final void eraseLayoutTargetFeedback(Request request) {
        this.m_gridTargetHelper.eraseGridFeedback();
        this.removeTargetFigures();
        this.eraseOccupiedLayoutTargetFeedback(request);
    }

    private void removeTargetFigures() {
        this.eraseInsertFeedbacks();
        FigureUtils.removeFigure(this.m_targetFeedback);
        if (this.m_textFeedback != null) {
            this.m_textFeedback.remove();
            this.m_textFeedback = null;
        }
    }

    protected boolean showOccupiedLayoutTargetFeedback(Request request) {
        return false;
    }

    protected void eraseOccupiedLayoutTargetFeedback(Request request) {
    }

    public static Figure createInsertFigure() {
        SemiTransparentFigure figure = new SemiTransparentFigure(160);
        figure.setBackgroundColor(m_insertTargetFillColor);
        figure.setBorder(new LineBorder(m_insertTargetBorderColor));
        return figure;
    }

    public void showInsertFeedbacks(Rectangle columnBounds, Rectangle rowBounds) {
        Rectangle bounds;
        this.removeTargetFigures();
        if (columnBounds != null && !columnBounds.isEmpty()) {
            this.getLayer("Handle Layer Sub 1").add((IFigure)this.m_insertColumnFeedback);
            bounds = columnBounds.getCopy();
            PolicyUtils.translateModelToFeedback(this, (Translatable)bounds);
            this.m_insertColumnFeedback.setBounds(bounds);
        }
        if (rowBounds != null && !rowBounds.isEmpty()) {
            this.getLayer("Handle Layer Sub 1").add((IFigure)this.m_insertRowFeedback);
            bounds = rowBounds.getCopy();
            PolicyUtils.translateModelToFeedback(this, (Translatable)bounds);
            this.m_insertRowFeedback.setBounds(bounds);
        }
    }

    public void eraseInsertFeedbacks() {
        FigureUtils.removeFigure(this.m_insertColumnFeedback);
        FigureUtils.removeFigure(this.m_insertRowFeedback);
    }

    protected abstract void updateGridTarget(Point var1) throws Exception;

    protected static class GridTarget {
        public boolean m_valid = true;
        public int m_column = -1;
        public boolean m_columnInsert;
        public int m_row = -1;
        public boolean m_rowInsert;
        public Rectangle m_feedbackBounds = new Rectangle();
        public Rectangle m_columnInsertBounds = new Rectangle();
        public Rectangle m_rowInsertBounds = new Rectangle();

        public String toString() {
            return this.m_column + " " + this.m_columnInsert + " " + this.m_row + " " + this.m_rowInsert + " " + String.valueOf(this.m_feedbackBounds);
        }
    }
}

