/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.actions;

import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DebugSourcesViewRefresh
implements IViewActionDelegate,
IDebugContextListener,
IActionDelegate2 {
    private IViewPart view;
    private IAction action;

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.updateEnablement();
    }

    public void init(IViewPart view) {
        this.view = view;
        if (view != null) {
            IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(view.getSite().getWorkbenchWindow());
            debugContextService.addPostDebugContextListener((IDebugContextListener)this);
        }
        this.updateEnablement();
    }

    private void updateEnablement() {
        if (this.view instanceof DebugSourcesView) {
            DebugSourcesView debugSourcesView = (DebugSourcesView)this.view;
            this.action.setEnabled(debugSourcesView.canRefresh());
        } else {
            this.action.setEnabled(false);
        }
    }

    public void init(IAction action) {
        this.action = action;
        this.updateEnablement();
    }

    public void dispose() {
        if (this.view != null) {
            DebugUITools.getDebugContextManager().getContextService(this.view.getSite().getWorkbenchWindow()).removePostDebugContextListener((IDebugContextListener)this);
            this.view = null;
        }
        this.updateEnablement();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.updateEnablement();
    }

    public void run(IAction action) {
        throw new UnsupportedOperationException("call runWithEvent instead");
    }

    public void runWithEvent(IAction action, Event event) {
        if (this.view instanceof DebugSourcesView) {
            DebugSourcesView debugSourcesView = (DebugSourcesView)this.view;
            debugSourcesView.refresh();
        }
    }
}

