/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.HashCodeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InstanceScopeAnalysis;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

public abstract class CompositeNavigationStep
extends AbstractNavigationStep
implements HashCodeChangeListener {
    private final NavigationStep[] steps;
    private int cachedXorOfStepHashCodes;
    private final SemanticIdentity semanticIdentity;

    public CompositeNavigationStep(EClass sourceType, EClass targetType, OCLExpression debugInfo, NavigationStep ... steps) {
        super(sourceType, targetType, debugInfo);
        this.steps = steps;
        NavigationStep[] navigationStepArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            NavigationStep step = navigationStepArray[n2];
            this.cachedXorOfStepHashCodes ^= step.hashCode();
            step.addHashCodeChangeListener(this);
            ++n2;
        }
        this.semanticIdentity = new CompositeNavigationStepIdentity();
    }

    private SemanticIdentity getSemanticIdentityOfSuper() {
        return super.getSemanticIdentity();
    }

    protected SemanticIdentity getSemanticIdentityOfAbstractNavigationStep() {
        return super.getSemanticIdentity();
    }

    public NavigationStep[] getSteps() {
        return this.steps;
    }

    @Override
    public void beforeHashCodeChange(NavigationStep step, int token) {
        this.fireBeforeHashCodeChange(token);
        this.cachedXorOfStepHashCodes ^= step.hashCode();
    }

    @Override
    public void afterHashCodeChange(NavigationStep step, int token) {
        this.cachedXorOfStepHashCodes ^= step.hashCode();
        this.fireAfterHashCodeChange(token);
    }

    @Override
    protected int size(Set<NavigationStep> visited) {
        int result = 0;
        if (!visited.contains(this)) {
            visited.add(this);
            ++result;
            NavigationStep[] navigationStepArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationStep step = navigationStepArray[n2];
                result += ((AbstractNavigationStep)step).size(visited);
                ++n2;
            }
        }
        return result;
    }

    @Override
    protected int distinctSize(Set<SemanticIdentity> visited) {
        int result = 0;
        if (!visited.contains(this.getSemanticIdentity())) {
            visited.add(this.getSemanticIdentity());
            ++result;
            NavigationStep[] navigationStepArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationStep step = navigationStepArray[n2];
                result += ((AbstractNavigationStep)step).distinctSize(visited);
                ++n2;
            }
        }
        return result;
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    public InstanceScopeAnalysis getInstanceScopeAnalysis() {
        return null;
    }

    private class CompositeNavigationStepIdentity
    extends SemanticIdentity {
        private CompositeNavigationStepIdentity() {
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            if (o instanceof CompositeNavigationStep) {
                NavigationStep[] otherSteps = ((CompositeNavigationStepIdentity)o).getNavigationStep().getSteps();
                if (otherSteps.length != CompositeNavigationStep.this.steps.length) {
                    return false;
                }
                int i = 0;
                while (i < CompositeNavigationStep.this.steps.length) {
                    SemanticIdentity otherSubStepIdentity;
                    SemanticIdentity thisSubStepIdentity = CompositeNavigationStep.this.steps[i].getSemanticIdentity();
                    if (!thisSubStepIdentity.equals(otherSubStepIdentity = otherSteps[i].getSemanticIdentity())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        @Override
        public int calculateHashCode() {
            int hashCode = CompositeNavigationStep.this.getSemanticIdentityOfSuper().hashCode();
            return hashCode ^= CompositeNavigationStep.this.cachedXorOfStepHashCodes;
        }

        public CompositeNavigationStep getNavigationStep() {
            return CompositeNavigationStep.this;
        }

        @Override
        public NavigationStep getStep() {
            return this.getNavigationStep();
        }
    }
}

