/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class DotSubgrammarValidationMessageAcceptor
implements ValidationMessageAcceptor {
    private final Attribute attribute;
    private final ValidationMessageAcceptor hostMessageAcceptor;
    private final String userReadableIdentifier;
    private final int initialOffset;

    public DotSubgrammarValidationMessageAcceptor(Attribute attribute, EStructuralFeature hostingFeature, String userReadableIdentifier, ValidationMessageAcceptor hostMessageAcceptor, int internalOffset) {
        this.attribute = attribute;
        this.hostMessageAcceptor = hostMessageAcceptor;
        this.userReadableIdentifier = userReadableIdentifier;
        this.initialOffset = this.calculateInitialOffset(hostingFeature, internalOffset);
    }

    public void acceptSyntaxError(INode error) {
        SyntaxErrorMessage errorMessage = error.getSyntaxErrorMessage();
        this.hostMessageAcceptor.acceptError(this.buildSyntaxErrorMessage(errorMessage.getMessage()), (EObject)this.attribute, this.calculateOffset(error.getOffset()), error.getLength(), errorMessage.getIssueCode(), errorMessage.getIssueData());
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        for (INode node : this.getNodesForEObject(object, feature)) {
            this.hostMessageAcceptor.acceptError(this.buildSemanticErrorMessage(message), (EObject)this.attribute, this.calculateOffset(node.getOffset()), node.getLength(), code, issueData);
        }
    }

    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.hostMessageAcceptor.acceptError(this.buildSemanticErrorMessage(message), (EObject)this.attribute, this.calculateOffset(offset), length, code, issueData);
    }

    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        for (INode node : this.getNodesForEObject(object, feature)) {
            this.hostMessageAcceptor.acceptInfo(this.buildSemanticErrorMessage(message), (EObject)this.attribute, this.calculateOffset(node.getOffset()), node.getLength(), code, issueData);
        }
    }

    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.hostMessageAcceptor.acceptInfo(this.buildSemanticErrorMessage(message), (EObject)this.attribute, this.calculateOffset(offset), length, code, issueData);
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        for (INode node : this.getNodesForEObject(object, feature)) {
            this.hostMessageAcceptor.acceptWarning(this.buildSemanticErrorMessage(message), (EObject)this.attribute, this.calculateOffset(node.getOffset()), node.getLength(), code, issueData);
        }
    }

    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.hostMessageAcceptor.acceptWarning(this.buildSemanticErrorMessage(message), (EObject)this.attribute, this.calculateOffset(offset), length, code, issueData);
    }

    private int calculateInitialOffset(EStructuralFeature hostingFeature, int internalOffset) {
        List<INode> nodes = this.getNodesForEObject(this.attribute, hostingFeature);
        if (nodes.size() != 1) {
            throw new RuntimeException("EObject has no node or feature not unique");
        }
        return nodes.get(0).getOffset() + internalOffset;
    }

    private int calculateOffset(int offset) {
        return offset >= 0 && this.initialOffset >= 0 ? offset + this.initialOffset : offset;
    }

    private List<INode> getNodesForEObject(EObject eObject, EStructuralFeature eStructuralFeature) {
        ArrayList<ICompositeNode> nodes = NodeModelUtils.findNodesForFeature((EObject)eObject, (EStructuralFeature)eStructuralFeature);
        if (nodes.size() == 0) {
            nodes = new ArrayList<ICompositeNode>();
            nodes.add(NodeModelUtils.findActualNodeFor((EObject)eObject));
        }
        return nodes;
    }

    private String buildSyntaxErrorMessage(String errorMessage) {
        StringBuilder message = new StringBuilder();
        message.append("The value '" + this.attribute.getValue().toValue() + "' is not a syntactically correct " + this.userReadableIdentifier + ": ").append(errorMessage);
        return message.toString();
    }

    private String buildSemanticErrorMessage(String errorMessage) {
        StringBuilder message = new StringBuilder();
        message.append("The " + this.userReadableIdentifier + " '" + this.attribute.getValue().toValue() + "' is not semantically correct: ").append(errorMessage);
        return message.toString();
    }
}

