/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class RestrictedEndOfLineRule
extends EndOfLineRule {
    private List<IRule> rules;
    private int startIndex;
    private int endIndex;
    private String startSequence;
    private String restrictedChars;

    public RestrictedEndOfLineRule(String startSequence, String restrictedChars, IToken token) {
        this(startSequence, restrictedChars, token, '\u0000');
    }

    public RestrictedEndOfLineRule(String startSequence, String restrictedChars, IToken token, char escapeCharacter) {
        this(startSequence, restrictedChars, token, escapeCharacter, false);
    }

    public RestrictedEndOfLineRule(String startSequence, String restrictedChars, IToken token, char escapeCharacter, boolean breaksOnEOF) {
        super(startSequence, token, escapeCharacter, breaksOnEOF);
        this.startSequence = startSequence;
        this.restrictedChars = restrictedChars;
        this.rules = new ArrayList<IRule>();
        this.startIndex = 0;
        this.endIndex = 0;
    }

    public void addRule(SingleLineRule rule) {
        this.rules.add((IRule)rule);
    }

    protected void backupScanner(ICharacterScanner scanner, int position) {
        int count = scanner.getColumn() - position;
        while (count-- > 0) {
            scanner.unread();
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int start;
        int column = scanner.getColumn();
        if (column < 0) {
            return Token.UNDEFINED;
        }
        if (!resume) {
            this.startIndex = scanner.getColumn();
            if (super.evaluate(scanner, false) != Token.UNDEFINED) {
                this.endIndex = scanner.getColumn();
                this.backupScanner(scanner, this.startIndex + this.startSequence.length());
            } else {
                return Token.UNDEFINED;
            }
        }
        column = start = scanner.getColumn();
        while (column < this.endIndex) {
            int ch = scanner.read();
            if (ch == -1 || this.restrictedChars.indexOf(ch) >= 0) {
                scanner.unread();
                return this.getSuccessToken();
            }
            ++column;
        }
        this.startIndex = 0;
        this.endIndex = 0;
        return this.getSuccessToken();
    }
}

