/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.NetworkAttachment;
import org.mandas.docker.client.messages.swarm.Task;
import org.mandas.docker.client.messages.swarm.TaskSpec;
import org.mandas.docker.client.messages.swarm.TaskStatus;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableTask
implements Task {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, String> labels;
    private final TaskSpec spec;
    private final String serviceId;
    @Nullable
    private final Integer slot;
    @Nullable
    private final String nodeId;
    private final TaskStatus status;
    private final String desiredState;
    @Nullable
    private final List<NetworkAttachment> networkAttachments;
    @Nullable
    private final Version jobIteration;

    private ImmutableTask(String id, Version version, Date createdAt, Date updatedAt, @Nullable String name, @Nullable Map<String, String> labels, TaskSpec spec, String serviceId, @Nullable Integer slot, @Nullable String nodeId, TaskStatus status, String desiredState, @Nullable List<NetworkAttachment> networkAttachments, @Nullable Version jobIteration) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.name = name;
        this.labels = labels;
        this.spec = spec;
        this.serviceId = serviceId;
        this.slot = slot;
        this.nodeId = nodeId;
        this.status = status;
        this.desiredState = desiredState;
        this.networkAttachments = networkAttachments;
        this.jobIteration = jobIteration;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Spec")
    public TaskSpec spec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public String serviceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="Slot")
    @Nullable
    public Integer slot() {
        return this.slot;
    }

    @Override
    @JsonProperty(value="NodeID")
    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty(value="Status")
    public TaskStatus status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="DesiredState")
    public String desiredState() {
        return this.desiredState;
    }

    @Override
    @JsonProperty(value="NetworksAttachments")
    @Nullable
    public List<NetworkAttachment> networkAttachments() {
        return this.networkAttachments;
    }

    @Override
    @JsonProperty(value="JobIteration")
    @Nullable
    public Version jobIteration() {
        return this.jobIteration;
    }

    public final ImmutableTask withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTask(newValue, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableTask(this.id, newValue, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableTask(this.id, this.version, newValue, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableTask(this.id, this.version, this.createdAt, newValue, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, value, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableTask.createUnmodifiableMap(true, false, entries);
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, newValue, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withSpec(TaskSpec value) {
        if (this.spec == value) {
            return this;
        }
        TaskSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, newValue, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (this.serviceId.equals(newValue)) {
            return this;
        }
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, newValue, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withSlot(@Nullable Integer value) {
        if (Objects.equals(this.slot, value)) {
            return this;
        }
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, value, this.nodeId, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withNodeId(@Nullable String value) {
        if (Objects.equals(this.nodeId, value)) {
            return this;
        }
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, value, this.status, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withStatus(TaskStatus value) {
        if (this.status == value) {
            return this;
        }
        TaskStatus newValue = Objects.requireNonNull(value, "status");
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, newValue, this.desiredState, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withDesiredState(String value) {
        String newValue = Objects.requireNonNull(value, "desiredState");
        if (this.desiredState.equals(newValue)) {
            return this;
        }
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, newValue, this.networkAttachments, this.jobIteration);
    }

    public final ImmutableTask withNetworkAttachments(NetworkAttachment ... elements) {
        if (elements == null) {
            return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, null, this.jobIteration);
        }
        List<NetworkAttachment> newValue = Arrays.asList(elements) == null ? null : ImmutableTask.createUnmodifiableList(false, ImmutableTask.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, newValue, this.jobIteration);
    }

    public final ImmutableTask withNetworkAttachments(@Nullable Iterable<? extends NetworkAttachment> elements) {
        if (this.networkAttachments == elements) {
            return this;
        }
        List<NetworkAttachment> newValue = elements == null ? null : ImmutableTask.createUnmodifiableList(false, ImmutableTask.createSafeList(elements, true, false));
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, newValue, this.jobIteration);
    }

    public final ImmutableTask withJobIteration(@Nullable Version value) {
        if (this.jobIteration == value) {
            return this;
        }
        return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTask && this.equalTo(0, (ImmutableTask)another);
    }

    private boolean equalTo(int synthetic, ImmutableTask another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && Objects.equals(this.name, another.name) && Objects.equals(this.labels, another.labels) && this.spec.equals(another.spec) && this.serviceId.equals(another.serviceId) && Objects.equals(this.slot, another.slot) && Objects.equals(this.nodeId, another.nodeId) && this.status.equals(another.status) && this.desiredState.equals(another.desiredState) && Objects.equals(this.networkAttachments, another.networkAttachments) && Objects.equals(this.jobIteration, another.jobIteration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.serviceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.slot);
        h += (h << 5) + Objects.hashCode(this.nodeId);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.desiredState.hashCode();
        h += (h << 5) + Objects.hashCode(this.networkAttachments);
        h += (h << 5) + Objects.hashCode(this.jobIteration);
        return h;
    }

    public String toString() {
        return "Task{id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", name=" + this.name + ", labels=" + this.labels + ", spec=" + this.spec + ", serviceId=" + this.serviceId + ", slot=" + this.slot + ", nodeId=" + this.nodeId + ", status=" + this.status + ", desiredState=" + this.desiredState + ", networkAttachments=" + this.networkAttachments + ", jobIteration=" + this.jobIteration + "}";
    }

    public static ImmutableTask copyOf(Task instance) {
        if (instance instanceof ImmutableTask) {
            return (ImmutableTask)instance;
        }
        return ImmutableTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SPEC = 16L;
        private static final long INIT_BIT_SERVICE_ID = 32L;
        private static final long INIT_BIT_STATUS = 64L;
        private static final long INIT_BIT_DESIRED_STATE = 128L;
        private long initBits = 255L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private String name;
        private Map<String, String> labels = null;
        private TaskSpec spec;
        private String serviceId;
        private Integer slot;
        private String nodeId;
        private TaskStatus status;
        private String desiredState;
        private List<NetworkAttachment> networkAttachments = null;
        private Version jobIteration;

        private Builder() {
        }

        public final Builder from(Task instance) {
            Version jobIterationValue;
            String nodeIdValue;
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            this.spec(instance.spec());
            this.serviceId(instance.serviceId());
            Integer slotValue = instance.slot();
            if (slotValue != null) {
                this.slot(slotValue);
            }
            if ((nodeIdValue = instance.nodeId()) != null) {
                this.nodeId(nodeIdValue);
            }
            this.status(instance.status());
            this.desiredState(instance.desiredState());
            List<NetworkAttachment> networkAttachmentsValue = instance.networkAttachments();
            if (networkAttachmentsValue != null) {
                this.addAllNetworkAttachments(networkAttachmentsValue);
            }
            if ((jobIterationValue = instance.jobIteration()) != null) {
                this.jobIteration(jobIterationValue);
            }
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder spec(TaskSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="ServiceID")
        public final Builder serviceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Slot")
        public final Builder slot(@Nullable Integer slot) {
            this.slot = slot;
            return this;
        }

        @JsonProperty(value="NodeID")
        public final Builder nodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @JsonProperty(value="Status")
        public final Builder status(TaskStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="DesiredState")
        public final Builder desiredState(String desiredState) {
            this.desiredState = Objects.requireNonNull(desiredState, "desiredState");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder networkAttachment(NetworkAttachment element) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>();
            }
            this.networkAttachments.add(Objects.requireNonNull(element, "networkAttachments element"));
            return this;
        }

        public final Builder networkAttachments(NetworkAttachment ... elements) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>();
            }
            for (NetworkAttachment element : elements) {
                this.networkAttachments.add(Objects.requireNonNull(element, "networkAttachments element"));
            }
            return this;
        }

        @JsonProperty(value="NetworksAttachments")
        public final Builder networkAttachments(@Nullable Iterable<? extends NetworkAttachment> elements) {
            if (elements == null) {
                this.networkAttachments = null;
                return this;
            }
            this.networkAttachments = new ArrayList<NetworkAttachment>();
            return this.addAllNetworkAttachments(elements);
        }

        public final Builder addAllNetworkAttachments(Iterable<? extends NetworkAttachment> elements) {
            Objects.requireNonNull(elements, "networkAttachments element");
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>();
            }
            for (NetworkAttachment networkAttachment : elements) {
                this.networkAttachments.add(Objects.requireNonNull(networkAttachment, "networkAttachments element"));
            }
            return this;
        }

        @JsonProperty(value="JobIteration")
        public final Builder jobIteration(@Nullable Version jobIteration) {
            this.jobIteration = jobIteration;
            return this;
        }

        public ImmutableTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTask(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels == null ? null : ImmutableTask.createUnmodifiableMap(false, false, this.labels), this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments == null ? null : ImmutableTask.createUnmodifiableList(true, this.networkAttachments), this.jobIteration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("desiredState");
            }
            return "Cannot build Task, some of required attributes are not set " + attributes;
        }
    }

    static final class Criteria
    implements Task.Criteria {
        @Nullable
        private final String taskId;
        @Nullable
        private final String taskName;
        @Nullable
        private final String serviceName;
        @Nullable
        private final String nodeId;
        @Nullable
        private final String label;
        @Nullable
        private final String desiredState;

        private Criteria(@Nullable String taskId, @Nullable String taskName, @Nullable String serviceName, @Nullable String nodeId, @Nullable String label, @Nullable String desiredState) {
            this.taskId = taskId;
            this.taskName = taskName;
            this.serviceName = serviceName;
            this.nodeId = nodeId;
            this.label = label;
            this.desiredState = desiredState;
        }

        @Override
        @JsonProperty(value="taskId")
        @Nullable
        public String taskId() {
            return this.taskId;
        }

        @Override
        @JsonProperty(value="taskName")
        @Nullable
        public String taskName() {
            return this.taskName;
        }

        @Override
        @JsonProperty(value="serviceName")
        @Nullable
        public String serviceName() {
            return this.serviceName;
        }

        @Override
        @JsonProperty(value="nodeId")
        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Override
        @JsonProperty(value="label")
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        @JsonProperty(value="desiredState")
        @Nullable
        public String desiredState() {
            return this.desiredState;
        }

        public final Criteria withTaskId(@Nullable String value) {
            if (Objects.equals(this.taskId, value)) {
                return this;
            }
            return new Criteria(value, this.taskName, this.serviceName, this.nodeId, this.label, this.desiredState);
        }

        public final Criteria withTaskName(@Nullable String value) {
            if (Objects.equals(this.taskName, value)) {
                return this;
            }
            return new Criteria(this.taskId, value, this.serviceName, this.nodeId, this.label, this.desiredState);
        }

        public final Criteria withServiceName(@Nullable String value) {
            if (Objects.equals(this.serviceName, value)) {
                return this;
            }
            return new Criteria(this.taskId, this.taskName, value, this.nodeId, this.label, this.desiredState);
        }

        public final Criteria withNodeId(@Nullable String value) {
            if (Objects.equals(this.nodeId, value)) {
                return this;
            }
            return new Criteria(this.taskId, this.taskName, this.serviceName, value, this.label, this.desiredState);
        }

        public final Criteria withLabel(@Nullable String value) {
            if (Objects.equals(this.label, value)) {
                return this;
            }
            return new Criteria(this.taskId, this.taskName, this.serviceName, this.nodeId, value, this.desiredState);
        }

        public final Criteria withDesiredState(@Nullable String value) {
            if (Objects.equals(this.desiredState, value)) {
                return this;
            }
            return new Criteria(this.taskId, this.taskName, this.serviceName, this.nodeId, this.label, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Criteria && this.equalTo(0, (Criteria)another);
        }

        private boolean equalTo(int synthetic, Criteria another) {
            return Objects.equals(this.taskId, another.taskId) && Objects.equals(this.taskName, another.taskName) && Objects.equals(this.serviceName, another.serviceName) && Objects.equals(this.nodeId, another.nodeId) && Objects.equals(this.label, another.label) && Objects.equals(this.desiredState, another.desiredState);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.taskId);
            h += (h << 5) + Objects.hashCode(this.taskName);
            h += (h << 5) + Objects.hashCode(this.serviceName);
            h += (h << 5) + Objects.hashCode(this.nodeId);
            h += (h << 5) + Objects.hashCode(this.label);
            h += (h << 5) + Objects.hashCode(this.desiredState);
            return h;
        }

        public String toString() {
            return "Criteria{taskId=" + this.taskId + ", taskName=" + this.taskName + ", serviceName=" + this.serviceName + ", nodeId=" + this.nodeId + ", label=" + this.label + ", desiredState=" + this.desiredState + "}";
        }

        public static Criteria copyOf(Task.Criteria instance) {
            if (instance instanceof Criteria) {
                return (Criteria)instance;
            }
            return Criteria.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements Task.Criteria.Builder {
            private String taskId;
            private String taskName;
            private String serviceName;
            private String nodeId;
            private String label;
            private String desiredState;

            private Builder() {
            }

            public final Builder from(Task.Criteria instance) {
                String desiredStateValue;
                String labelValue;
                String nodeIdValue;
                String serviceNameValue;
                String taskNameValue;
                Objects.requireNonNull(instance, "instance");
                String taskIdValue = instance.taskId();
                if (taskIdValue != null) {
                    this.taskId(taskIdValue);
                }
                if ((taskNameValue = instance.taskName()) != null) {
                    this.taskName(taskNameValue);
                }
                if ((serviceNameValue = instance.serviceName()) != null) {
                    this.serviceName(serviceNameValue);
                }
                if ((nodeIdValue = instance.nodeId()) != null) {
                    this.nodeId(nodeIdValue);
                }
                if ((labelValue = instance.label()) != null) {
                    this.label(labelValue);
                }
                if ((desiredStateValue = instance.desiredState()) != null) {
                    this.desiredState(desiredStateValue);
                }
                return this;
            }

            @Override
            @JsonProperty(value="taskId")
            public final Builder taskId(@Nullable String taskId) {
                this.taskId = taskId;
                return this;
            }

            @Override
            @JsonProperty(value="taskName")
            public final Builder taskName(@Nullable String taskName) {
                this.taskName = taskName;
                return this;
            }

            @Override
            @JsonProperty(value="serviceName")
            public final Builder serviceName(@Nullable String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            @JsonProperty(value="nodeId")
            public final Builder nodeId(@Nullable String nodeId) {
                this.nodeId = nodeId;
                return this;
            }

            @Override
            @JsonProperty(value="label")
            public final Builder label(@Nullable String label) {
                this.label = label;
                return this;
            }

            @Override
            @JsonProperty(value="desiredState")
            public final Builder desiredState(@Nullable String desiredState) {
                this.desiredState = desiredState;
                return this;
            }

            @Override
            public Criteria build() {
                return new Criteria(this.taskId, this.taskName, this.serviceName, this.nodeId, this.label, this.desiredState);
            }
        }
    }
}

