/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSRuleDeclContainer;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclarationImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleSheetImpl;
import org.eclipse.wst.css.core.internal.document.MediaListImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNamedNodeMap;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSRuleContainer;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

class CSSModelUtil {
    CSSModelUtil() {
    }

    static boolean canContainBrace(ICSSNode node) {
        return node != null && (node instanceof ICSSRuleContainer || node instanceof CSSRuleDeclContainer);
    }

    static void cleanupContainer(ICSSNode parent) {
        if (parent == null) {
            return;
        }
        ICSSNode child = parent.getFirstChild();
        while (child != null) {
            CSSModelUtil.cleanupContainer(child);
            child = child.getNextSibling();
        }
        if (parent instanceof CSSStructuredDocumentRegionContainer) {
            ((CSSStructuredDocumentRegionContainer)parent).setRangeStructuredDocumentRegion(null, null);
        } else if (parent instanceof CSSRegionContainer) {
            ((CSSRegionContainer)parent).setRangeRegion(null, null, null);
        }
    }

    static boolean diagnoseNode(ICSSNode parent, IStructuredDocument structuredDocument) {
        String nodeText;
        CSSNodeImpl node;
        Vector<CallSite> errors = new Vector<CallSite>();
        if (parent instanceof CSSStructuredDocumentRegionContainer) {
            IStructuredDocumentRegion modelNode;
            node = (CSSStructuredDocumentRegionContainer)parent;
            nodeText = CSSUtil.getClassString(node) + ": ";
            IStructuredDocumentRegion flatNode = ((CSSStructuredDocumentRegionContainer)node).getFirstStructuredDocumentRegion();
            if (flatNode == null && (!(node instanceof CSSStyleDeclarationImpl) && !(node instanceof CSSStyleSheetImpl) || node.getFirstChild() != null)) {
                errors.add((CallSite)((Object)(nodeText + "first flat node is null.")));
            } else if (flatNode != null && flatNode != (modelNode = structuredDocument.getRegionAtCharacterOffset(flatNode.getStart()))) {
                errors.add((CallSite)((Object)(nodeText + "first flat node is not in model.")));
            }
            flatNode = ((CSSStructuredDocumentRegionContainer)node).getLastStructuredDocumentRegion();
            if (flatNode == null && (!(node instanceof CSSStyleDeclarationImpl) && !(node instanceof CSSStyleSheetImpl) || node.getFirstChild() != null)) {
                errors.add((CallSite)((Object)(nodeText + "last flat node is null.")));
            } else if (flatNode != null && flatNode != (modelNode = structuredDocument.getRegionAtCharacterOffset(flatNode.getStart()))) {
                errors.add((CallSite)((Object)(nodeText + "last flat node is not in model.")));
            }
        } else if (parent instanceof CSSRegionContainer) {
            int offset;
            IStructuredDocumentRegion modelNode;
            ITextRegion modelRegion;
            node = (CSSRegionContainer)parent;
            nodeText = CSSUtil.getClassString(node) + ": ";
            ITextRegion region = ((CSSRegionContainer)node).getFirstRegion();
            IStructuredDocumentRegion parentRegion = ((CSSRegionContainer)node).getDocumentRegion();
            if (!(region != null || node instanceof MediaListImpl && node.getFirstChild() == null)) {
                errors.add((CallSite)((Object)(nodeText + "first region is null.")));
            } else if (region != null && region != (modelRegion = (modelNode = structuredDocument.getRegionAtCharacterOffset(offset = parentRegion.getStartOffset(region))).getRegionAtCharacterOffset(offset))) {
                errors.add((CallSite)((Object)(nodeText + "first region is not in model.")));
            }
            region = ((CSSRegionContainer)node).getLastRegion();
            if (!(region != null || node instanceof MediaListImpl && node.getFirstChild() == null)) {
                errors.add((CallSite)((Object)(nodeText + "last region is null.")));
            } else if (region != null && region != (modelRegion = (modelNode = structuredDocument.getRegionAtCharacterOffset(offset = parentRegion.getStartOffset(region))).getRegionAtCharacterOffset(offset))) {
                errors.add((CallSite)((Object)(nodeText + "last region is not in model.")));
            }
        }
        ICSSNamedNodeMap attrs = parent.getAttributes();
        int nAttrs = attrs.getLength();
        int i = 0;
        while (i < nAttrs) {
            int offset;
            IStructuredDocumentRegion modelNode;
            ITextRegion modelRegion;
            ICSSAttr attr = (ICSSAttr)attrs.item(i);
            CSSRegionContainer node2 = (CSSRegionContainer)((Object)attr);
            String nodeText2 = CSSUtil.getClassString(node2) + "(" + attr.getName() + "): ";
            ITextRegion region = node2.getFirstRegion();
            IStructuredDocumentRegion parentRegion = node2.getDocumentRegion();
            if (region == null && attr.getValue().length() > 0) {
                errors.add((CallSite)((Object)(nodeText2 + "first region is null.")));
            } else if (region != null && region != (modelRegion = (modelNode = structuredDocument.getRegionAtCharacterOffset(offset = parentRegion.getStartOffset(region))).getRegionAtCharacterOffset(offset))) {
                errors.add((CallSite)((Object)(nodeText2 + "first region is not in model.")));
            }
            region = node2.getLastRegion();
            if (region == null && attr.getValue().length() > 0) {
                errors.add((CallSite)((Object)(nodeText2 + "last region is null.")));
            } else if (region != null && region != (modelRegion = (modelNode = structuredDocument.getRegionAtCharacterOffset(offset = parentRegion.getStartOffset(region))).getRegionAtCharacterOffset(offset))) {
                errors.add((CallSite)((Object)(nodeText2 + "last region is not in model.")));
            }
            ++i;
        }
        if (!errors.isEmpty()) {
            Iterator i2 = errors.iterator();
            while (i2.hasNext()) {
                CSSUtil.debugOut((String)i2.next());
            }
            return false;
        }
        return true;
    }

    static boolean diagnoseTree(ICSSNode parent, IStructuredDocument structuredDocument) {
        if (parent == null) {
            return false;
        }
        ICSSNode child = parent.getFirstChild();
        while (child != null) {
            CSSModelUtil.diagnoseTree(child, structuredDocument);
            child = child.getNextSibling();
        }
        CSSModelUtil.diagnoseNode(parent, structuredDocument);
        return true;
    }

    static void expandStructuredDocumentRegionContainer(CSSStructuredDocumentRegionContainer target, IStructuredDocumentRegion flatNode) {
        if (target == null || flatNode == null) {
            return;
        }
        IStructuredDocumentRegion lastNode = target.getLastStructuredDocumentRegion();
        if (lastNode == flatNode) {
            return;
        }
        if (lastNode == null || lastNode.getStart() < flatNode.getStart()) {
            target.setLastStructuredDocumentRegion(flatNode);
        }
    }

    static ICSSNode findBraceContainer(ICSSNode node) {
        ICSSNode i = node;
        while (i != null) {
            if (CSSModelUtil.canContainBrace(i)) {
                return i;
            }
            i = i.getParentNode();
        }
        return null;
    }

    static int getDepth(ICSSNode node) {
        int depth = -1;
        while (node != null) {
            ++depth;
            node = node.getParentNode();
        }
        return depth;
    }

    static boolean isBraceClosed(ICSSNode node) {
        boolean bClosed = true;
        if (!(node instanceof CSSStructuredDocumentRegionContainer)) {
            return bClosed;
        }
        IStructuredDocumentRegion first = ((CSSStructuredDocumentRegionContainer)node).getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion last = ((CSSStructuredDocumentRegionContainer)node).getLastStructuredDocumentRegion();
        if (first == null || last == null) {
            return bClosed;
        }
        if (last.getStart() < first.getStart()) {
            return bClosed;
        }
        IStructuredDocumentRegion flatNode = first;
        int nOpen = 0;
        int nClose = 0;
        do {
            String type;
            if ((type = CSSUtil.getStructuredDocumentRegionType(flatNode)) == "LBRACE") {
                ++nOpen;
                continue;
            }
            if (type != "RBRACE") continue;
            ++nClose;
        } while ((flatNode = flatNode.getNext()) != null && flatNode != last);
        if (nOpen == 0 && nClose == 0 || nClose < nOpen) {
            bClosed = false;
        }
        return bClosed;
    }

    static boolean isInterruption(CSSStructuredDocumentRegionContainer target, IStructuredDocumentRegion flatNode) {
        if (target == null || flatNode == null) {
            return false;
        }
        int start = flatNode.getStart();
        IStructuredDocumentRegion firstNode = target.getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion lastNode = target.getLastStructuredDocumentRegion();
        return firstNode != null && firstNode.getStart() < start && lastNode != null && start < lastNode.getStart();
    }

    static boolean isParentOf(ICSSNode parent, ICSSNode child) {
        if (parent == null || child == null) {
            return false;
        }
        ICSSNode node = child;
        while (node != null) {
            if (parent == node) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }
}

