/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;

import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Aggregated Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl#getAggregator <em>Aggregator</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl#getCall <em>Call</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.AggregatedValueImpl#getAggregateType <em>Aggregate Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AggregatedValueImpl extends ComputationValueImpl implements AggregatedValue
{
	/**
	 * The cached value of the '{@link #getAggregator() <em>Aggregator</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregator()
	 * @generated
	 * @ordered
	 */
	protected JvmDeclaredType aggregator;

	/**
	 * The cached value of the '{@link #getCall() <em>Call</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCall()
	 * @generated
	 * @ordered
	 */
	protected CallableRelation call;

	/**
	 * The cached value of the '{@link #getAggregateType() <em>Aggregate Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregateType()
	 * @generated
	 * @ordered
	 */
	protected JvmType aggregateType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AggregatedValueImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return PatternLanguagePackage.Literals.AGGREGATED_VALUE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmDeclaredType getAggregator()
	{
		if (aggregator != null && aggregator.eIsProxy())
		{
			InternalEObject oldAggregator = (InternalEObject)aggregator;
			aggregator = (JvmDeclaredType)eResolveProxy(oldAggregator);
			if (aggregator != oldAggregator)
			{
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATOR, oldAggregator, aggregator));
			}
		}
		return aggregator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmDeclaredType basicGetAggregator()
	{
		return aggregator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAggregator(JvmDeclaredType newAggregator)
	{
		JvmDeclaredType oldAggregator = aggregator;
		aggregator = newAggregator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATOR, oldAggregator, aggregator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CallableRelation getCall()
	{
		return call;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCall(CallableRelation newCall, NotificationChain msgs)
	{
		CallableRelation oldCall = call;
		call = newCall;
		if (eNotificationRequired())
		{
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.AGGREGATED_VALUE__CALL, oldCall, newCall);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCall(CallableRelation newCall)
	{
		if (newCall != call)
		{
			NotificationChain msgs = null;
			if (call != null)
				msgs = ((InternalEObject)call).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - PatternLanguagePackage.AGGREGATED_VALUE__CALL, null, msgs);
			if (newCall != null)
				msgs = ((InternalEObject)newCall).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - PatternLanguagePackage.AGGREGATED_VALUE__CALL, null, msgs);
			msgs = basicSetCall(newCall, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.AGGREGATED_VALUE__CALL, newCall, newCall));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmType getAggregateType()
	{
		if (aggregateType != null && aggregateType.eIsProxy())
		{
			InternalEObject oldAggregateType = (InternalEObject)aggregateType;
			aggregateType = (JvmType)eResolveProxy(oldAggregateType);
			if (aggregateType != oldAggregateType)
			{
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATE_TYPE, oldAggregateType, aggregateType));
			}
		}
		return aggregateType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmType basicGetAggregateType()
	{
		return aggregateType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAggregateType(JvmType newAggregateType)
	{
		JvmType oldAggregateType = aggregateType;
		aggregateType = newAggregateType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATE_TYPE, oldAggregateType, aggregateType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		return org.eclipse.viatra.query.patternlanguage.emf.util.ASTStringProvider.INSTANCE.doSwitch(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.AGGREGATED_VALUE__CALL:
				return basicSetCall(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATOR:
				if (resolve) return getAggregator();
				return basicGetAggregator();
			case PatternLanguagePackage.AGGREGATED_VALUE__CALL:
				return getCall();
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATE_TYPE:
				if (resolve) return getAggregateType();
				return basicGetAggregateType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATOR:
				setAggregator((JvmDeclaredType)newValue);
				return;
			case PatternLanguagePackage.AGGREGATED_VALUE__CALL:
				setCall((CallableRelation)newValue);
				return;
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATE_TYPE:
				setAggregateType((JvmType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATOR:
				setAggregator((JvmDeclaredType)null);
				return;
			case PatternLanguagePackage.AGGREGATED_VALUE__CALL:
				setCall((CallableRelation)null);
				return;
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATE_TYPE:
				setAggregateType((JvmType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATOR:
				return aggregator != null;
			case PatternLanguagePackage.AGGREGATED_VALUE__CALL:
				return call != null;
			case PatternLanguagePackage.AGGREGATED_VALUE__AGGREGATE_TYPE:
				return aggregateType != null;
		}
		return super.eIsSet(featureID);
	}

} //AggregatedValueImpl
