/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui;

import com.google.inject.AbstractModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import javafx.embed.swt.FXCanvas;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.swt.canvas.FXCanvasEx;
import org.eclipse.gef.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef.mvc.fx.ui.parts.AbstractFXEditor;
import org.eclipse.gef.mvc.fx.ui.parts.AbstractFXView;
import org.eclipse.gef.mvc.fx.ui.parts.ContentSelectionProvider;
import org.eclipse.gef.mvc.fx.ui.parts.HistoryBasedDirtyStateProvider;
import org.eclipse.gef.mvc.fx.ui.parts.IDirtyStateProvider;
import org.eclipse.gef.mvc.fx.ui.parts.IDirtyStateProviderFactory;
import org.eclipse.gef.mvc.fx.ui.parts.ISelectionProviderFactory;
import org.eclipse.gef.mvc.fx.ui.properties.IPropertySheetPageFactory;
import org.eclipse.gef.mvc.fx.ui.properties.UndoablePropertySheetPage;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class MvcFxUiModule
extends AbstractModule {
    protected void bindFXCanvasFactory() {
        this.binder().bind(IFXCanvasFactory.class).toInstance((Object)new IFXCanvasFactory(){

            public FXCanvas createCanvas(Composite parent, int style) {
                return new FXCanvasEx(parent, style);
            }
        });
    }

    protected void bindIDirtyStateProviderFactory() {
        this.binder().bind(IDirtyStateProviderFactory.class).toInstance((Object)new IDirtyStateProviderFactory(){

            @Override
            public IDirtyStateProvider create(IWorkbenchPart workbenchPart) {
                return new HistoryBasedDirtyStateProvider((IOperationHistory)workbenchPart.getAdapter(IOperationHistory.class), (IUndoContext)workbenchPart.getAdapter(IUndoContext.class));
            }
        });
    }

    protected void bindIOperationHistory() {
        this.binder().bind(IOperationHistory.class).toInstance((Object)PlatformUI.getWorkbench().getOperationSupport().getOperationHistory());
    }

    protected void bindIPropertySheetPageFactory() {
        this.install(new FactoryModuleBuilder().implement(IPropertySheetPage.class, UndoablePropertySheetPage.class).build(IPropertySheetPageFactory.class));
    }

    protected void bindISelectionProviderFactory() {
        this.binder().bind(ISelectionProviderFactory.class).toInstance((Object)new ISelectionProviderFactory(){

            @Override
            public ISelectionProvider create(IWorkbenchPart workbenchPart) {
                IViewer contentViewer = null;
                if (workbenchPart instanceof AbstractFXView) {
                    contentViewer = (IViewer)((AbstractFXView)workbenchPart).getDomain().getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
                } else if (workbenchPart instanceof AbstractFXEditor) {
                    contentViewer = (IViewer)((AbstractFXEditor)workbenchPart).getDomain().getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
                } else {
                    throw new IllegalArgumentException("Cannot handle " + workbenchPart);
                }
                return new ContentSelectionProvider(contentViewer);
            }
        });
    }

    protected void configure() {
        this.bindIOperationHistory();
        this.bindFXCanvasFactory();
        this.bindISelectionProviderFactory();
        this.bindIDirtyStateProviderFactory();
        this.bindIPropertySheetPageFactory();
    }
}

