/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.utils;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.gef.fx.internal.nodes.Traverse;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.utils.Shape2Geometry;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IScalable;
import org.eclipse.gef.geometry.planar.ITranslatable;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.gef.geometry.planar.Rectangle;

public class NodeUtils {
    public static boolean equals(Affine a1, Affine a2) {
        return a1.getMxx() == a2.getMxx() && a1.getMxy() == a2.getMxy() && a1.getMxz() == a2.getMxz() && a1.getMyx() == a2.getMyx() && a1.getMyy() == a2.getMyy() && a1.getMyz() == a2.getMyz() && a1.getMzx() == a2.getMzx() && a1.getMzy() == a2.getMzy() && a1.getMzz() == a2.getMzz() && a1.getTx() == a2.getTx() && a1.getTy() == a2.getTy() && a1.getTz() == a2.getTz();
    }

    public static IGeometry getGeometricOutline(Node visual) {
        if (visual instanceof Connection) {
            Node curve = ((Connection)visual).getCurve();
            return NodeUtils.localToParent(curve, NodeUtils.getGeometricOutline(curve));
        }
        if (visual instanceof Traverse) {
            javafx.scene.shape.Polyline curve = ((Traverse)visual).getCurve();
            double[] coordinates = curve.getPoints().stream().mapToDouble(Double::doubleValue).toArray();
            return NodeUtils.localToParent((Node)curve, (IGeometry)new Polyline(coordinates));
        }
        if (visual instanceof GeometryNode) {
            GeometryNode geometryNode = (GeometryNode)visual;
            Object geometry = geometryNode.getGeometry();
            if (geometry != null) {
                if (geometry instanceof ITranslatable) {
                    return ((ITranslatable)geometry).getTranslated(-geometryNode.getLayoutX(), -geometryNode.getLayoutY());
                }
                return geometry.getTransformed(new AffineTransform().translate(-geometryNode.getLayoutX(), -geometryNode.getLayoutY()));
            }
            return new Rectangle();
        }
        if (visual instanceof Shape && !(visual instanceof Text) && !(visual instanceof SVGPath)) {
            return Shape2Geometry.toGeometry((Shape)visual);
        }
        throw new IllegalArgumentException("Cannot determine geometric outline for the given visual <" + visual + ">.");
    }

    public static AffineTransform getLocalToSceneTx(Node node) {
        AffineTransform tx = FX2Geometry.toAffineTransform((Transform)node.getLocalToParentTransform());
        Node tmp = node;
        while (tmp.getParent() != null) {
            tmp = tmp.getParent();
            tx = FX2Geometry.toAffineTransform((Transform)tmp.getLocalToParentTransform()).concatenate(tx);
        }
        return tx;
    }

    public static Node getNearestCommonAncestor(Node source, Node target) {
        if (source == target) {
            return source;
        }
        HashSet<Node> parents = new HashSet<Node>();
        Node m = source;
        Node n = target;
        while (m != null || n != null) {
            if (m != null) {
                if (parents.contains(m)) {
                    return m;
                }
                parents.add(m);
                if (n != null && parents.contains(n)) {
                    return n;
                }
                m = m.getParent();
            }
            if (n == null) continue;
            if (parents.contains(n)) {
                return n;
            }
            parents.add(n);
            if (m != null && parents.contains(m)) {
                return m;
            }
            n = n.getParent();
        }
        return null;
    }

    public static List<Node> getNodesAt(Node root, double sceneX, double sceneY) {
        ArrayList<Node> picked = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(root);
        while (!nodes.isEmpty()) {
            Node current = (Node)nodes.remove(0);
            Point2D pLocal = current.sceneToLocal(sceneX, sceneY);
            if (current.isMouseTransparent() || !current.getBoundsInLocal().contains(pLocal)) continue;
            if (current.contains(pLocal)) {
                picked.add(0, current);
            }
            if (!(current instanceof Parent)) continue;
            nodes.addAll(0, (Collection<Node>)((Parent)current).getChildrenUnmodifiable());
        }
        return picked;
    }

    public static IGeometry getResizedToShapeBounds(Node visual, IGeometry geometry) {
        Rectangle geometricBounds = geometry.getBounds();
        Rectangle shapeBounds = NodeUtils.getShapeBounds(visual);
        double dw = shapeBounds.getWidth() - geometricBounds.getWidth();
        double dh = shapeBounds.getHeight() - geometricBounds.getHeight();
        if (dw == 0.0 && dh == 0.0) {
            return geometry;
        }
        GeometryNode<IGeometry> geometryNode = new GeometryNode<IGeometry>(geometry);
        geometryNode.relocateGeometry(shapeBounds.getX(), shapeBounds.getY());
        geometryNode.resizeGeometry(shapeBounds.getWidth(), shapeBounds.getHeight());
        return geometryNode.getGeometry();
    }

    public static AffineTransform getSceneToLocalTx(Node node) {
        try {
            return NodeUtils.getLocalToSceneTx(node).invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Rectangle getShapeBounds(Node node) {
        Bounds layoutBounds = node.getLayoutBounds();
        double offset = 0.0;
        if (node instanceof Polygon && ((Polygon)node).getStroke() != null && ((Polygon)node).getStrokeType() != StrokeType.INSIDE) {
            offset = 0.5;
        }
        return (Rectangle)FX2Geometry.toRectangle((Bounds)layoutBounds).shrink(offset, offset, offset, offset);
    }

    public static IGeometry getShapeOutline(Node node) {
        try {
            IGeometry geometry = NodeUtils.getGeometricOutline(node);
            if (geometry instanceof ICurve) {
                return geometry;
            }
            if (geometry != null) {
                return NodeUtils.getResizedToShapeBounds(node, geometry);
            }
            return FX2Geometry.toRectangle((Bounds)node.getLayoutBounds());
        }
        catch (IllegalArgumentException e) {
            return FX2Geometry.toRectangle((Bounds)node.getLayoutBounds());
        }
    }

    private static IGeometry getTransformed(IGeometry g, AffineTransform a) {
        if (g instanceof ITranslatable && a.getM00() == 1.0 && a.getM11() == 1.0 && a.getM10() == 0.0 && a.getM01() == 0.0) {
            return ((ITranslatable)g).getTranslated(a.getTranslateX(), a.getTranslateY());
        }
        if (g instanceof IScalable && a.getM01() == 0.0 && a.getM10() == 0.0 && a.getTranslateX() == 0.0 && a.getTranslateY() == 0.0) {
            return ((IScalable)g).getScaled(a.getScaleX(), a.getScaleY(), 0.0, 0.0);
        }
        if (g instanceof ITranslatable && g instanceof IScalable && a.getM01() == 0.0 && a.getM10() == 0.0) {
            IGeometry g2 = g.getCopy();
            ((IScalable)g2).scale(a.getScaleX(), a.getScaleY(), 0.0, 0.0);
            ((ITranslatable)g2).translate(a.getTranslateX(), a.getTranslateY());
            return g2;
        }
        return g.getTransformed(a);
    }

    public static boolean isNested(Parent parent, Node node) {
        while (node != null) {
            if (node == parent) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static IGeometry localToParent(Node n, IGeometry g) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        return NodeUtils.getTransformed(g, localToParentTx);
    }

    public static Point localToParent(Node n, Point p) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        return localToParentTx.getTransformed(p);
    }

    public static IGeometry localToScene(Node n, IGeometry g) {
        AffineTransform localToSceneTx = NodeUtils.getLocalToSceneTx(n);
        return NodeUtils.getTransformed(g, localToSceneTx);
    }

    public static Point localToScene(Node n, Point p) {
        AffineTransform localToSceneTx = NodeUtils.getLocalToSceneTx(n);
        return localToSceneTx.getTransformed(p);
    }

    public static IGeometry parentToLocal(Node n, IGeometry g) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        AffineTransform parentToLocalTx = null;
        try {
            parentToLocalTx = localToParentTx.getCopy().invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
        return NodeUtils.getTransformed(g, parentToLocalTx);
    }

    public static Point parentToLocal(Node n, Point p) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        AffineTransform parentToLocalTx = null;
        try {
            parentToLocalTx = localToParentTx.getCopy().invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
        return parentToLocalTx.getTransformed(p);
    }

    public static IGeometry sceneToLocal(Node n, IGeometry g) {
        AffineTransform sceneToLocalTx = NodeUtils.getSceneToLocalTx(n);
        return NodeUtils.getTransformed(g, sceneToLocalTx);
    }

    public static Point sceneToLocal(Node n, Point p) {
        AffineTransform sceneToLocalTx = NodeUtils.getSceneToLocalTx(n);
        return sceneToLocalTx.getTransformed(p);
    }

    public static Affine setAffine(Affine dst, Affine src) {
        dst.setMxx(src.getMxx());
        dst.setMxy(src.getMxy());
        dst.setMxz(src.getMxz());
        dst.setMyx(src.getMyx());
        dst.setMyy(src.getMyy());
        dst.setMyz(src.getMyz());
        dst.setMzx(src.getMzx());
        dst.setMzy(src.getMzy());
        dst.setMzz(src.getMzz());
        dst.setTx(src.getTx());
        dst.setTy(src.getTy());
        dst.setTz(src.getTz());
        return dst;
    }
}

