/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.lock;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public abstract class AbstractCDOLockState
implements InternalCDOLockState {
    protected Object lockedObject;

    public AbstractCDOLockState(Object lockedObject) {
        assert (lockedObject instanceof CDOID || lockedObject instanceof CDOIDAndBranch) : "lockedObject is of wrong type";
        assert (!CDOIDUtil.isNull(CDOLockUtil.getLockedObjectID(lockedObject))) : "lockedObject is null";
        this.lockedObject = lockedObject;
    }

    @Override
    public final Object getLockedObject() {
        return this.lockedObject;
    }

    @Override
    public final CDOID getID() {
        return CDOLockUtil.getLockedObjectID(this.lockedObject);
    }

    @Override
    public void remapID(CDOID newID) {
        this.lockedObject = this.lockedObject instanceof CDOID ? newID : CDOIDUtil.createIDAndBranch(newID, ((CDOIDAndBranch)this.lockedObject).getBranch());
    }

    @Override
    public final CDOBranch getBranch() {
        return CDOLockUtil.getLockedObjectBranch(this.lockedObject);
    }

    public final int hashCode() {
        return Objects.hashCode(this.lockedObject);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CDOLockState)) {
            return false;
        }
        CDOLockState other = (CDOLockState)obj;
        if (!this.lockedObject.equals(other.getLockedObject())) {
            return false;
        }
        if (this.getWriteLockOwner() != other.getWriteLockOwner()) {
            return false;
        }
        if (this.getWriteOptionOwner() != other.getWriteOptionOwner()) {
            return false;
        }
        return this.getReadLockOwners().equals(other.getReadLockOwners());
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder("CDOLockState[lockedObject=");
        builder.append(this.lockedObject);
        Set<CDOLockOwner> readLockOwners = this.getReadLockOwners();
        builder.append(", readLockOwners=");
        if (!ObjectUtil.isEmpty(readLockOwners)) {
            boolean first = true;
            for (CDOLockOwner lockOwner : readLockOwners) {
                AbstractCDOLockState.appendLockOwner(builder, lockOwner, first);
                first = false;
            }
        } else {
            builder.append("NONE");
        }
        CDOLockOwner writeLockOwner = this.getWriteLockOwner();
        builder.append(", writeLockOwner=");
        builder.append(writeLockOwner != null ? writeLockOwner : "NONE");
        CDOLockOwner writeOptionOwner = this.getWriteOptionOwner();
        builder.append(", writeOptionOwner=");
        builder.append(writeOptionOwner != null ? writeOptionOwner : "NONE");
        builder.append("]");
        return builder.toString();
    }

    @Override
    public final CDOLockDelta addOwner(CDOLockOwner owner, IRWLockManager.LockType type) {
        switch (type) {
            case READ: {
                return this.addReadOwner(owner);
            }
            case WRITE: {
                return this.addWriteOwner(owner);
            }
            case OPTION: {
                return this.addOptionOwner(owner);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    @Override
    public final CDOLockDelta removeOwner(CDOLockOwner owner, IRWLockManager.LockType type) {
        switch (type) {
            case READ: {
                return this.removeReadOwner(owner);
            }
            case WRITE: {
                return this.removeWriteOwner(owner);
            }
            case OPTION: {
                return this.removeOptionOwner(owner);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    @Override
    public final CDOLockDelta[] clearOwner(CDOLockOwner owner) {
        List<CDOLockDelta> deltas = null;
        deltas = CDOLockUtil.appendLockDelta(deltas, this.removeReadOwner(owner));
        deltas = CDOLockUtil.appendLockDelta(deltas, this.removeWriteOwner(owner));
        deltas = CDOLockUtil.appendLockDelta(deltas, this.removeOptionOwner(owner));
        return CDOLockUtil.toArray(deltas);
    }

    protected abstract CDOLockDelta addReadOwner(CDOLockOwner var1);

    protected abstract CDOLockDelta addWriteOwner(CDOLockOwner var1);

    protected abstract CDOLockDelta addOptionOwner(CDOLockOwner var1);

    protected abstract CDOLockDelta removeReadOwner(CDOLockOwner var1);

    protected abstract CDOLockDelta removeWriteOwner(CDOLockOwner var1);

    protected abstract CDOLockDelta removeOptionOwner(CDOLockOwner var1);

    @Override
    @Deprecated
    public final void addReadLockOwner(CDOLockOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeReadLockOwner(CDOLockOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void setWriteLockOwner(CDOLockOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void setWriteOptionOwner(CDOLockOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeOwner(CDOLockOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void updateFrom(CDOLockState source) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void updateFrom(Object object, CDOLockState source) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void dispose() {
        throw new UnsupportedOperationException();
    }

    public static void appendLockOwner(StringBuilder builder, CDOLockOwner lockOwner, boolean first) {
        if (!first) {
            builder.append("+");
        }
        builder.append('[');
        AbstractCDOLockState.appendLockOwner(builder, lockOwner);
        builder.append(']');
    }

    public static void appendLockOwner(StringBuilder builder, CDOLockOwner lockOwner) {
        builder.append(lockOwner.getSessionID());
        builder.append(':');
        builder.append(lockOwner.getViewID());
        String durableLockingID = lockOwner.getDurableLockingID();
        if (durableLockingID != null) {
            builder.append(':');
            builder.append(durableLockingID);
        }
    }
}

