/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.launching.ITestEngine;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public class TestEngineManager {
    private static TestEngineManager instance;
    private static final String TESTENGINE_EXTPT = "org.eclipse.rcptt.launching.testEngine";
    private static final String TESTENGINE_ID_ATTR = "id";
    private static final String TESTENGINE_NAME_ATTR = "name";
    private static final String TESTENGINE_CONFIG_ATTR = "parameters";
    private static final String TESTENGINE_CLASS_ATTR = "class";
    private final List<TestEngineExtension> engines;
    private List<TestEngineExtension> enabledEngines;
    private Map<String, String> engineStatuses;
    private Map<String, Map<String, String>> config;

    public static TestEngineManager getInstance() {
        if (instance == null) {
            instance = new TestEngineManager();
        }
        return instance;
    }

    public TestEngineManager() {
        IConfigurationElement[] elements;
        ArrayList<TestEngineExtension> extensions = new ArrayList<TestEngineExtension>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TESTENGINE_EXTPT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(TESTENGINE_ID_ATTR);
            String name = element.getAttribute(TESTENGINE_NAME_ATTR);
            String params = element.getAttribute(TESTENGINE_CONFIG_ATTR);
            try {
                ITestEngine engine = (ITestEngine)element.createExecutableExtension(TESTENGINE_CLASS_ATTR);
                extensions.add(new TestEngineExtension(id, name, params, engine));
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(MessageFormat.format("Failed to add {0} engine", name), e);
            }
            ++n2;
        }
        this.engines = extensions;
    }

    public List<TestEngineExtension> getEngines() {
        return this.engines;
    }

    public void fireTestRunStarted(Map<String, Map<String, String>> config, List<Q7TestCase> tests) {
        this.applyConfig(config);
        for (TestEngineExtension engine : this.enabledEngines) {
            engine.getEngine().testRunStarted(engine.getConfig(), tests);
        }
    }

    public void fireTestRunCompleted() {
        for (TestEngineExtension engine : this.enabledEngines) {
            engine.getEngine().testRunCompleted();
        }
        this.cleanConfig();
    }

    public void fireSessionStarted(ExecutionSession session) {
        if (this.config == null || this.config.isEmpty()) {
            this.applyDefaultConfig(session);
        }
        for (TestEngineExtension engine : this.enabledEngines) {
            engine.getEngine().sessionStarted(session);
        }
    }

    public void fireSessionCompleted(ExecutionSession session) {
        for (TestEngineExtension engine : this.enabledEngines) {
            engine.getEngine().sessionCompleted(session);
        }
    }

    public void fireExecutionStarted(EclScenarioExecutable scenario) {
        for (TestEngineExtension engine : this.enabledEngines) {
            engine.getEngine().executionStarted(scenario, engine.getEngine().getConfiguration());
        }
    }

    public void fireExecutionCompleted(EclScenarioExecutable scenario, Report report) {
        for (TestEngineExtension engine : this.enabledEngines) {
            engine.getEngine().executionCompleted(scenario, report);
        }
    }

    public String validateParameter(String engineId, String paramName, String paramValue) {
        TestEngineExtension engine = this.engines.stream().filter(testEngine -> testEngine.getId().equals(engineId)).findFirst().orElse(null);
        return engine.getEngine().validateParameter(paramName, paramValue);
    }

    private void applyDefaultConfig(ExecutionSession session) {
        try {
            Q7TestLaunch launch = session.getLaunch();
            if (launch != null) {
                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                this.engineStatuses = configuration.getAttribute("org.eclipse.rcptt.launching.ATTR_TEST_ENGINES", Collections.emptyMap());
            }
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log("Failed to request enabled Test Engines", e);
            this.engineStatuses = Collections.emptyMap();
        }
        this.enabledEngines = this.getEnabledEngines();
    }

    private void applyConfig(Map<String, Map<String, String>> config) {
        HashMap<String, String> statuses = new HashMap<String, String>();
        for (TestEngineExtension engine : this.engines) {
            String paramsString = engine.getConfigParams();
            if (paramsString == null || paramsString.equals("")) {
                statuses.put(engine.getId(), "false");
                continue;
            }
            String id = engine.getId();
            Map<String, String> engineConfig = config.get(id);
            if (engineConfig == null) {
                statuses.put(engine.getId(), "false");
                continue;
            }
            List<String> allParams = Arrays.asList(paramsString.split("\\s*,\\s*"));
            ArrayList<String> requiredParams = new ArrayList<String>();
            for (String param2 : allParams) {
                if (!param2.endsWith("*")) continue;
                param2 = param2.substring(0, param2.length() - 1);
                requiredParams.add(param2);
            }
            boolean allRequiredParamsAreProvided = requiredParams.stream().allMatch(param -> engineConfig.containsKey(param));
            boolean anyParamsAreProvided = allParams.stream().anyMatch(param -> engineConfig.containsKey(param));
            statuses.put(engine.getId(), String.valueOf(allRequiredParamsAreProvided));
            if (!allRequiredParamsAreProvided && anyParamsAreProvided) {
                Q7LaunchingPlugin.log(MessageFormat.format("{0} engine is not enabled, because not all required parameters were specified", engine.getName()));
            }
            engine.setConfig(engineConfig);
            engine.engine.setConfiguration(engineConfig);
        }
        this.engineStatuses = statuses;
        this.enabledEngines = this.getEnabledEngines();
        this.config = config;
    }

    private void cleanConfig() {
        this.engineStatuses = Collections.emptyMap();
        this.enabledEngines = Collections.emptyList();
        this.config = Collections.emptyMap();
    }

    private List<TestEngineExtension> getEnabledEngines() {
        List<TestEngineExtension> enablesEngines = this.engines.stream().filter(extension -> this.testEngineIsEnabled((TestEngineExtension)extension)).collect(Collectors.toList());
        return enablesEngines;
    }

    private boolean testEngineIsEnabled(TestEngineExtension extension) {
        String id = extension.getId();
        String enabled = this.engineStatuses.get(id);
        return enabled != null && enabled.equals("true");
    }

    public class TestEngineExtension {
        private String id;
        private String name;
        private String params;
        private ITestEngine engine;
        private Map<String, String> config;

        public TestEngineExtension(String id, String name, String params, ITestEngine engine) {
            this.id = id;
            this.name = name;
            this.params = params;
            this.engine = engine;
            this.config = Collections.emptyMap();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigParams() {
            return this.params;
        }

        public ITestEngine getEngine() {
            return this.engine;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, String> config) {
            this.config = config;
        }
    }
}

