/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.wizards.feature.CreateFeatureProjectOperation;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.widgets.Shell;

public class CreateFeatureProjectFromLaunchOperation
extends CreateFeatureProjectOperation {
    private ILaunchConfiguration fLaunchConfig;

    public CreateFeatureProjectFromLaunchOperation(IProject project, IPath location, FeatureData featureData, ILaunchConfiguration launchConfig, Shell shell) {
        super(project, location, featureData, null, shell);
        this.fLaunchConfig = launchConfig;
    }

    @Override
    protected void configureFeature(IFeature feature, WorkspaceFeatureModel model) throws CoreException {
        this.fPlugins = this.getPlugins();
        super.configureFeature(feature, model);
    }

    private IPluginBase[] getPlugins() {
        Set<Object> models = Collections.emptySet();
        try {
            ILaunchConfigurationType type = this.fLaunchConfig.getType();
            String id = type.getIdentifier();
            if (id.equals("org.eclipse.pde.ui.RuntimeWorkbench")) {
                models = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)this.fLaunchConfig, (boolean)false).keySet();
            } else if (id.equals("org.eclipse.pde.ui.EquinoxLauncher")) {
                models = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)this.fLaunchConfig, (boolean)true).keySet();
            }
        }
        catch (CoreException coreException) {}
        return (IPluginBase[])models.stream().map(IPluginModelBase::getPluginBase).toArray(IPluginBase[]::new);
    }
}

