/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.codemining.CodeMiningManager;
import org.eclipse.jface.internal.text.codemining.ICodeMiningAnnotation;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CodeMiningLineHeaderAnnotation
extends LineHeaderAnnotation
implements ICodeMiningAnnotation {
    private static final String SEPARATOR = " | ";
    private ICodeMining[] fResolvedMinings = null;
    private final List<ICodeMining> fMinings = new ArrayList<ICodeMining>();
    private final List<Rectangle> fBounds = new ArrayList<Rectangle>();
    private IProgressMonitor fMonitor;

    public CodeMiningLineHeaderAnnotation(Position position, ISourceViewer viewer) {
        super(position, viewer);
    }

    @Override
    public int getHeight() {
        return this.hasAtLeastOneResolvedMiningNotEmpty() ? super.getHeight() : 0;
    }

    private boolean hasAtLeastOneResolvedMiningNotEmpty() {
        if (this.fMinings.stream().anyMatch(m -> m.getLabel() != null && !m.getLabel().isEmpty())) {
            return true;
        }
        if (this.fResolvedMinings == null || this.fResolvedMinings.length == 0) {
            return false;
        }
        return Stream.of(this.fResolvedMinings).anyMatch(CodeMiningManager::isValidMining);
    }

    @Override
    public void update(List<ICodeMining> minings, IProgressMonitor monitor) {
        if (this.fResolvedMinings == null || this.fResolvedMinings.length != minings.size()) {
            this.fResolvedMinings = new ICodeMining[minings.size()];
        }
        int length = Math.min(this.fMinings.size(), minings.size());
        int i = 0;
        while (i < length) {
            ICodeMining mining = this.fMinings.get(i);
            if (mining.getLabel() != null) {
                this.fResolvedMinings[i] = mining;
            }
            ++i;
        }
        this.disposeMinings();
        this.fMonitor = monitor;
        this.fMinings.addAll(minings);
    }

    public void markDeleted(boolean deleted) {
        super.markDeleted(deleted);
        if (deleted) {
            this.disposeMinings();
            this.fResolvedMinings = null;
        }
    }

    private void disposeMinings() {
        this.fMinings.stream().forEach(ICodeMining::dispose);
        this.fMinings.clear();
    }

    @Override
    public void draw(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(this.fMinings);
        int nbDraw = 0;
        int separatorWidth = -1;
        boolean redrawn = false;
        this.fBounds.clear();
        int i = 0;
        while (i < minings.size()) {
            ICodeMining lastResolvedMining;
            ICodeMining mining = (ICodeMining)minings.get(i);
            ICodeMining iCodeMining = lastResolvedMining = this.fResolvedMinings != null && this.fResolvedMinings.length > i ? this.fResolvedMinings[i] : null;
            if (mining.getLabel() != null) {
                this.fResolvedMinings[i] = mining;
            } else if (!mining.isResolved()) {
                mining = lastResolvedMining;
                if (!redrawn) {
                    this.redraw();
                    redrawn = true;
                }
            } else {
                mining = lastResolvedMining;
            }
            if (CodeMiningManager.isValidMining(mining)) {
                if (nbDraw > 0) {
                    this.initGC(textWidget, color, gc);
                    gc.drawText(SEPARATOR, x, y);
                    if (separatorWidth == -1) {
                        separatorWidth = gc.stringExtent((String)SEPARATOR).x;
                    }
                    x += separatorWidth;
                }
                this.initGC(textWidget, color, gc);
                Point loc = mining.draw(gc, textWidget, color, x, y);
                this.fBounds.add(new Rectangle(x, y, loc.x, loc.y));
                x += loc.x;
                ++nbDraw;
            }
            ++i;
        }
    }

    private void initGC(StyledText textWidget, Color color, GC gc) {
        gc.setForeground(color);
        gc.setBackground(textWidget.getBackground());
        gc.setFont(textWidget.getFont());
    }

    @Override
    public void redraw() {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(this.fMinings);
        for (ICodeMining mining : minings) {
            if (mining.isResolved()) continue;
            mining.resolve(this.getViewer(), this.fMonitor).thenRunAsync(() -> this.redraw());
            return;
        }
        super.redraw();
    }

    @Override
    public Consumer<MouseEvent> getAction(MouseEvent e) {
        ICodeMining mining = CodeMiningManager.getValidCodeMiningAtLocation(this.fResolvedMinings, this.fBounds, e.x, e.y);
        return mining != null ? mining.getAction() : null;
    }

    @Override
    public boolean isInVisibleLines() {
        return super.isInVisibleLines();
    }
}

