/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.eclipse.mat.util.FileUtils;

public class ChunkedGZIPRandomAccessFile
extends RandomAccessFile {
    static final String HPROF_BLOCKSIZE = "HPROF BLOCKSIZE=";
    private static FileOffsetComparator fileOffsetComp = new FileOffsetComparator();
    private static OffsetComparator offsetComp = new OffsetComparator();
    private static final int READ_SIZE = 65536;
    private static final HashMap<File, StoredOffsetMapping> cachedOffsets = new HashMap();
    private Buffer last;
    private final long fileSize;
    private final long modTime;
    private final File file;
    private final int cacheSize;
    private final int maxCachedBuffers;
    private final byte[] in;
    private final ArrayList<Buffer> buffers;
    private final Inflater inf;
    private final Buffer cacheHead;
    private int cachedBuffers;
    private long pos;

    private ChunkedGZIPRandomAccessFile(File file, int bufferSize, int maxCachedBuffers) throws FileNotFoundException, IOException {
        super(file, "r");
        this.file = file;
        this.last = null;
        this.pos = 0L;
        this.fileSize = super.length();
        this.modTime = file.lastModified();
        this.cacheSize = bufferSize;
        this.maxCachedBuffers = maxCachedBuffers;
        this.cachedBuffers = 0;
        this.in = new byte[65536];
        this.buffers = new ArrayList();
        this.inf = new Inflater(true);
        this.cacheHead = new Buffer(-1L, -1L);
        this.cacheHead.setNext(this.cacheHead);
        this.cacheHead.setPrev(this.cacheHead);
        this.buffers.add(new Buffer(0L, 0L));
    }

    private ChunkedGZIPRandomAccessFile(File file, StoredOffsetMapping mapping, int maxCachedBuffers) throws FileNotFoundException, IOException {
        super(file, "r");
        this.file = file;
        this.last = null;
        this.pos = 0L;
        this.fileSize = super.length();
        this.modTime = file.lastModified();
        this.cacheSize = mapping.bufferSize;
        this.maxCachedBuffers = maxCachedBuffers;
        this.cachedBuffers = 0;
        this.in = new byte[65536];
        this.inf = new Inflater(true);
        this.cacheHead = new Buffer(-1L, -1L);
        this.cacheHead.setNext(this.cacheHead);
        this.cacheHead.setPrev(this.cacheHead);
        ArrayList<Buffer> previousBuffers = mapping.getBuffers();
        if (previousBuffers != null) {
            this.buffers = previousBuffers;
        } else {
            this.buffers = new ArrayList();
            this.buffers.add(new Buffer(0L, 0L));
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException();
        }
        this.pos = pos;
    }

    @Override
    public long getFilePointer() {
        return this.pos;
    }

    @Override
    public long length() {
        return Long.MAX_VALUE;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int result = this.read(b, 0, 1);
        if (result == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int result = this.read(this.pos, buf, off, len);
        if (result > 0) {
            this.pos += (long)result;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            ChunkedGZIPRandomAccessFile.reuseMapping(this.file, new StoredOffsetMapping(this.buffers, this.cacheSize, this.fileSize, this.modTime));
        }
        finally {
            super.close();
        }
    }

    public synchronized long getLastPhysicalReadPosition() {
        if (this.last != null) {
            return this.last.fileOffset;
        }
        return 0L;
    }

    public synchronized int read(long offset, byte[] b, int off, int len) throws IOException {
        Buffer buf = this.last;
        while (buf == null || buf.getOffset() > offset || buf.getOffset() + (long)buf.getCacheLen() <= offset) {
            int pos = Collections.binarySearch(this.buffers, new Buffer(0L, offset), offsetComp);
            buf = this.buffers.get(pos >= 0 ? pos : -pos - 2);
            if (buf.getFileOffset() >= this.fileSize) {
                return -1;
            }
            if (buf.getCache() != null) {
                this.last = buf;
                if (this.cacheHead.getNext() == buf) continue;
                this.remove(buf);
                this.addFirst(buf);
                continue;
            }
            try {
                this.loadBuffer(buf);
                if (buf.getCacheLen() != 0) continue;
                return -1;
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }
        int copyOffset = (int)(offset - buf.getOffset());
        int toCopyMax = buf.getCacheLen() - copyOffset;
        int toCopy = Math.min(toCopyMax, len);
        if (toCopy <= 0) {
            return -1;
        }
        System.arraycopy(buf.getCache(), copyOffset, b, off, toCopy);
        return toCopy;
    }

    public static boolean isChunkedGZIPFile(RandomAccessFile raf) throws IOException {
        return ChunkedGZIPRandomAccessFile.getChunkSize(raf) > 0;
    }

    private static int getChunkSize(RandomAccessFile raf) throws IOException {
        long oldPos = raf.getFilePointer();
        try {
            String expectedPrefix;
            int b;
            raf.seek(0L);
            int header = raf.readInt();
            if (header >>> 8 != 2067208) {
                return -1;
            }
            if ((header & 0x10) == 0) {
                return -1;
            }
            raf.readInt();
            raf.readChar();
            if ((header & 4) != 0) {
                int ch2;
                int ch1 = raf.read();
                if ((ch1 | (ch2 = raf.read())) < 0) {
                    throw new EOFException();
                }
                int extraLen = ch1 + (ch2 << 8);
                while (extraLen > 0) {
                    int skipped = raf.skipBytes(extraLen);
                    if (skipped <= 0) {
                        throw new EOFException();
                    }
                    extraLen -= skipped;
                }
            }
            if ((header & 8) != 0) {
                while (raf.read() != 0) {
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((b = raf.read()) > 0) {
                bos.write(b);
            }
            String comment = bos.toString("UTF-8");
            if (comment.startsWith(expectedPrefix = HPROF_BLOCKSIZE)) {
                String chunkSizeStr = comment.substring(expectedPrefix.length()).split(" ")[0];
                try {
                    int chunkSize = Integer.parseInt(chunkSizeStr);
                    if (chunkSize > 0) {
                        int n = chunkSize;
                        return n;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return -1;
        }
        finally {
            raf.seek(oldPos);
        }
    }

    public static synchronized ChunkedGZIPRandomAccessFile get(RandomAccessFile raf, File file) throws IOException {
        int cacheSizeInMB = 5;
        int maxStoredMappings = 5;
        StoredOffsetMapping mapping = cachedOffsets.get(file.getAbsoluteFile());
        while (cachedOffsets.size() > Math.max(1, maxStoredMappings)) {
            long oldestTime = Long.MAX_VALUE;
            File oldestFile = null;
            for (Map.Entry<File, StoredOffsetMapping> e : cachedOffsets.entrySet()) {
                File f = e.getKey();
                long entryTime = e.getValue().getCreationDate();
                if (entryTime >= oldestTime) continue;
                oldestFile = f;
                oldestTime = entryTime;
            }
            if (oldestFile == null) continue;
            cachedOffsets.remove(oldestFile);
        }
        int chunkSize = ChunkedGZIPRandomAccessFile.getChunkSize(raf);
        if (chunkSize > 0) {
            long nrOfChunks = Math.max(1L, Math.min(1000L, (long)cacheSizeInMB * 1024L * 1024L / (long)chunkSize));
            long fileSize = file.length();
            long modTime = file.lastModified();
            if (mapping != null && mapping.getFileSize() == fileSize && mapping.getBufferSize() == chunkSize && mapping.getLastModTime() == modTime) {
                return new ChunkedGZIPRandomAccessFile(file, mapping, (int)nrOfChunks);
            }
            cachedOffsets.remove(file.getAbsoluteFile());
            return new ChunkedGZIPRandomAccessFile(file, chunkSize, (int)nrOfChunks);
        }
        return null;
    }

    public static synchronized void forget(File file) {
        cachedOffsets.remove(file.getAbsoluteFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compressFileChunked(File toCompress, File compressed) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(toCompress), 65536);
            try {
                block18: {
                    FileOutputStream fos = new FileOutputStream(compressed);
                    try {
                        try (ChunkedGZIPOutputStream os = new ChunkedGZIPOutputStream(new BufferedOutputStream(fos, 65536), toCompress);){
                            FileUtils.copy((InputStream)is, (OutputStream)os);
                        }
                        if (fos == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void compressFileChunked2(File toCompress, File compressed) throws IOException {
        Deflater def = new Deflater(-1, true);
        CRC32 crc = new CRC32();
        boolean finished = false;
        int chunkSize = 0x100000;
        String comment = HPROF_BLOCKSIZE + chunkSize;
        boolean writtenComment = false;
        byte[] readBuf = new byte[chunkSize];
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        byte[] defaultHeader = byArray;
        try {
            Throwable throwable = null;
            Object var11_12 = null;
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(toCompress), 65536);
                try {
                    try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(compressed), 65536);){
                        while (!finished) {
                            def.reset();
                            crc.reset();
                            if (writtenComment) {
                                ((OutputStream)os).write(defaultHeader);
                            } else {
                                ((OutputStream)os).write(defaultHeader, 0, 3);
                                ((OutputStream)os).write(16);
                                ((OutputStream)os).write(defaultHeader, 4, 6);
                                ((OutputStream)os).write(comment.getBytes(StandardCharsets.US_ASCII));
                                ((OutputStream)os).write(0);
                                writtenComment = true;
                            }
                            int left = chunkSize;
                            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)os, def, 65536);
                            while (left > 0) {
                                int read = ((InputStream)is).read(readBuf, 0, left);
                                if (read <= 0) {
                                    finished = true;
                                    break;
                                }
                                dos.write(readBuf, 0, read);
                                crc.update(readBuf, 0, read);
                                left -= read;
                            }
                            dos.finish();
                            int crcVal = (int)crc.getValue();
                            ChunkedGZIPRandomAccessFile.writeInt(crcVal, os);
                            ChunkedGZIPRandomAccessFile.writeInt(chunkSize - left, os);
                        }
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            def.finish();
        }
    }

    private static void writeInt(int val, OutputStream os) throws IOException {
        os.write((byte)(val & 0xFF));
        os.write((byte)(val >> 8 & 0xFF));
        os.write((byte)(val >> 16 & 0xFF));
        os.write((byte)(val >> 24 & 0xFF));
    }

    private static synchronized void reuseMapping(File file, StoredOffsetMapping mapping) {
        StoredOffsetMapping oldMapping = cachedOffsets.get(file.getAbsoluteFile());
        if (oldMapping == null || oldMapping.shouldBeReplacedBy(mapping)) {
            cachedOffsets.put(file.getAbsoluteFile(), mapping);
        }
    }

    private void loadBuffer(Buffer buf) throws IOException, DataFormatException {
        long nextOffset;
        long nextFileOffset;
        Buffer nextChunk;
        int pos;
        int len;
        if (this.cachedBuffers >= this.maxCachedBuffers) {
            Buffer toRemove = this.cacheHead.getPrev();
            this.remove(toRemove);
            buf.setCache(toRemove.getCache());
            toRemove.setCache(null);
        } else {
            buf.setCache(new byte[this.cacheSize]);
            ++this.cachedBuffers;
        }
        this.last = buf;
        this.addFirst(buf);
        this.inf.reset();
        super.seek(buf.getFileOffset());
        int read = super.read(this.in, 0, 65536);
        if (read == -1) {
            buf.setCacheLen(0);
            return;
        }
        int inCount = Math.max(4, read);
        int outCount = 0;
        if (read < 4) {
            super.readFully(this.in, read, 4 - read);
            read = 4;
        }
        if (this.in[0] != 31 || (this.in[1] & 0xFF) != 139) {
            throw new IOException("Missing gzip id");
        }
        if (this.in[2] != 8) {
            throw new IOException("Only supports deflate");
        }
        int off = 10;
        if ((this.in[3] & 4) != 0) {
            len = (this.in[off + 1] & 0xFF) * 256 + (this.in[off] & 0xFF);
            off += 2 + len;
        }
        if ((this.in[3] & 8) != 0) {
            len = 0;
            while (this.in[off + len] != 0) {
                ++len;
            }
            off += len + 1;
        }
        if ((this.in[3] & 0x10) != 0) {
            len = 0;
            while (this.in[off + len] != 0) {
                ++len;
            }
            off += len + 1;
        }
        if ((this.in[3] & 2) != 0) {
            off += 2;
        }
        this.inf.setInput(this.in, off, read - off);
        outCount = this.inf.inflate(buf.getCache(), 0, buf.getCache().length);
        while (!this.inf.finished()) {
            if (this.inf.needsInput()) {
                read = super.read(this.in, 0, 65536);
                this.inf.setInput(this.in, 0, read);
                inCount += read;
            }
            outCount += this.inf.inflate(buf.getCache(), outCount, buf.getCache().length - outCount);
        }
        if ((this.inf.getRemaining() != 0 || (long)inCount + buf.getFileOffset() + 8L != this.fileSize) && (pos = Collections.binarySearch(this.buffers, nextChunk = new Buffer(nextFileOffset = (long)(inCount - this.inf.getRemaining()) + buf.getFileOffset() + 8L, nextOffset = (long)outCount + buf.getOffset()), fileOffsetComp)) < 0) {
            this.buffers.add(-pos - 1, nextChunk);
        }
        buf.setCacheLen(outCount);
    }

    private void addFirst(Buffer buf) {
        assert (buf.getNext() == null);
        assert (buf.getPrev() == null);
        assert (buf.getCache() != null);
        if (this.cacheHead.getPrev() == this.cacheHead) {
            this.cacheHead.setPrev(buf);
        }
        this.cacheHead.getNext().setPrev(buf);
        buf.setNext(this.cacheHead.getNext());
        buf.setPrev(this.cacheHead);
        this.cacheHead.setNext(buf);
    }

    private void remove(Buffer buf) {
        assert (buf.getPrev() != null);
        assert (buf.getNext() != null);
        assert (buf.getCache() != null);
        assert (this.cacheHead.getPrev() != this.cacheHead);
        buf.getPrev().setNext(buf.getNext());
        buf.getNext().setPrev(buf.getPrev());
        buf.setNext(null);
        buf.setPrev(null);
    }

    private static class Buffer {
        private final long fileOffset;
        private final long offset;
        private BufferContent content;

        public Buffer(long fileOffset, long offset) {
            this.fileOffset = fileOffset;
            this.offset = offset;
            this.content = null;
        }

        private void removeContentIfPossible() {
            if (this.content.next == null && this.content.prev == null && this.content.cache == null) {
                this.content = null;
            }
        }

        public Buffer getNext() {
            if (this.content != null) {
                return this.content.next;
            }
            return null;
        }

        public void setNext(Buffer next) {
            if (next == null) {
                if (this.content != null) {
                    this.content.next = null;
                    this.removeContentIfPossible();
                }
                return;
            }
            if (this.content == null) {
                this.content = new BufferContent();
            }
            this.content.next = next;
        }

        public Buffer getPrev() {
            if (this.content != null) {
                return this.content.prev;
            }
            return null;
        }

        public void setPrev(Buffer prev) {
            if (prev == null) {
                if (this.content != null) {
                    this.content.prev = null;
                    this.removeContentIfPossible();
                }
                return;
            }
            if (this.content == null) {
                this.content = new BufferContent();
            }
            this.content.prev = prev;
        }

        public byte[] getCache() {
            if (this.content != null) {
                return this.content.cache;
            }
            return null;
        }

        public void setCache(byte[] cache) {
            if (cache == null) {
                if (this.content != null) {
                    this.content.cache = null;
                    this.removeContentIfPossible();
                }
                return;
            }
            if (this.content == null) {
                this.content = new BufferContent();
            }
            this.content.cache = cache;
        }

        public int getCacheLen() {
            if (this.content != null) {
                return this.content.cacheLen;
            }
            return 0;
        }

        public void setCacheLen(int cacheLen) {
            if (cacheLen == 0 && this.content == null) {
                return;
            }
            this.content.cacheLen = cacheLen;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public long getOffset() {
            return this.offset;
        }

        private static class BufferContent {
            public byte[] cache;
            public int cacheLen;
            public Buffer next;
            public Buffer prev;

            private BufferContent() {
            }
        }
    }

    static class ChunkedGZIPOutputStream
    extends FilterOutputStream {
        Deflater def = new Deflater(-1, true);
        CRC32 crc = new CRC32();
        int chunkSize = 0x100000;
        String comment = "HPROF BLOCKSIZE=" + this.chunkSize;
        boolean writtenComment = false;
        boolean writeHeader = true;
        byte[] defaultHeader;
        int left;
        DeflaterOutputStream dos;
        String fn;

        public ChunkedGZIPOutputStream(OutputStream os) {
            super(os);
            byte[] byArray = new byte[10];
            byArray[0] = 31;
            byArray[1] = -117;
            byArray[2] = 8;
            byArray[3] = 2;
            this.defaultHeader = byArray;
        }

        public ChunkedGZIPOutputStream(OutputStream os, File originalFile) {
            super(os);
            byte[] byArray = new byte[10];
            byArray[0] = 31;
            byArray[1] = -117;
            byArray[2] = 8;
            byArray[3] = 2;
            this.defaultHeader = byArray;
            this.fn = originalFile.getName().replaceFirst(".gz(ip)?$", "");
            long lastMod = originalFile.lastModified();
            if (lastMod == 0L) {
                lastMod = System.currentTimeMillis();
            }
            lastMod /= 1000L;
            lastMod = Math.min(lastMod, Integer.MAX_VALUE);
            this.defaultHeader[4] = (byte)lastMod;
            this.defaultHeader[5] = (byte)(lastMod >> 8);
            this.defaultHeader[6] = (byte)(lastMod >> 16);
            this.defaultHeader[7] = (byte)(lastMod >> 24);
            String opsys = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            this.defaultHeader[9] = opsys.contains("linux") || opsys.contains("unix") || opsys.contains("aix") ? 3 : (opsys.contains("mac") ? 7 : (opsys.contains("win") ? 11 : -1));
        }

        @Override
        public void write(int b) throws IOException {
            if (this.writeHeader) {
                this.header();
            }
            this.dos.write(b);
            this.crc.update(b);
            if (--this.left <= 0) {
                this.flush();
            }
        }

        @Override
        public void write(byte[] b, int offset, int len) throws IOException {
            while (len > 0) {
                if (this.writeHeader) {
                    this.header();
                }
                int len1 = Math.min(len, this.left);
                this.dos.write(b, offset, len1);
                this.crc.update(b, offset, len1);
                offset += len1;
                len -= len1;
                this.left -= len1;
                if (this.left > 0) continue;
                this.flush();
            }
        }

        private void header() throws IOException {
            this.def.reset();
            this.crc.reset();
            if (this.writtenComment) {
                this.out.write(this.defaultHeader);
                this.crc.update(this.defaultHeader);
            } else {
                this.out.write(this.defaultHeader, 0, 3);
                this.crc.update(this.defaultHeader, 0, 3);
                int flags = this.defaultHeader[3] | 0x10;
                if (this.fn != null) {
                    flags |= 8;
                }
                this.out.write(flags);
                this.crc.update(flags);
                this.out.write(this.defaultHeader, 4, 6);
                this.crc.update(this.defaultHeader, 4, 6);
                if (this.fn != null) {
                    this.out.write(this.fn.getBytes(StandardCharsets.UTF_8));
                    this.crc.update(this.fn.getBytes(StandardCharsets.UTF_8));
                    this.out.write(0);
                    this.crc.update(0);
                }
                this.out.write(this.comment.getBytes(StandardCharsets.US_ASCII));
                this.crc.update(this.comment.getBytes(StandardCharsets.US_ASCII));
                this.out.write(0);
                this.crc.update(0);
                this.writtenComment = true;
            }
            if ((this.defaultHeader[3] & 2) != 0) {
                this.out.write((int)(this.crc.getValue() & 0xFFL));
                this.out.write((int)(this.crc.getValue() >> 8 & 0xFFL));
            }
            this.crc.reset();
            this.dos = new DeflaterOutputStream(this.out, this.def, 65536);
            this.left = this.chunkSize;
            this.writeHeader = false;
        }

        @Override
        public void flush() throws IOException {
            if (!this.writeHeader) {
                this.dos.finish();
                int crcVal = (int)this.crc.getValue();
                ChunkedGZIPRandomAccessFile.writeInt(crcVal, this.out);
                ChunkedGZIPRandomAccessFile.writeInt(this.chunkSize - this.left, this.out);
                this.writeHeader = true;
            }
            super.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                if (!this.writtenComment) {
                    this.header();
                }
                this.flush();
                this.def.finish();
                this.dos.close();
                this.def.end();
            }
            finally {
                super.close();
            }
        }
    }

    private static class FileOffsetComparator
    implements Comparator<Buffer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FileOffsetComparator() {
        }

        @Override
        public int compare(Buffer x, Buffer y) {
            return Long.compare(x.getFileOffset(), y.getFileOffset());
        }
    }

    private static class OffsetComparator
    implements Comparator<Buffer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private OffsetComparator() {
        }

        @Override
        public int compare(Buffer x, Buffer y) {
            return Long.compare(x.getOffset(), y.getOffset());
        }
    }

    private static class StoredOffsetMapping {
        private final int[] lengths;
        private final int[] fileLengths;
        private final int bufferSize;
        private final long fileSize;
        private final long lastModTime;
        private final long creationDate;

        public StoredOffsetMapping(List<Buffer> buffers, int bufferSize, long fileSize, long lastModTime) {
            this.bufferSize = bufferSize;
            this.fileSize = fileSize;
            this.lastModTime = lastModTime;
            this.creationDate = System.currentTimeMillis();
            long lastFileOffset = 0L;
            long lastOffset = 0L;
            long overflowCheck = 0L;
            int[] lengths = new int[buffers.size()];
            int[] fileLengths = new int[buffers.size()];
            int i = 0;
            while (i < lengths.length) {
                Buffer b = buffers.get(i);
                long fileChunkSize = b.getFileOffset() - lastFileOffset;
                long chunkSize = b.getOffset() - lastOffset;
                overflowCheck |= fileChunkSize | chunkSize;
                lastFileOffset = b.getFileOffset();
                lastOffset = b.getOffset();
                fileLengths[i] = (int)fileChunkSize;
                lengths[i] = (int)chunkSize;
                ++i;
            }
            if (overflowCheck > Integer.MAX_VALUE) {
                this.fileLengths = null;
                this.lengths = null;
            } else {
                this.fileLengths = fileLengths;
                this.lengths = lengths;
            }
        }

        public long getCreationDate() {
            return this.creationDate;
        }

        public boolean shouldBeReplacedBy(StoredOffsetMapping other) {
            if (other.fileSize != this.fileSize || other.lastModTime != this.lastModTime) {
                return true;
            }
            return this.lengths.length < other.lengths.length;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getLastModTime() {
            return this.lastModTime;
        }

        public ArrayList<Buffer> getBuffers() {
            if (this.lengths == null) {
                return null;
            }
            ArrayList<Buffer> result = new ArrayList<Buffer>(this.lengths.length);
            long lastFileOffset = 0L;
            long lastOffset = 0L;
            int i = 0;
            while (i < this.lengths.length) {
                int fileSize = this.fileLengths[i];
                int size = this.lengths[i];
                result.add(new Buffer(lastFileOffset += (long)fileSize, lastOffset += (long)size));
                ++i;
            }
            return result;
        }
    }
}

